<!-- template="mla-overview" -->
<!-- title="Overview" order="1" -->
<p>The Views tab lets you manage the list of "Post MIME Type" entries used to generate the views for the Media/Library and Media/Assistant submenu tables, as well as the "Add Media" media items filter. In addition, MLA lets you define more complex "Table Views" for the Media/Assistant submenu table using multiple MIME types and/or wildcard specifications in one column.</p>
<p>All the Post MIME Type Views are listed in the table on the right, ordered by the Slug field. You can change the sort order by clicking on one of the blue column names.</p>
<p>You can use the Screen Options tab to customize the display of this screen. You can choose any combination of the columns available for display. You can also choose how many items appear on each page of the display.</p>
<p>You can narrow the list by entering a keyword or phrase in the text box in the upper-right corner and clicking "Search Views". <strong>NOTE:</strong> The "Search Views" filter is &#8220;sticky&#8221;, i.e., it will persist as you resort the display, edit items, etc. To clear it, delete the text and click "Search Views" or simply click on the "Views" tab.</p>
<!-- template="mla-bulk-actions" -->
<!-- title="Bulk Actions" order="2" -->
<p>The &#8220;Bulk Actions&#8221; dropdown list works with the check box column to let you make changes to many items at once. Click the check box in the column title row to select all items on the page, or click the check box in a row to select items individually.</p>
<p>Once you&#8217;ve selected the items you want, pick an action from the dropdown list and click Apply to perform the action on the selected items.</p>
<p>When using Bulk Edit, you can change some values (Post MIME, Table View and Menu Order) for all selected items at once. To remove an item from the grouping, just click the x next to its name in the left column of the Bulk Edit area.</p>
<!-- template="mla-available-actions" -->
<!-- title="Available Actions" order="3" -->
<p>Hovering over a row in the Slug column reveals action links such as Edit, Quick Edit and Delete Permanently. Clicking Edit displays a simple screen to edit that individual item&#8217;s metadata. Clicking Delete Permanently will delete the item from the Views list. Clicking Quick Edit displays an inline form to edit the item's metadata without leaving the menu screen.</p>
<!-- template="mla-add-new" -->
<!-- title="Add New View" order="4" -->
<p>The left-hand side of the screen contains all the fields you need to define a new item for the list. Slug is required; the other fields are not or have default values. There is more information about each field in the text under the value area.</p>
<p><strong>NOTE:</strong> To save your work and add the item, you must scroll down to the bottom of the screen and click "Add View."</p>
<!-- template="mla-save-changes" -->
<!-- title="Disable/Enable Views" order="5" -->
<p>If you have some other plugin or mechanism for handling the Post MIME Type items, you can disable MLA support entirely. Clear the checkbox at the bottom-left corner of the screen and click "Save Changes". The Views table will be replaced by a "disabled" screen and a checkbox that lets you turn MLA support back on when you want it.</p>
<!-- template="sidebar" -->
<p><strong>For more information:</strong></p>
<p><a href="[+settingsURL+]?page=mla-settings-menu-documentation&mla_tab=documentation#mla_views" target="_blank">MLA Documentation on MIME Type Views</a></p>
<p><a href="http://wordpress.org/support/plugin/media-library-assistant" target="_blank">MLA Support Forum</a></p>
