<div id="wpfc-modal-cdn77" style="top: 10.5px; left: 226px; position: absolute; padding: 6px; height: auto; width: 560px; z-index: 10001;">
	<div style="height: 100%; width: 100%; background: none repeat scroll 0% 0% rgb(0, 0, 0); position: absolute; top: 0px; left: 0px; z-index: -1; opacity: 0.5; border-radius: 8px;">
	</div>
	<div style="z-index: 600; border-radius: 3px;">
		<div style="font-family:Verdana,Geneva,Arial,Helvetica,sans-serif;font-size:12px;background: none repeat scroll 0px 0px rgb(255, 161, 0); z-index: 1000; position: relative; padding: 2px; border-bottom: 1px solid rgb(194, 122, 0); height: 35px; border-radius: 3px 3px 0px 0px;">
			<table width="100%" height="100%">
				<tbody>
					<tr>
						<td valign="middle" style="vertical-align: middle; font-weight: bold; color: rgb(255, 255, 255); text-shadow: 0px 1px 1px rgba(0, 0, 0, 0.5); padding-left: 10px; font-size: 13px; cursor: move;">CDN77 Settings</td>
						<td width="20" align="center" style="vertical-align: middle;"></td>
						<td width="20" align="center" style="vertical-align: middle; font-family: Arial,Helvetica,sans-serif; color: rgb(170, 170, 170); cursor: default;">
							<div title="Close Window" class="close-wiz"></div>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
		<div class="window-content-wrapper" style="padding: 8px;">
			<div style="z-index: 1000; height: auto; position: relative; display: inline-block; width: 100%;" class="window-content">


				<div id="wpfc-wizard-cdn77" class="wpfc-cdn-pages-container">
					<div wpfc-cdn-page="1" class="wiz-cont">
						<h1>Let's Get Started</h1>		
						<p>Hi! If you don't have a <strong>CDN77</strong> account, you can create one. If you already have, please continue...</p>
						<div class="wiz-input-cont" style="text-align:center;">
							<a href="https://www.cdn77.com/" target="_blank">
								<button class="wpfc-green-button">Create a CDN77 Account</button>
							</a>
					    </div>
					    <p class="wpfc-bottom-note" style="margin-bottom:-10px;"><a target="_blank" href="https://client.cdn77.com/support/knowledgebase/cms-integration/wordpress-cdn-integration-using-wp-fastest-cache">Note: Please read How to Integrate CDN77 into WP Fastest Cache</a></p>
					</div>
					<div wpfc-cdn-page="2" class="wiz-cont" style="display:none">
						<h1>Enter CDN Url</h1>		
						<p>Please enter your <strong>CDN77 CDN Url</strong> below to deliver your contents via CDN77.</p>
						<div class="wiz-input-cont">
							<label class="mc-input-label" for="cdn-url" style="padding-right: 12px;">CDN Url:</label><input type="text" name="" value="" class="api-key" id="cdn-url">
					    	<div id="cdn-url-loading"></div>
					    	<label class="wiz-error-msg"></label>
					    </div>
					    <div class="wiz-input-cont">
							<label class="mc-input-label" for="origin-url">Origin Url:</label><input type="text" name="" value="" class="api-key" id="origin-url">
					    </div>
					</div>
					<div wpfc-cdn-page="3" class="wiz-cont" style="display:none">
						<h1>File Types</h1>		
						<p>Specify the file types within the to host with the CDN.</p>
						
						<?php include WPFC_MAIN_PATH."templates/cdn/file_types.php"; ?>
					</div>
					<div wpfc-cdn-page="4" class="wiz-cont" style="display:none">
						<h1>Ready to Go!</h1>
						<p>You're all set! Click the finish button below and that's it.</p>
					</div>
					<div wpfc-cdn-page="5" class="wiz-cont" style="display:none">
						<h1>Integration Ready!</h1>
						<p>Your static contents will be delivered via CDN77.</p>
					</div>
					<img class="wiz-bg-img" src="data:image/png;base64,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"/>
				</div>
			</div>
		</div>
		<?php include WPFC_MAIN_PATH."templates/buttons.html"; ?>
	</div>
</div>



