<?php // Opening PHP tag - nothing should be before this, not even whitespace

// Custom Function to Include
function favicon_link() {
    echo '<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico" />' . "\n";
}
add_action( 'wp_head', 'favicon_link' );




add_action( 'wp_enqueue_scripts', 'enqueue_my_styles' );

function enqueue_my_styles() {
    
    global $wp_styles;
    
    // Load the main stylesheet
    wp_enqueue_style( 'my-theme', get_stylesheet_uri() );
    
    /**
     * Load our IE-only stylesheet for all versions of IE:
     * <!--[if IE]> ... <![endif]-->
     * 
     * NOTE: It is also possible to just check and see if the $is_IE global in WordPress is set to true before 
     * calling the wp_enqueue_style() function.  If you are trying to load a stylesheet for all browsers 
     * EXCEPT for IE, then you would HAVE to check the $is_IE global since WordPress doesn't have a way to 
     * properly handle non-IE conditional comments.
     */
    wp_enqueue_style( 'my-theme-ie', get_stylesheet_directory_uri() . "/css/ie.css"  );
    $wp_styles->add_data( 'my-theme-ie', 'conditional', 'IE' );
    
}





add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );
function theme_enqueue_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css', array( 'my-theme-ie' )  );

}

function add_additional_rs_code() {
    ?>
    var resize = function() {
    $('.royalSlider').css({
        width: $(window).width(),
        height: $(window).height()
    });
};
$(window).on('resize', resize);
resize();
    <?php
}
add_action('new_rs_after_js_init_code', 'add_additional_rs_code');








