﻿<!-- template="documentation-tab" -->
<div class="mla-display-settings-page" id="mla-display-settings-documentation-tab" style="width:700px">
<h3>Plugin and Shortcode Documentation. In this tab, jump to:</h3>
<div style="float:left; margin-right: 15px;"><a href="#mla_gallery"><strong>MLA Gallery Shortcode</strong></a>
<ul style="list-style-position:inside; list-style:disc; line-height: 15px; padding-left: 20px">
<li><a href="#gallery_substitution">Substitution Parameters</a></li>
<li><a href="#gallery_display_style">Gallery Display Style</a></li>
<li><a href="#gallery_display_content">Gallery Display Content</a></li>
<li><a href="#thumbnail_substitution">Thumbnail Substitution Support, mla_viewer</a></li>
<li><a href="#order_orderby">Order, Orderby</a></li>
<li><a href="#size">Size</a></li>
<li><a href="#link">Link</a></li>
<li><a href="#include_exclude">Include, Exclude</a></li>
<li><a href="#post_id_ids_post_parent">Post ID, "ids", Post Parent</a></li>
<li><a href="#author_author_name">Author, Author Name</a></li>
<li><a href="#category_parameters">Category Parameters</a></li>
<li><a href="#tag_parameters">Tag Parameters</a></li>
<li><a href="#taxonomy_parameters_tax_operator">Simple Taxonomy Parameters, "tax_operator"</a></li>
<li><a href="#taxonomy_queries">Taxonomy Queries, the "tax_query"</a></li>
<li><a href="#taxonomy_keyword_search">Taxonomy term keyword(s) search</a></li>
<li><a href="#post_mime_type_parameter">Post MIME Type</a></li>
<li><a href="#post_type_post_status">Post Type, Post Status</a></li>
<li><a href="#pagination_parameters">Pagination Parameters</a></li>
<li><a href="#time_parameters">Date and Time Parameters, the "date query"</a></li>
<li><a href="#custom_field_parameters">Simple Custom Field Parameters</a></li>
<li><a href="#custom_field_queries">Custom Field Queries, the "meta_query"</a></li>
<li><a href="#search_keywords">Keyword(s) Search</a></li>
<li><a href="#cache_parameters">Caching Parameters</a></li>
<li><a href="#debugging_output">Debugging Output</a></li>
<li><a href="#mla_gallery_hooks">MLA Gallery Filters (Hooks)</a></li>
</ul></div>
<div style="float:left; margin-left: 15px;"><a href="#mla_tag_cloud"><strong>MLA Tag Cloud Shortcode</strong></a>
<ul style="list-style-position:inside; list-style:disc; line-height: 15px; padding-left: 20px">
<li><a href="#tag_cloud_output">Tag Cloud Output Formats</a></li>
<li><a href="#tag_cloud_items">Tag Cloud Item Parameters</a></li>
<li><a href="#tag_cloud_link">Tag Cloud Item Link</a></li>
<li><a href="#tag_cloud_display_style">Tag Cloud Display Style (list and grid)</a></li>
<li><a href="#tag_cloud_display_content">Tag Cloud Display Content</a></li>
<li><a href="#tag_cloud_data_selection">Tag Cloud Data Selection Parameters</a></li>
<li><a href="#tag_cloud_debugging_output">Tag Cloud Debugging Output</a></li>
<li><a href="#tag_cloud_substitution">Tag Cloud Substitution Parameters</a></li>
<li><a href="#tag_cloud_pagination_parameters">Tag Cloud Pagination Parameters</a></li>
<li><a href="#tag_cloud_pagination_example">A Tag Cloud Pagination Example</a></li>
<li><a href="#mla_tag_cloud_hooks">MLA Tag Cloud Filters (Hooks)</a></li>
</ul></div>
<ul style="list-style-position:inside; list-style:disc; line-height: 18px; clear:both">
<li>
<a href="#gallery_examples">MLA Gallery Examples</a>
</li>
<ul style="list-style-position:inside; list-style:disc; line-height: 15px; padding-left: 20px">
<li><a href="#simple_examples">Simple Examples</a></li>
<li><a href="#paginated_gallery">A Paginated Gallery</a></li>
<li><a href="#cloud_and_gallery">Tag Cloud and Gallery</a></li>
<li><a href="#search_form_and_gallery">Search Form and Gallery</a></li>
</ul>
<li>
<a href="#mla_output_parameter"><strong>Support for Alternative Gallery Output, e.g., Pagination</strong></a>
</li>
<li>
<a href="#alt_shortcode"><strong>Support for Other Gallery-generating Shortcodes</strong></a>
</li>
<li>
<a href="#photonic_gallery"><strong>Support for &#8220;Photonic Gallery&#8221;</strong></a>
</li>
<li>
<a href="#mla_gallery_templates"><strong>Style and Markup Templates</strong></a>
</li>
<ul style="list-style-position:inside; list-style:disc; line-height: 15px; padding-left: 20px">
<li><a href="#gallery_specific">Gallery-specific substitution parameters</a></li>
<li><a href="#mla_style_parameters">Substitution parameters for style templates</a></li>
<li><a href="#mla_markup_parameters">Substitution parameters for markup templates</a></li>
<li><a href="#mla_attachment_parameters">Attachment-specific substitution parameters for the markup template Item part</a></li>
</ul>
<li>
<a href="#mla_table_example"><strong>A table-based Style and Markup template example</strong></a>
</li>
<li>
<a href="#mla_variable_parameters"><strong>Field-level substitution parameters</strong></a>
</li>
<ul style="list-style-position:inside; list-style:disc; line-height: 15px; padding-left: 20px">
<li><a href="#field_level_prefixes">Field-level prefix values</a></li>
<li><a href="#field_level_formats">Field-level option/format values</a></li>
<li><a href="#field_level_data_sources">Field-level data sources</a></li>
<li><a href="#mla_iptc_identifiers">Field-level IPTC identifiers and friendly names</a>
<li><a href="#mla_camera_values">Field-level Enhanced EXIF CAMERA values</a></li>
<li><a href="#mla_gps_values">Field-level Enhanced EXIF GPS values</a></li>
<li><a href="#pdf_metadata">Field-level metadata in PDF documents</a></li>
</ul>
<li>
<a href="#mla_template_parameters"><strong>Content Templates</strong></a>
<li>
<a href="#mla_text_widget"><strong>The MLA Text Widget</strong></a>
</li>
<li>
<a href="#terms_search"><strong>Terms Search - filtering on taxonomy term names</strong></a>
</li>
<li>
<a href="#select_parent"><strong>Select Parent Popup Window</strong></a>
</li>
<li>
<a href="#mla_edit_meta_boxes"><strong>Edit Media additional meta boxes (and Hooks)</strong></a>
</li>
<li>
<a href="#mla_media_modal_filters"><strong>Media Manager Enhancement filters (Hooks)</strong></a>
</li>
<li>
<a href="#mla_views"><strong>Library Views/Post MIME Type Processing</strong></a>
</li>
<li>
<a href="#mla_uploads"><strong>File Extension and MIME Type Processing</strong></a>
</li>
<li>
<a href="#mla_optional_uploads"><strong>Searching for Upload MIME Types</strong></a>
</li>
<li>
<a href="#mla_custom_field_mapping"><strong>Custom Field and Attachment Metadata Processing Options</strong></a>
</li>
<ul style="list-style-position:inside; list-style:disc; line-height: 15px; padding-left: 20px">
<li><a href="#custom_field_mapping_example">Custom field mapping example</a></li>
<li><a href="#custom_field_mapping_table">The custom field mapping table</a></li>
<li><a href="#custom_field_mapping_buttons">Custom field mapping command buttons</a></li>
<li><a href="#attachment_metadata_mapping">Adding or Changing Attachment Metadata</a></li>
<li><a href="#custom_field_mapping_with_templates">Custom field mapping with Content Templates</a></li>
<li><a href="#other_custom_field_mapping">Other mapping techniques</a></li>
</ul>
<li>
<a href="#mla_iptc_exif_mapping"><strong>IPTC &amp; EXIF Processing Options</strong></a>
</li>
<ul style="list-style-position:inside; list-style:disc; line-height: 15px; padding-left: 20px">
<li><a href="#iptc_exif_mapping_example">IPTC/EXIF mapping example</a></li>
<li><a href="#iptc_exif_mapping_tables">IPTC/EXIF mapping tables</a></li>
<li><a href="#iptc_exif_mapping_buttons">IPTC/EXIF mapping command buttons</a></li>
<li><a href="#iptc_exif_mapping_with_templates">EXIF/Template mapping with Content Templates</a></li>
<li><a href="#pdf_iptc_exif_mapping">IPTC/EXIF Mapping for PDF Documents</a></li>
<li><a href="#other_iptc_exif_mapping">Other mapping techniques</a></li>
<li><a href="#wordpress_default_mapping">WordPress default title, slug and description mapping</a></li>
</li>
</ul>
<li><a href="#mla_mapping_hooks"><strong>MLA Custom Field and IPTC/EXIF Mapping Actions and Filters (Hooks)</strong></a></li>
<li><a href="#mla_debug_tab"><strong>MLA Debug Tab</strong></a></li>
<li><a href="#mla_list_table_hooks"><strong>Media/Assistant Submenu Actions and Filters (Hooks)</strong></a></li>
</ul>
<h3>Translating/Localizing the plugin</h3>
<p>
If you would like to localize MLA to see the admin screens in your own language,
have a look at the <a title="MLA Internationalization Guide.pdf" href="[+translate_url+]" target="_blank" style="font-size:14px; font-weight:bold">MLA Internationalization Guide</a>. You are encouraged to share your translation with other MLA users; the Guide tells you how!
</p>
<h3>Plugin Code Documentation</h3>
<p>
If you are a developer interested in how this plugin is put together, you should
have a look at the <a title="Consult the phpDocs documentation" href="[+phpDocs_url+]" target="_blank" style="font-size:14px; font-weight:bold">phpDocs documentation</a>.
</p>
<a name="mla_gallery"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>MLA Gallery Shortcode</h3>
<p>
The <code>[mla_gallery]</code> shortcode is used in a post, page or custom post type to add a gallery of images and/or other Media Library items (such as PDF documents). MLA Gallery is a superset of the <code>[gallery]</code> shortcode in the WordPress core; it is compatible with <code>[gallery]</code> and provides many enhancements. These include:
</p>
<ul class="mla_settings">
<li>Full support for WordPress categories, tags and custom taxonomies. You can select items with any of the taxonomy parameters documented in the WP_Query class.</li>
<li>Support for all post_mime_type values, not just images.</li>
<li>Media Library items need not be "attached" to the post. You can build a gallery with any combination of items in the Library using taxonomy terms, custom fields and more.</li>
<li>Control over the styles, markup and content of each gallery using the Style and Markup Templates documented below.</li>
<li>Access to a wide range of content using the Attachment-specific and Field-level Substitution parameters documented below. A powerful Content Template facility lets you assemble content from multiple sources and vary the results depending on which data elements contain non-empty values for a given gallery item.</li>
<li>You can combine <code>[mla_gallery]</code> data selection with other popular gallery-generating plugins to get the best of both.
</li>
</ul>
<h4>Option/Parameter Documentation Sources</h4>
<p>
If you're new to Media Library Assistant and the <code>[mla_gallery]</code> shortcode you should read through the material in the <a href="#gallery_examples">MLA Gallery Examples</a> section.
</p>
<p>
All of the options/parameters documented for the <code>[gallery]</code> shortcode are supported by the <code>[mla_gallery]</code> shortcode; you can find them in the <a href="http://codex.wordpress.org/Gallery_Shortcode" title="WordPress Codex link" target="_blank">WordPress Codex</a>. Most of the parameters documented for the WP_Query class are also supported; see the <a href="http://codex.wordpress.org/Class_Reference/WP_Query" title="WordPress Codex link" target="_blank">Codex WP_Query class reference</a>. Because the <code>[mla_gallery]</code> shortcode is designed to work with Media Library items, there are some parameter differences and extensions; these are documented below.
<a name="gallery_substitution"></a>
</p>
<h4>Substitution Parameters</h4>
<p>
Substitution parameters are a powerful way to add general and attachment-specific values to the gallery display. For example, if you code "<code>mla_rollover_text='{+date+} : {+description+}'</code>, the rollover text will contain the upload date, a colon, and the full description of each gallery item. There are dozens of parameter names like `date` and `description` divided in several categories:
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold"><a href="#gallery_specific">Gallery-specific</a></td>
<td>values that are known at the beginning of shortcode processing and remain the same for the entire shortcode, such as the ID and URL of the post/page in which the shortcode appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold"><a href="#mla_style_parameters">Style</a></td>
<td>values that are known when the gallery-specific CSS inline styles are composed just before gallery output begins</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold"><a href="#mla_markup_parameters">Markup</a></td>
<td>values that are known at the beginning of gallery output processing and remain the same for the entire gallery</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold"><a href="#mla_attachment_parameters">Attachment-specific</a></td>
<td  style="vertical-align: top">values that change for each item in the gallery, such as Title and Caption</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold"><a href="#mla_variable_parameters">Field-level</a></td>
<td>values from sources like shortcode parameters, query arguments, custom fields, taxonomy terms and attachment metadata. There are many, many values to choose from as well as options to reformat values and select array elements. You are encouraged to explore them.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold"><a href="#mla_template_parameters">Content Template</a></td>
<td>lets you compose a value from multiple substitution parameters and test for empty values, choose among two or more alternatives or suppress output entirely</td>
</tr>
</table>
&nbsp;<br />
Click on any of the category names in the above table to go to the Documentation section describing the names available in that category and how to use them.
</p>
<p>
To use a substitution parameter in your shortcode, simply add "{+" before the substitution parameter name and add "+}" after the name. Note that the enclosing delimiters are different than those used in Style and Markup templates, since the WordPress shortcode parser reserves square brackets ("[" and "]") for its own use. Also, because square brackets are reserved, <strong>you must substitute curly braces for square brackets</strong> if your parameter values require them. For example, if your shortcode parameter is <code>mla_link_attributes='rel="shadowbox{sbalbum-{+instance+}};player=img"'</code>, the actual attribute added to the link will be <code>rel="shadowbox[sbalbum-1];player=img"</code>. If you must code a curly brace in a parameter value, preface it with <strong>two backslash characters</strong>, e.g., "\\{" or "\\}".
<a name="gallery_display_style"></a>
</p>
<h4>Gallery Display Style</h4>
<p>
Two <code>[mla_gallery]</code> parameters provide a way to apply custom style and markup templates to your <code>[mla_gallery]</code> display. These parameters replace the default style and/or markup templates with templates you define on the "MLA Gallery" tab of the Settings page. On the "MLA Gallery" tab you can also select one of your custom templates to replace the built-in default template for all <code>[mla_gallery]</code> shortcodes the do not contain one of these parameters.
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_style</td>
<td>replaces the default style template for an <code>[mla_gallery]</code> shortcode. You can code "none" to suppress the addition of CSS inline styles entirely, or code "theme" to let your theme use the <code>use_default_gallery_style</code> filter to make the decision.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_markup</td>
<td>replaces the default markup template for an <code>[mla_gallery]</code> shortcode</td>
</tr>
</table>
<p>
Four <code>[mla_gallery]</code> parameters provide control over the placement, size and spacing of gallery items without requiring the use of custom Style templates.
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">columns</td>
<td>specifies the number of columns. The gallery will include a break tag at the end of each row, and calculate the column width as appropriate. The default value is 3. If columns is set to 0, no row breaks will be included.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_float</td>
<td>specifies the CSS float attribute of the ".gallery-item" style. Acceptable values are "left", "none", "right"; the default value is "right" if current locale is RTL, "left" on LTR (left-to-right inline flow, e.g., English).</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_margin</td>
<td>specifies the CSS margin property of the ".gallery-item" style. The default value is "1.5%", a percent of the total gallery width. You can also specify any dimension value, e.g., "10px" or "2em", as well as the "auto" or "inherit" values. Finally, you can specify "none", which will remove the margin property from the styles template altogether.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_itemwidth</td>
<td>specifies the CSS width attribute of the ".gallery-item" style. You can specify a percent of the total gallery width, e.g., "33.3%". You can also specify any dimension value, e.g., "10px" or "2em", as well as the "auto" or "inherit" values. You can specify "none", which will remove the width property from the styles template altogether.
<br />&nbsp;<br />
Two additional values, "calculate" (the default) and "exact",  calculate the width automatically, based on the "columns" and "mla_margin" values. For "calculate", the width is calculated by dividing 100% by the number of columns, then subtracting twice the margin. For example, the default value is (floor(1000/3)/10) - ( 2.0 * 1.5 ) = 30.3%. Adding in the left and right margins makes each column 33.3% and the total width will be 99.9%
<br />&nbsp;<br />
For the "exact" value, the calculation is the same but the margin is ignored, so the width value would be 33.3%.</td>
</tr>
</table>
<p>
These parameters are only important if the gallery thumbnails are too large to fit within the width of the page on which they appear. For example, if you code <code>[mla_gallery size=full]</code>, the browser will automatically scale down large images to fit within the width attribute (in percent) of the ".gallery-item" style. The default 1.5% margin will ensure that the images do not overlap; you can increase it to add more space between the gallery items. You can also reduce the itemwidth parameter to increase the left and right space between the items.
</p>
<p>
The default margin and width calculations try to make the total width of each row as close to 100% as possible, but never exceed 100% due to rounding errors. If you have more advanced style and format needs, you can define custom style and/or markup templates. You can code <code>mla_style=none</code> to suppress inline styles entirely and use a separate stylesheet to control the format of the gallery. You can also code <code>mla_style=theme</code>, if your theme supports it, to use the theme's stylesheet to control the format of the gallery.
</p>
<p>
Three parameters provide control over the XHTML tags used to enclose each part of the gallery items.
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">itemtag</td>
<td>the name of the XHTML tag used to enclose each item in the gallery. The default is "dl"; if your theme supports HTML5, the default is "figure".</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">icontag</td>
<td>the name of the XHTML tag used to enclose each thumbnail icon in the gallery. The default is "dt"; if your theme supports HTML5, the default is "div".</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">captiontag</td>
<td>the name of the XHTML tag used to enclose each caption. The default is "dd"; if your theme supports HTML5, the default is "figcaption".</td>
</tr>
</table>
<p>
These parameters work together to change the gallery markup. For example, to change the gallery markup to use div, span and p tags: 
</p>
<p>
<code>[gallery itemtag="div" icontag="span" captiontag="p"]</code>
<a name="gallery_display_content"></a>
</p>
<h4>Gallery Display Content</h4>
<p>
Twelve <code>[mla_gallery]</code> parameters provide an easy way to control the contents of gallery items without requiring the use of custom Markup templates.  
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_output</td>
<td>completely replaces gallery output with links to the "previous" or "next" item/page or pagination links. Complete documentation is in the <a href="#mla_output_parameter"><strong>Support for Alternative Gallery Output, e.g., Pagination</strong></a> section below.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_rollover_text</td>
<td>adds the HTML "title" attribute in the hyperlink for each gallery item. This is the attachment title text displayed when the mouse rolls or hovers over the gallery thumbnail. Note that as of WordPress 3.7 there is no default "title" attribute; for older WordPress versions this parameter will replace the default "title".</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_target</td>
<td>adds an HTML "target" attribute to the hyperlink for each gallery item; see below.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_link_attributes</td>
<td>adds one or more HTML attributes to the hyperlink for each gallery item; see below.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_link_class</td>
<td>adds an HTML "class" attribute to the hyperlink for each gallery item.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_link_href</td>
<td>replaces the HTML "href" attribute in the hyperlink for each gallery item; see below.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_link_text</td>
<td>replaces the thumbnail image or attachment title text displayed for each gallery item.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_image_attributes</td>
<td>adds one or more HTML attributes to the "img" tag of the thumbnail image or icon displayed for each gallery item. Note that if you include an "alt" or "class" attribute in this parameter it will override and replace the corresponding attribute already present in the tag, including any "mla_image_class" or "mla_image_alt" value.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_image_class</td>
<td><strong>adds</strong> one or more values to the HTML "class" attribute in the "img" tag of the thumbnail image or icon displayed for each gallery item. Existing class values are retained, not replaced.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_image_alt</td>
<td>replaces the HTML "alt" attribute in the "img" tag of the thumbnail image or icon displayed for each gallery item.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_caption</td>
<td>replaces the attachment caption text displayed beneath the thumbnail of each gallery item.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_nolink_text</td>
<td>replaces the empty string displayed when there are no gallery items or no pagination link.</td>
</tr>
</table>
<p>
All but the "mla_target" parameter support the <a href="#mla_markup_parameters">Markup</a>, <a href="#mla_attachment_parameters">Attachment-specific</a>, <a href="#mla_variable_parameters">Field-level</a> and <a href="#mla_template_parameters">Content Template</a> substitution parameters defined for Markup Templates. For example, if you code "<code>mla_rollover_text='{+date+} : {+description+}'</code>, the rollover text will contain the upload date, a colon, and the full description of each gallery item. Simply add "{+" before the substitution parameter name and add "+}" after the name. Note that the enclosing delimiters are different than those used in the templates, since the WordPress shortcode parser reserves square brackets ("[" and "]") for its own use.
</p>
<p>
The "mla_link_href" parameter is a great way to change the destination your gallery item links to or add arguments to the link for later processing. For example, to make a gallery item link back to the page/post it is attached to, you can code: <code>mla_link_href='{+site_url+}/?page_id={+parent+}'</code>. You can also add arguments to the link, e.g., <code>mla_link_href='{+link_url+}?myarg1=myvalue1&amp;amp;myarg2=myvalue2'</code>. Note the use of the HTML entity name "&amp;amp;" to put an ampersand in the value; the WordPress "visual" post editor will replace "&", "<" and ">" with "&amp;amp;", "&amp;lt;" and "&amp;gt;" whether you like it not. The <strong>only</strong> markup parameter modified by this parameter is "link". Other markup parameters such as "pagelink", "filelink" and "link_url" are not modified.
</p>
<p>
The "mla_link_attributes" and "mla_image_attributes" parameters accept any value and adds it to the "&lt;a&gt;" or "&lt;img&gt;" tags for the gallery item. For example, you can create a Shadowbox JS (plugin) album by adding <code>mla_link_attributes='rel="shadowbox{sbalbum-{+instance+}};player=img"'</code> to your shortcode query (note the use of single quotes around the parameter value and the double quotes within the parameter). <strong>IMPORTANT:</strong> since the shortcode parser reserves square brackets ("[" and "]") for its own use, <strong>you must substitute curly braces for square brackets</strong> if your attributes require brackets (as this example does). In this case, the actual attribute added to the link will be <code>rel="shadowbox[sbalbum-1];player=img"</code>. If you must code a curly brace in your attribute value, preface it with <strong>two backslash characters</strong>, e.g., "\\{" or "\\}". If you code an attribute already present in the tag, your value will override the existing value.
</p>
<p>
The "mla_target" parameter accepts any value and adds an HTML "target" attribute to the hyperlink with that value. For example, if you code <code>mla_target="_blank"</code> the item will open in a new window or tab. You can also use "_self", "_parent", "_top" or the "<em>framename</em>" of a named frame.
<a name="thumbnail_substitution"></a>
</p>
<h4>Thumbnail Substitution Support, mla_viewer</h4>
<p>
<strong>NOTE: Google has discontinued the File Viewer support for thumbnail images.</strong>
This solution supports dynamic thumbnail image generation for PDF and Postscript documents on your site's server. You can also assign a "Featured Image" to any Media Library item. For non-image items such as Microsoft Office documents the featured image will replace the MIME-type icon or document title in an <code>[mla_gallery]</code> display. Simply go to the Media/Edit Media screen, scroll down to the "Featured Image" meta box and select an image as you would for a post or page.
</p>
<p>
The dynamic thumbnail image generation for PDF and Postscript documents uses the PHP <code>Imagick</code> class, which <strong>requires Imagemagick and Ghostscript</strong> to be installed on your server.  If you need help installing them, look at this <a href="https://wordpress.org/support/topic/nothing-but-error-messages" title="Help with installation" target="_blank">PDF Thumbnails support topic</a>. If you don't have them on your server you can still use the Featured Image support to supply thumbnails for  your non-image items.
</p>
<p>
Ten <code>[mla_gallery]</code> parameters provide an easy way to simulate thumbnail images for the non-image file types.
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_viewer</td>
<td>must be "true" or "single" to enable thumbnail substitution. Use "true" unless you experience generation failures due to memory limitations on your server. Use "single" to generate one thumbnail at a time, which may be slower but requires less memory.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_viewer_extensions</td>
<td>a comma-delimited list of the file extensions to be processed; the default is "ai,eps,pdf,ps" (do not include the dot (".") preceding the file extension). You may add or remove extensions (when support for additional types becomes available).</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_viewer_limit</td>
<td>the upper limit in megabytes (default none) on the size of the file to be processed. You can set this to avoid processing large documents if performance becomes an issue.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_viewer_width</td>
<td>the maxinum width in pixels (default "150") of the thumbnail image. The height (unless also specified) will be adjusted to maintain the page proportions.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_viewer_height</td>
<td>the maxinum width in pixels (default "0") of the thumbnail image. The width (unless also specified) will be adjusted to maintain the page proportions.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_viewer_best_fit</td>
<td>retain page proportions (default "false") when both height and width are explicitly stated. If "false", the image will be stretched as required to exactly fit the height and width. If "true", the image will be reduced in size to fit within the bounds, but proportions will be preserved. For example, a typical page is 612 pixels wide and 792 pixels tall. If you set width and height to 300 and set best_fit to true, the thumbnail will be reduced to 231 pixels wide by 300 pixels tall.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_viewer_page</td>
<td>the page number (default "1") to be used for the thumbnail image. If the page does not exist for a particular document the first page will be used instead.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_viewer_resolution</td>
<td>the pixels/inch resolution (default 72) of the page before reduction. If you set this to a higher number, such as 300, you will improve thumbnail quality at the expense of additional processing time.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_viewer_quality</td>
<td>the compression quality (default 90) of the final page. You can set this to a value between 1 and 100 to get smaller files at the expense of image quality; 1 is smallest/worst and 100 is largest/best.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_viewer_type</td>
<td>the MIME type, "image/jpeg" or "image/png", (default image/jpeg) of the final thumbnail. You can, for example, set this to "image/png" to retain a transparent background instead of the white jpeg background.</td>
</tr>
</table>
<p>
When this feature is active, gallery items for which WordPress can generate a thumbnail image are not altered. If WordPress generation fails, the "Featured Image" will be used, if one is specified for the item. If the item does not have a Featured Image, supported file/MIME types (see <code>mla_viewer_extensions</code>) will have a gallery thumbnail generated dynamically. If all else fails, the thumbnail is replaced by an "img" html tag whose "src" attribute contains a url reference to the appropriate icon for the file/MIME type.
</p>
<p>
Four options in the Settings/Media Library Assistant MLA Gallery tab allow control over mla_viewer operation:
<ul class="mla_settings">
<li><strong>Enable thumbnail substitution</strong><br />
Check this option to allow the "mla_viewer" to generate thumbnail images for PDF documents. Thumbnails are generated dynamically, each time the item appears in an <code>[mla_gallery]</code> display.</li>
<li><strong>Enable Featured Images</strong><br />
Check this option to extend Featured Image support to all Media Library items. The Featured Image can be used as a thumbnail image for the item in an <code>[mla_gallery]</code> display.</li>
<li><strong>Enable explicit Ghostscript check</strong><br />
Check this option to enable the explicit check for Ghostscript support required for thumbnail generation. If your Ghostscript software is in a non-standard location, unchecking this option bypasses the check. Bad things can happen if Ghostscript is missing but Imagemagick is present, so leave this option checked unless you know it is safe to turn it off.</li>
<li><strong>Ghostscript path</strong><br />
If your Ghostscript software is in a non-standard location, enter the full path and name of the executable here. The value you enter will be used as-is and the search for Ghostscript in the usual locations will be bypassed.</li>
</ul>
<a name="order_orderby"></a>
</p>
<h4>Order, Orderby</h4>
<p>
The Orderby parameter specifies which database field(s) are used to sort the gallery. You can sort the gallery by one or more of these values (there is additional information on some of these values in the <a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" title="WordPress Codex link" target="_blank">Codex WP_Query class reference</a>):
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">none</td>
<td>No order.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">ID</td>
<td>Order by post id. Note capitalization.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">author</td>
<td>Order by author (id, not display name).</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">date</td>
<td>Order by date uploaded.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">description, content</td>
<td>Order by attachment description.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">title</td>
<td>Order by attachment title.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">caption, excerpt</td>
<td>Order by attachment caption. </td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">slug, name</td>
<td>Order by attachment name.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">modified</td>
<td>Order by last modified date.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">parent</td>
<td>Order by post/page parent id.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">menu_order</td>
<td>Order by page order.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mime_type</td>
<td>Order by attachment MIME type.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">comment_count</td>
<td>Order by number of comments.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">rand</td>
<td>Random order.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">&lt;keyname&gt;, meta_value,<br />meta_value_num</td>
<td style="vertical-align: top;">Order by custom field value. Note that a <em>'meta_key=keyname'</em> must also be present in the query. For example, to sort by a custom field called "Publication Date" and display the most recent items first, code <code>[mla_gallery meta_key="Publication Date" orderby=meta_value order=DESC]</code></td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post__in</td>
<td>Preserve order given in the <em>ids, include</em> or <em>post__in</em> array.</td>
</tr>
</table>
<p>
You can sort on more than one value, e.g., <code>orderby="author, date DESC"</code> and you can specify ASC/DESC on a value by value basis. <strong>NOTE: multiple orderby values are separated by commas, not spaces.</strong> This is a change from WP_Query. </p>
<p>
The order parameter (default ASC) can give an ASC/DESC default for any value that doesn't have a specific choice. For example, <code>orderby="author, date DESC, mime_type" order=ASC</code> is the same as <code>orderby="author ASC, date DESC, mime_type ASC"</code>.
<a name="size"></a>
</p>
<h4>Size</h4>
<p>
The Size parameter specifies the image size to use for the thumbnail display. Valid values include "thumbnail", "medium", "large", "full" and any additional image size that was registered with add_image_size(). The default value is "thumbnail". You can use "none" or "" to suppress thumbnail display and substitute the item title string for the image/icon.
</p>
<p>
The <code>[mla_gallery]</code> shortcode supports an additional Size value, "icon", which shows a 60x60 (or 64x64) pixel thumbnail for image items and an appropriate icon for non-image items such as PDF or text files.
<a name="link"></a>
</p>
<h4>Link</h4>
<p>
The Link parameter specifies the target and type of link from the gallery item to the attachment or other destination. You can also specify a non-hyperlink treatment for the item.
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">permalink, post</td>
<td>Link to the attachment's "media page". This is the default value.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">file, full</td>
<td>Link directly to the attachment file.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">thumbnail,&nbsp;medium,<br />large</td>
<td>For image attachments, the size of the image file you want to link to.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold; font-style:italic">(other registered size)</td>
<td>For image attachments, any additional image size that was registered with add_image_size(). If the specified size is not available or if the attachment is not an image, the link will go directly to the attachment file.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">span</td>
<td>Substitutes a <code>&lt;span&gt;&lt;/span&gt;</code> tag for the hyperlink tag. You can use the "mla_link_attributes" and "mla_link_class" parameters to add attributes to the <code>&lt;span&gt;</code> tag. You can use the "mla_link_text" parameter to customize the text within the span.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">none</td>
<td>Eliminates the hyperlink tag surrounding the thumbnail image or text. You can use the "mla_link_text" parameter to customize the contents.</td>
</tr>
</table>
<p>
&nbsp;
<a name="include_exclude"></a>
</p>
<h4>Include, Exclude</h4>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">include</td>
<td>comma separated attachment IDs to show only the information from these attachments.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">exclude</td>
<td>comma separated attachment IDs excludes the information from these attachments. Please note that include and exclude cannot be used together.</td>
</tr>
</table>
<p>
You can add <code>post_parent=all</code> to include or exclude attachments regardless of which post or page they are attached to. You can add <code>post_mime_type=all</code> to include or exclude attachments of all MIME types, not just images.
<a name="post_id_ids_post_parent"></a>
</p>
<h4>Post ID, "ids", Post Parent</h4>
<p>
The "id" parameter lets you specify a post ID for your query. The gallery will display images which are attached to that post. If the "id" parameter is not specified, the <code>[mla_gallery]</code> behavior differs from the <code>[gallery]</code> behavior. If your query uses taxonomy or custom field parameters, "author", "author_name" or "s" (search term), then the query will NOT be restricted to items attached to the current post. This lets you build a gallery with any combination of Media Library items that match the parameters.
</p>
<p>
For WordPress 3.5 and later, the "ids" parameter lets you specify a list of Post IDs. The attachment(s) matching the "ids" values will be displayed in the order specified by the list.
</p>
<p>
You can use the "post_parent" to override the default behavior. If you set "post_parent" to a specific post ID, only the items attached to that post are displayed. There are four additional values available:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">none</td>
<td>all the <strong>unattached</strong> items are displayed, i.e., items with post_parent equal to zero (0)</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">current</td>
<td>only the items attached to the current post/page are displayed, i.e., the post/page that contains the shortcode</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">any</td>
<td>all the <strong>attached</strong> items are displayed, i.e., items with post_parent not equal to zero (0)</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">all</td>
<td>all of the items are displayed, i.e., post_parent is ignored</td>
</tr>
</table>
<p>
For example, <code>[mla_gallery tag="artisan"]</code> will display all images having the specified tag value, regardless of which post (if any) they are attached to. If you use <code>[mla_gallery tag="artisan" post_parent="current"]</code> it will display images having the specified tag value only if they are attached to the current post.
<a name="author_author_name"></a>
</p>
<h4>Author, Author Name</h4>
<p>
You can query by author's id or &quot;Username&quot;, the value used to log in to the site. In the database this is the "user_nicename" column (not the "display_name" column). For example, if you log in as &quot;john&quot; and your id is 2 you can code:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery author=2]</code></li>
<li><code>[mla_gallery author_name='john']</code></li>
</ul>
<p>Multiple author ID values are allowed, but only one author name value can be entered.
<a name="category_parameters"></a>
</p>
<h4>Category Parameters</h4>
<p>
The Category parameters search in the WordPress core &quot;Categories&quot; taxonomy. Remember to use <code>post_parent=current</code> if you want to restrict your query to items attached to the current post. Category parameters supported by WP_Query are:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">cat (int)</td>
<td>use category id.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">category,<br />category_name&nbsp;(string)</td>
<td>use category slug (NOT name). As a convenience, MLA allows "category" as a synonym for "category_name".</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">category__and (array)</td>
<td>use category id.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold; font-style:italic">category__in (array)</td>
<td>use category id.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">category__not_in (array)</td>
<td>use category id.</td>
</tr>
</table>
<p>
More information and examples can be found on the <a href="http://codex.wordpress.org/Class_Reference/WP_Query#Category_Parameters" title="WordPress Codex page" target="_blank">WordPress Codex WP_Query Class Reference</a> page.
<a name="tag_parameters"></a>
</p>
<h4>Tag Parameters</h4>
<p>
The Tag parameters search in the WordPress core &quot;Tags&quot; taxonomy. Remember to use <code>post_parent=current</code> if you want to restrict your query to items attached to the current post.
</p>
<p>
More information and examples can be found on the <a href="http://codex.wordpress.org/Class_Reference/WP_Query#Tag_Parameters" title="WordPress Codex page" target="_blank">WordPress Codex WP_Query Class Reference</a> page.
Note that the "tag_id" parameter requires exactly one tag ID; multiple IDs are not allowed. You can use the "tag__in" parameter to query for multiple values.
<a name="taxonomy_parameters_tax_operator"></a>
</p>
<h4>Simple Taxonomy Parameters, "tax_operator"</h4>
<p>
The <code>[mla_gallery]</code> shortcode supports the simple "{tax} (string)" values (deprecated as of WordPress version 3.1) as well as the more powerful "<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Taxonomy_Parameters" title="WordPress Codex Documentation for tax_query" target="_blank">tax_query</a>" value. Use these queries for your custom taxonomies (and for the MLA attachment_category and attachment_tag taxonomies); use the above Category and Tag parameters for the WordPress-provided taxonomies. If you do use a tax_query for Categories and Tags, the slug values are "category" and "post_tag". 
</p>
<p>
For simple queries, enter the custom taxonomy name and the term(s) that must be matched, e.g.:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery attachment_category='separate-category,another-category']</code></li>
</ul>
<p>
Note that you must use the name/slug strings for taxonomy and terms, not the "title" strings. If you are using the "Att. Tag" taxonomy built in to MLA then your shortcode should be something like:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery attachment_tag=artisan post_parent=all]</code></li>
</ul>
<p>
In this example, "attachment_tag" is the WordPress taxonomy name/slug for the taxonomy. If you're using "Att. Category", the slug would be "attachment_category".
</p>
<p>
The default behavior of the simple taxonomy query will match any of the terms in the list. If you have two or more simple taxonomy queries, they will be joined by "AND". MLA enhances the simple taxonomy query form by providing three additional parameters:
</p>
<table>
<tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">tax_relation</td>
<td>SQL operator to join multiple taxonomy queries; can be "AND" (the default) or "OR".</td>
</tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">tax_operator</td>
<td>SQL operator to join the terms within each taxonomy; can be "IN" (the default), "NOT IN" or "AND".</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">tax_include_children</td>
<td>whether or not to include children for hierarchical taxonomies; can be "true" (the default) or "false". </td>
</tr>
</table>
<p>
If you specify any of these parameters, MLA will convert your query to the more powerful "tax_query" form, searching on the "slug" field and using the operator you specify. For example, a query for two terms in which <strong>both</strong> terms must match would be coded as:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery attachment_category='separate-category,another-category' tax_operator=AND tax_include_children=false]</code></li>
</ul>
<p>
If you code two or more simple taxonomy queries, the items selected must contain the terms in <strong><em>all</em></strong> of the taxonomies; they are joined by "AND". If you want to include items that match the terms in <strong><em>any</em></strong> of the taxonomies you can add <code>tax_relation="OR"</code>. For example, a query to match either an <code>attachment_category</code> or an <code>attachment_tag</code> would be coded as:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery attachment_category='some-category' attachment_tag="a-tag" tax_relation=OR]</code></li>
</ul>
<p>
Note that the default tax_include_children value is true, matching the default WordPress setting. If your tax_operator is "AND", you will almost certainly want to change this setting.
<a name="taxonomy_queries"></a>
</p>
<h4>Taxonomy Queries, the "tax_query"</h4>
<p>
More complex queries can be specified by using <a href="http://codex.wordpress.org/Class_Reference/WP_Query#Taxonomy_Parameters" title="WordPress Codex Documentation for tax_query" target="_blank">WP_Query's "tax_query"</a>, e.g.:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery tax_query="array(array('taxonomy' => 'attachment_tag','field' => 'slug','terms' => 'artisan'))"]</code></li>
<li><code>[mla_gallery tax_query="array(array('taxonomy' => 'attachment_category','field' => 'id','terms' => array(11, 12)))" post_parent=current post_mime_type='']</code></li>
</ul>
<p>
The first example is equivalent to the simple query <code>attachment_tag=artisan</code>. The second example matches items of all MIME types, attached to the current post, having an attachment_category ID of 11 or 12.
</p>
<p>
When embedding the shortcode in the body of a post, be very careful when coding the tax_query; it must be a valid PHP array specification. Splitting your query over multiple lines or using the "Visual" editor will introduce HTML markup and escape sequences that can render your query invalid. MLA will clean up most of the damage, but if your query fails use the "mla_debug=true" parameter to see if your query has been corrupted. 
</p>
<p>
<strong>IMPORTANT:</strong> Beginning with version 4.0, WordPress changed the way it handles shortcode parameters. Using the <code>=></code> characters in the first shortcode on a post/page will return "Invalid mla_gallery tax_query" errors. There are two ways to prevent this: 1) add "&lt;code&gt;&lt;/code&gt;" tags around your shortcode, or 2) use the "=&amp;gt;" escape sequence in your query.
</p>
<p>
Remember to use <code>post_parent=current</code> if you want to restrict your query to items attached to the current post.
<a name="taxonomy_keyword_search"></a>
</p>
<h4>Taxonomy term keyword(s) search</h4>
<p>
Searching for keywords within the names of taxonomy terms is a completely different way to find items based on taxonomy information. Instead of matching on a slug or term-id value you can match on all or part of the term Title. The shortcode parameters in this section give you all the power of the "Terms Search" feature on the Media/Assistant submenu table, as described in the "<a href="#terms_search">Terms Search - filtering on taxonomy term names</a>" Documentation section. Here are the shortcode parameters that correspond to the controls on the "Search Terms" popup window:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_terms_phrases</td>
<td>The word(s) or phrase(s) you are searching for.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_terms_taxonomies</td>
<td>A comma-separated list of the taxonomy or taxonomies in which to search. Enter the slug(s) for one or more of the taxonomies registered for Media Library items, e.g., attachment_category or attachment_tag.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_phrase_connector</td>
<td>Choose from OR to require that any one of the phrases must match for the search to succeed, or AND (the default) to require that all of the phrases must match.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_term_connector</td>
<td>If you enter multiple terms (separated by commas) in the <code>mla_terms_phrases</code> parameter, this parameter controls how they are connected. Choose from OR (the default) to require that any one of the terms must match for the search to succeed, or AND to require that all of the terms must match.</td>
</tr>
</table>
<p>
<a name="post_mime_type_parameter"></a>
</p>
<h4>Post MIME Type</h4>
<p>
For compatibility with the WordPress <code>[gallery]</code> shortcode, this parameter defaults to <code>post_mime_type=image</code>. You can override the default to, for example, display PDF documents (<code>post_mime_type=application/pdf</code>) or all MIME types (<code>post_mime_type=all</code>). You can select several MIME types with a comma-separated list, e.g., <code>post_mime_type='audio,video'</code>. Wildcard specifications are also supported. For example, <code>post_mime_type='*/mpeg'</code> to select audio and video mpeg formats or <code>post_mime_type='application/*ms*'</code> to select all Microsoft application formats (Word, Excel, etc.).
<a name="post_type_post_status"></a>
</p>
<h4>Post Type, Post Status</h4>
<p>
For compatibility with the WordPress <code>[gallery]</code> shortcode, these parameters default to <code>post_type=attachment</code>, <code>post_status=inherit</code>. You can override the defaults to, for example, display items in the trash (<code>post_status=trash</code>). I'm not sure why you'd want to override "post_type", but you are welcome to experiment and let me know what you find.
<a name="pagination_parameters"></a>
</p>
<h4>Pagination Parameters</h4>
<p>
Pagination parameters let you divide your <code>[mla_gallery]</code> display into two or more pages when the display includes a large number of items. These parameters work with MLA's <a href="#mla_output_parameter"><strong>Support for Alternative Gallery Output, e.g., Pagination</strong></a> to make it easy to construct multi-page galleries without resorting to PHP templates and code in your theme.
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">nopaging</td>
<td>The <code>[mla_gallery]</code> shortcode supplies <code>nopaging=true</code> as a default parameter. If you are working with a template that supports pagination you can replace this with specific values for "numberposts", "posts_per_page", "posts_per_archive_page", "paged" and/or "offset" . You can also pass "paged=current" to suppress the "nopaging" default; "current" will be replaced by the appropriate value (<code>get_query_var('paged')</code> or <code>get_query_var('page')</code>).</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">numberposts,<br />posts_per_page</td>
<td>the number of items to display on each gallery page.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">posts_per_archive_page</td>
<td>number of items to show per page - on archive pages only. Over-rides posts_per_page on pages where is_archive() or is_search() would be true. Not often used.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">paged</td>
<td>number of page. Show the items that would normally show up just on page X. The "paged=current" parameter is useful for "paginated single posts" (i.e. posts that include the <code>&lt;!--nextpage--&gt;</code> Quicktag one or more times). Simply make two or more copies of your <code>[mla_gallery]</code> shortcode separated by the Quicktag and include the "paged=current' in each copy. For true pagination it is better to use the "mla_paginate_current" parameter.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">offset</td>
<td>the number of terms to skip over before starting the current gallery page. This parameter is usually derived automatically from the more useful "mla_paginate_current" parameter.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_paginate_current</td>
<td>the "current" gallery page; defaults to one (1) if not specified. MLA will usually manage this for you, looking for this parameter in the HTML $_REQUEST array if it is not coded in the gallery shortcode.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_page_parameter</td>
<td>the name of the parameter containing the current page number; default "mla_paginate_current". You can change the name if you need multiple paginated galleries on one post/page. If you use this parameter, make sure you add it to the gallery shortcode and all pagination shortcodes for that gallery, and use the same unique value in all shortcodes for the specific gallery.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_paginate_total</td>
<td>the highest page number you want to display; defaults to (total items / posts_per_page) if not specified, which is usually what you want. </td>
</tr>
</table>
<p>
The task of dividing a large <code>[mla_gallery]</code> into two or more pages is supported by MLA's <a href="#mla_output_parameter"><strong>Support for Alternative Gallery Output, e.g., Pagination</strong></a>. For more information and examples, go to that section of the Documentation. 
<a name="time_parameters"></a>
</p>
<h4>Date and Time Parameters, the "date query"</h4>
<p>
The <code>[mla_gallery]</code> shortcode supports the "<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Date_Parameters" title="WordPress Codex Documentation for date_query" target="_blank">date_query</a>" parameter introduced in WordPress Version 3.7. You can use a date_query to filter your gallery based on the 'post_date', 'post_date_gmt', 'post_modified', 'post_modified_gmt', 'comment_date', or 'comment_date_gmt' database columns (although the column names include "post", the same columns are used for attachments).
</p>
<p>
As the <a href="http://codex.wordpress.org/Class_Reference/WP_Query#Date_Parameters" title="WordPress Codex Documentation for date_query" target="_blank">Codex date_query documentation</a> suggests, "before" and "after" values can use any of the <a href="http://php.net/strtotime" title="PHP Date and Time Formats">PHP strtotime()-compatible string values</a>, which are quite powerful. For example, you can use relative values such as <code>'after' => 'second tuesday of last month'</code>. Careful study of the PHP documentation can be most rewarding. You can use <code>mla_debug=true</code> to see how PHP and WordPress translate your query to specific date-time values.
</p>
<p>
When embedding the shortcode in the body of a post, be very careful when coding the date_query; it must be a valid PHP array specification. Splitting your query over multiple lines or using the "Visual" editor will introduce HTML markup and escape sequences that can render your query invalid. MLA will clean up most of the damage, but if your query fails use the "mla_debug=true" parameter to see if your query has been corrupted. 
</p>
<p>
<strong>IMPORTANT:</strong> Beginning with version 4.0, WordPress changed the way it handles shortcode parameters. Using the <code>=></code> characters in the first shortcode on a post/page will return "Invalid mla_gallery tax_query" errors. There are two ways to prevent this: 1) add "&lt;code&gt;&lt;/code&gt;" tags around your shortcode, or 2) use the "=&amp;gt;" escape sequence in your query.
</p>
<p>
Remember to use <code>post_parent=current</code> if you want to restrict your query to items attached to the current post.<a name="custom_field_parameters"></a>
</p>
<h4>Simple Custom Field Parameters</h4>
<p>
The <code>[mla_gallery]</code> shortcode supports the simple custom field parameters:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">meta_key&nbsp;(string)</td>
<td>Custom field key.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">meta_value&nbsp;(string)</td>
<td>Custom field value.</td>
</tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">meta_value_num&nbsp;(number)</td>
<td>Custom field value.</td>
</tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">meta_compare&nbsp;(string)</td>
<td>Operator to test the 'meta_value'. Possible values are '!=', '>', '>=', '<', or '<='. Default value is '='. </td>
</tr>
</table>
<p>
<strong>IMPORTANT:</strong> Beginning with version 4.0, WordPress changed the way it handles shortcode parameters. Using the <code>></code> character in the first shortcode on a post/page will return "Invalid mla_gallery tax_query" errors. To prevent this, add "&lt;code&gt;&lt;/code&gt;" tags around your shortcode.
</p>
<p>
Remember to use <code>post_parent=current</code> if you want to restrict your query to items attached to the current post.
<a name="custom_field_queries"></a>
</p>
<h4>Custom Field Queries, the "meta_query"</h4>
<p>
The <code>[mla_gallery]</code> shortcode supports the more powerful <a href="http://codex.wordpress.org/Class_Reference/WP_Query#Custom_Field_Parameters" title="WordPress Codex documentation for meta_query" target="_blank">"WP_Query meta_query"</a> parameters made available as of WordPress 3.1.
</p>
<p>
When embedding the shortcode in the body of a post, be very careful when coding the meta_query; it must be a valid PHP array specification. In particular, code the query on one line; splitting it across lines can insert HTML <br> tags and corrupt your query. MLA will clean up most of the damage, but if your query fails use the <code>mla_debug=true</code> parameter to see if your query has been corrupted. 
</p>
<p>
<strong>IMPORTANT:</strong> Beginning with version 4.0, WordPress changed the way it handles shortcode parameters. Using the <code>=></code> characters in the first shortcode on a post/page will return "Invalid mla_gallery tax_query" errors. There are two ways to prevent this: 1) add "&lt;code&gt;&lt;/code&gt;" tags around your shortcode, or 2) use the "=&amp;gt;" escape sequence in your query.
</p>
<p>
Remember to use <code>post_parent=current</code> if you want to restrict your query to items attached to the current post.
<a name="search_keywords"></a>
</p>
<h4>Keyword(s) Search</h4>
<p>
The search parameter ("s=keyword") will perform a keyword search. By default, the search includes the "post_title" and "post_content" (Description) fields but not the "post_excerpt" (Caption) field. All of the words you enter in the parameter must match for the search to succeed. An SQL "LIKE" clause for each word is composed and added to the search criteria.
</p>
<p>
You can match on multi-word phrases in a variety of ways. These are described in detail, with examples, in the "Entering Words and Phrases" portion of the "<a href="#terms_search">Terms Search - filtering on taxonomy term names</a>" Documentation section. You can also use the <code>sentence=true</code> and <code>exact=true</code> parameters to change the matching logic used in the <code>[mla_gallery]</code> shortcode.
</p>
<p>
You can use the <code>mla_search_connector</code> and <code>mla_search_fields</code> parameters to extend the search to other fields and to relax the requirement that all phrases must match. Here are all of the parameters that control keyword searching:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">s</td>
<td>The word(s) or phrase(s) you are searching for.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_search_fields</td>
<td>The fields in which to search. Choose from title, content, excerpt, name, terms. Searching on alt-text is not supported.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_search_connector</td>
<td>Choose from OR to require that any one of the phrases must match for the search to succeed, or AND (the default) to require that all of the phrases must match.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">sentence</td>
<td>Add <code>sentence=true</code> to require that all of the words entered must match in sequence. This is equivalent to putting quotes around all of the words in your search.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">exact</td>
<td>Add <code>exact=true</code> to require that the entire field content must match the search text.</td>
</tr>
</table>
<p>
The <code>mla_search_fields=terms</code> feature is a simple way to extend the search to the terms assigned to Media Library items. If searching on taxonomy terms is your primary goal, consider the more powerful "<a href="#taxonomy_keyword_search">Taxonomy term keyword(s) search</a>" parameters discussed in an earlier Documentation section.
<a name="cache_parameters"></a>
</p>
<h4>Caching Parameters</h4>
<p>
For applications that have very large numbers of attachments and taxonomy terms, there are three caching parameters that may improve the performance of your <code>[mla_gallery]</code> shortcodes. All of them default to "true", but you can set them to "false" to avoid some database access.
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">cache_results</td>
<td>Post information cache.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">update_post_meta_cache</td>
<td>Post meta information cache.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">update_post_term_cache</td>
<td>Post term information cache.</td>
</tr>
</table>
<p>
In general you won't need these, since adding to the cache is the right thing to do, but they may be useful in specific circumstances. An example of such circumstances might be when using an <code>[mla_gallery]</code> to retrieve a simple list of thumbnails and links, but in which no other information about the items will be used and the taxonomy and meta data won't be needed. By not loading this information, you can save some time from the extra unnecessary SQL queries. 
<a name="debugging_output"></a>
</p>
<h4>Debugging Output</h4>
<p>
The "mla_debug" parameter controls the display of information about the query parameters and SQL statements used to retrieve gallery items. If you code <code>mla_debug=true</code> you will see a lot of information added to the post or page containing the gallery. Of course, this parameter should <strong><em>ONLY</em></strong> be used in a development/debugging environment; it's quite ugly.
<a name="mla_gallery_hooks"></a>
</p>
<h4>MLA Gallery Filters and Actions (Hooks)</h4>
<p>
The <code>[mla_gallery]</code> shortcode supports a comprehensive set of filters and actions that give you complete control over gallery composition from PHP code in your theme or in another plugin. An example of using the hooks from a simple, stand-alone plugin can be found here: <a title="View the Hooks Example source code" href="[+examples_url+]mla-hooks-example.php.txt" target="_blank" style="font-size:14px; font-weight:bold">mla-hooks-example.php.txt</a>. To run the example:
<ol>
<li>Edit the code to, for example, uncomment the <code>error_log()</code> calls so you can see what is passed to the hooks you are interested in.</li>
<li>Remove the ".txt" extension and save the "mla-hooks-example.php" file in your plugins directory.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA Gallery Hooks Example" plugin.</li>
<li>Create a new <code>[mla_gallery]</code> shortcode or modify an existing shortcode, adding the <code>my_filter="all custom"</code> parameter to activate the example output.</li>
<li>View the post or page on which the modified shortcode appears to see a list of each item's custom fields appended to the gallery captions.</li>
</ol>
</p>
<p>
The example code documents each hook with comments in the filter/action function that intercepts each hook. Generally, each part of the gallery supports three hooks: 1) a "<strong>values</strong>" hook, which lets you record or update the substitution values for that gallery part, 2) a "<strong>template</strong>" hook, which lets you record/update the template used to generate the HTML markup, and 3) a "<strong>parse</strong>" hook which lets you modify or replace the markup generated for a gallery part. The current hooks are:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_raw_gallery_attributes</td>
<td>called at the beginning of the gallery, before the attributes pass through the logic that handles the 'mla_page_parameter' and "request:" prefix processing.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_gallery_attributes,<br />mla_gallery_arguments</td>
<td>called at the beginning of the gallery. You can record/modify shortcode parameter values before (attributes) or after (arguments) they are combined with all the defaults.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_gallery_initial_content</td>
<td>called just after the <code>mla_gallery_attributes</code> filter, so you can inspect/modify any content enclosed by the <code>[mla_gallery]content[\mla_gallery]</code> "enclosing" shortcode format.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_gallery_query_attributes,<br />mla_gallery_query_arguments</td>
<td>called just before the <code>WP_Query->query()</code> call that selects gallery items, with query parameters before or after they are combined with defaults.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_gallery_wp_query_object</td>
<td>called just after the <code>WP_Query->query()</code> call, so you can inspect/record the results.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_gallery_final_content</td>
<td>called just after the <code>mla_gallery_wp_query_object</code> filter, so you can inspect/modify any content enclosed by the <code>[mla_gallery]content[\mla_gallery]</code> "enclosing" shortcode format before it is passed to the alternative gallery shortcode.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">use_mla_gallery_style</td>
<td>allow or suppress the inclusion of CSS styles in the gallery output.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_gallery_style</td>
<td>an old filter retained for compatibility with earlier MLA versions.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_gallery_style_values,<br /> mla_gallery_style_template,<br />mla_gallery_style_parse</td>
<td>for manipulating the Style template.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_gallery_open_values,<br />mla_gallery_open_template,<br />mla_gallery_open_parse</td>
<td>for manipulating the "Open" part of the Markup template.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_gallery_row_open_values,<br />mla_gallery_row_open_template,<br />mla_gallery_row_open_parse</td>
<td>for manipulating the "Row Open" part of the Markup template.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_gallery_item_values,<br />mla_gallery_item_template,<br />mla_gallery_item_parse</td>
<td>for manipulating the "Item" part of the Markup template.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_gallery_row_close_values,<br />mla_gallery_row_close_template,<br />mla_gallery_row_close_parse</td>
<td>for manipulating the "Row Close" part of the Markup template.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_gallery_close_values,<br />mla_gallery_close_template,<br />mla_gallery_close_parse</td>
<td>for manipulating the "Close" part of the Markup template.</td>
</tr>
</table>
<a name="mla_tag_cloud"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>MLA Tag Cloud Shortcode</h3>
<p>
The <code>[mla_tag_cloud]</code> shortcode function displays a list of taxonomy terms in what is called a 'tag cloud', where the size of each term is determined by how many times that particular term has been assigned to Media Library items (attachments). The cloud works with both flat (e.g., Att. Tags) and hierarchical taxonomies (e.g., Att. Categories) MLA Tag Cloud provides many enhancements to the basic "cloud" display. These include:
</p>
<ul class="mla_settings">
<li>Full support for WordPress categories, tags and custom taxonomies. You can select from any taxonomy or list of taxonomies defined in your site.</li>
<li>Several display formats, including "flat","list" and "grid" (modeled after the <code>[mla_gallery]</code> display).</li>
<li>Complete support for paginated clouds; display hundreds or thousands of terms in managable groups.</li>
<li>Control over the styles, markup and content of each cloud using Style and Markup Templates. You can customize the "list" and "grid" formats to suit any need.</li>
<li>Access to a wide range of content using the term-specific and Field-level Substitution parameters. A powerful Content Template facility lets you assemble content from multiple sources and vary the results depending on which data elements contain non-empty values for a given term.</li>
<li>Display Style and Display Content parameters for easy customization of the cloud display and the destination of the links behind each term.
</li>
<li>A comprehensive set of filters gives you access to each step of the cloud generation process from PHP code in your theme or other plugins.
</li>
</ul>
<p>
Many of the <code>[mla_tag_cloud]</code> concepts and shortcode parameters are modeled after the <code>[mla_gallery]</code> shortcode, so the learning curve is short. Differences and parameters unique to the cloud are given in the sections below.
<a name="tag_cloud_output"></a>
</p>
<h4>Tag Cloud Output Formats</h4>
<p>
The traditional tag cloud output is a "heat map" of term names where larger names are associated with more attachments than smaller names. The terms' display format is determined by the "mla_output" parameter:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">flat</td>
<td>Returns a sequence of hypelink tags without further HTML markup. The "separator" parameter content (default, one newline character) is inserted between each hyperlink. This is the default value.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">list</td>
<td>Returns hyperlinks enclosed by one of the HTML list tags; unordered (&lt;ul&gt;&lt;/ul&gt;), ordered (&lt;ol&gt;&lt;/ol&gt;) or definitions (&lt;dl&gt;&lt;/dl&gt;), which allow for each term to have a "caption". The "itemtag", "termtag" and "captiontag" parameters customize the list markup.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">grid</td>
<td>Modeled on the galleries produced by <code>[mla_gallery]</code>; a rectangular display with rows and columns. The tag parameters listed above, the "columns" parameter and the Display Style parameters customize the display.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">array</td>
<td>Returns a PHP array of cloud hyperlinks. This output format is not available through the shortcode; it is allowed when the <code>MLAShortcodes::mla_tag_cloud()</code> function is called directly from your theme or plugin PHP code.</td>
</tr>
</table>
<p>
The "list" and "grid" formats can be extensively customized by using custom <a href="#mla_gallery_templates"><strong>Style and Markup Templates</strong></a>. The <code>[mla_tag_cloud]</code> shortcode also supports pagination with "previous_link", "current_link", "next_link", "previous_page", "next_page" and "paginate_links" formats. These are essentially the same as those for the <code>[mla_gallery]</code> shortcode.
<a name="tag_cloud_items"></a>
</p>
<h4>Tag Cloud Item Parameters</h4>
<p>
Each item in the tag cloud comprises a term name of varying size, a hyperlink surrounding the term name and a "title" attribute (Rollover Text) displayed when the cursor hovers over the term name hyperlink. The following parameters customize item content and markup:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">smallest</td>
<td>The text size (default 8) of the tag with the smallest count value (units given by unit parameter).</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">largest</td>
<td>The text size (default 22) of the tag with the highest count value (units given by the unit parameter).</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">unit</td>
<td>Unit of measure as pertains to the smallest and largest values. This can be any CSS length value, e.g. pt (the default), px, em, %.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">separator</td>
<td>The text/space between tags. Default '\n' (whitespace)</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">single_text</td>
<td>The text for the "title" attribute (Rollover Text) when the count value is one. The default is '%d item". If you change the default, don't forget to include the '%d" placeholder.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">multiple_text</td>
<td>The text for the "title" attribute (Rollover Text) when the count value is zero or more than one. The default is '%d items". If you change the default, don't forget to include the '%d" placeholder.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">link</td>
<td>Chooses the destination of the item hyperlink; details in the next section below.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">current_item</td>
<td>Identifies the current/selected item in the cloud. An integer value will be interpreted as a term id and anything else as a term slug. It will be ignored if it does not match an item in the cloud.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">current_item_class</td>
<td>The class attribute for the current item in the cloud as determined by the "current_item" parameter (if specified), Defaults to "mla_current_item".</td>
</tr>
</table>
<p>
The Item parameters are an easy way to customize the content and markup for each cloud item. For the list and grid formats you can also use the <a href="#tag_cloud_display_content">Tag Cloud Display Content parameters</a> and/or Style and Markup Templates for even greater flexibility.
<a name="tag_cloud_link"></a>
</p>
<h4>Tag Cloud Item Link</h4>
<p>
The Link parameter specifies the target and type of link from the tag cloud term/item to the item's archive page, edit page or other destination. You can also specify a non-hyperlink treatment for each item.
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">view</td>
<td>Link to the term's "archive page"; this is the default value. Support for archive pages, or "tag archives", is theme-dependent. There is an introduction to tag archives in the WordPress Codex at the bottom of the <a href="http://codex.wordpress.org/Function_Reference/wp_tag_cloud#Creating_a_Tag_Archive" title="Codex Tag Archive Discussion" target="_blank"><code>wp_tag_cloud</code> Function Reference</a>.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">edit</td>
<td>Link to the term's "edit tag/category" admin screen. This is only useful if the user is logged in and has the appropriate role or capabilities for accessing the edit screen.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold; font-style:italic">(mla_link_href)</td>
<td>Link to a custom destination, typically another post/page. If the "mla_link_href" parameter is present the value of the "link" parameter is ignored. See the pagination example later in this section for more details.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">span</td>
<td>Substitutes a <code>&lt;span&gt;&lt;/span&gt;</code> tag for the hyperlink tag. You can use the "mla_link_attributes" and "mla_link_class" parameters to add attributes to the <code>&lt;span&gt;</code> tag. You can use the "mla_link_text" parameter to customize the text within the span.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">none</td>
<td>Eliminates the hyperlink tag surrounding the item text. You can use the "mla_link_text" parameter to customize the contents.</td>
</tr>
</table>
<p>
Using the "mla_link_href" parameter to completely replace the link destination URL is a common and useful choice. With this parameter us can use the tag cloud to select a term and then go to another post/page that uses that selection as part of an <code>[mla_gallery]</code> shortcode. The pagination example later in this section uses this technique. 
<a name="tag_cloud_display_style"></a>
</p>
<h4>Tag Cloud Display Style (list and grid)</h4>
<p>
Two parameters provide a way to apply custom style and markup templates to your <code>[mla_tag_cloud]</code> display. These parameters replace the default style and/or markup templates with templates you define on the "MLA Gallery" tab of the Settings page. Templates are supported for the "list" and "grid" cloud formats.
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_style</td>
<td>replaces the default style template for an <code>[mla_tag_cloud]</code> shortcode. You can code "none" to suppress the addition of CSS inline styles entirely.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_markup</td>
<td>replaces the default markup template for an <code>[mla_tag_cloud]</code> shortcode</td>
</tr>
</table>
<p>
Three parameters provide control over the placement, size and spacing of terms in the "grid" format without requiring the use of custom Style templates.
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_float</td>
<td>specifies the CSS float attribute of the ".tag-cloud-item" style. Acceptable values are "left", "none", "right"; the default value is "right" if current locale is RTL, "left" on LTR (left-to-right inline flow, e.g., English).</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_margin</td>
<td>specifies the CSS margin property of the ".tag-cloud-item" style. The default value is "1.5%", a percent of the total grid width. You can also specify any dimension value, e.g., "10px" or "2em", as well as the "auto" or "inherit" values. Finally, you can specify "none", which will remove the margin property from the styles template altogether.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_itemwidth</td>
<td>specifies the CSS width attribute of the ".tag-cloud-item" style. You can specify a percent of the total grid width, e.g., "33.3%". You can also specify any dimension value, e.g., "10px" or "2em", as well as the "auto" or "inherit" values. You can specify "none", which will remove the margin property from the styles template altogether.
<br />&nbsp;<br />
Two additional values, "calculate" (the default) and "exact",  calculate the width automatically, based on the "columns" and "mla_margin" values. For "calculate", the width is calculated by dividing 100% by the number of columns, then subtracting twice the margin. For example, the default value is (floor(1000/3)/10) - ( 2.0 * 1.5 ) = 30.3%. Adding in the left and right margins makes each column 33.3% and the total width will be 99.9%
<br />&nbsp;<br />
For the "exact" value, the calculation is the same but the margin is ignored, so the width value would be 33.3%.</td>
</tr>
</table>
<p>
The default margin and width calculations try to make the total width of each row as close to 100% as possible, but never exceed 100% due to rounding errors. If you have more advanced style and format needs, you can define custom style and/or markup templates. You can also code <code>mla_style=none</code> to suppress inline styles entirely and use a separate stylesheet to control the format of the grid.
<a name="tag_cloud_display_content"></a>
</p>
<h4>Tag Cloud Display Content</h4>
<p>
Eight parameters provide an easy way to control the contents of tag cloud items without requiring the use of custom Markup templates.  
</p>
<table>
<tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_link_attributes</td>
<td>adds one or more HTML attributes to the hyperlink for each item; see below</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_link_class</td>
<td><strong>adds</strong> one or more classes to any already defined for the hyperlink </td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_link_href</td>
<td>replaces the HTML "href" attribute in the hyperlink for each item; see below</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_link_text</td>
<td>replaces the term name text displayed for each item</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_nolink_text</td>
<td>replaces the empty string displayed when there are no cloud items or no pagination link</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_rollover_text</td>
<td>replaces the HTML "title" attribute in the hyperlink for each item. This is the attachment title text displayed when the mouse rolls or hovers over the term name</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_caption</td>
<td>replaces the caption text displayed beneath each item. The caption appears for "grid" items and for "list" items when the "captiontag" parameter is present.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_target</td>
<td>adds an HTML "target" attribute to the hyperlink for each gallery item; see below</td>
</tr>
<tr>
</table>
<p>
All but the "mla_target" parameter support the <a href="#tag_cloud_markup_parameters">Markup</a>, <a href="#tag_cloud_item_parameters">Item-specific</a>, <a href="#tag_cloud_variable_parameters">Field-level</a> and <a href="#mla_template_parameters">Content Template</a> substitution parameters defined for Markup Templates. For example, if you code "<code>mla_rollover_text='{+slug+} : {+rollover_text+}'</code>, the rollover text will contain the term slug, a colon, and the appropriate "single text" or "multiple text". Simply add "{+" before the substitution parameter name and add "+}" after the name. Note that the enclosing delimiters are different than those used in the templates, since the WordPress shortcode parser reserves square brackets ("[" and "]") for its own use.
</p>
<p>
The "mla_link_href" parameter is a great way to change the destination your cloud item links to and/or add arguments to the link for later processing. For example, to make a gallery item link back to the current page/post you can code: <code>mla_link_href='{+page_url+}'</code>. You can also add arguments to the link, e.g., <code>mla_link_href='{+page_url+}&amp;amp;myarg=myvalue'</code>. Note the use of the HTML entity name "&amp;amp;" to put an ampersand in the value; the WordPress "visual" post editor will replace "&", "<" and ">" with "&amp;amp;", "&amp;lt;" and "&amp;gt;" whether you like it not. The <strong>only</strong> markup parameters modified by this parameter are "link_url" and "thelink". The markup parameters "viewlink" and "editlink" are not modified.
</p>
<p>
The "mla_link_attributes" parameter accepts any value and adds it to the "&lt;a&gt;" or "&lt;span&gt;" tags for the item. For example, you can add a unique identifier to each item by adding <code>mla_link_attributes='id="{+selector}-{+index+}"'</code> to your shortcode (note the use of single quotes around the parameter value and the double quotes within the parameter). <strong>IMPORTANT:</strong> since the shortcode parser reserves square brackets ("[" and "]") for its own use, <strong>you must substitute curly braces for square brackets</strong> if your attributes require brackets. If you must code a curly brace in your attribute value, preface it with <strong>two backslash characters</strong>, e.g., "\\{" or "\\}". If you code an attribute already present in the tag, your value will override the existing value.
</p>
<p>
The "mla_target" parameter accepts any value and adds an HTML "target" attribute to the hyperlink with that value. For example, if you code <code>mla_target="_blank"</code> the item will open in a new window or tab. You can also use "_self", "_parent", "_top" or the "<em>framename</em>" of a named frame.
<a name="tag_cloud_data_selection"></a>
</p>
<h4>Tag Cloud Data Selection Parameters</h4>
<p>
The data selection parameters specify which taxonomy (or taxonomies) the terms are taken from, which terms are returned for the cloud and the order in which the terms are returned:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">taxonomy</td>
<td>The taxonomy or taxonomies to retrieve terms from; default "post_tag". Use the name/slug of each taxonomy, not the display name, e.g., 'post_tag', 'category', 'attachment_tag', or 'attachment_category'. You can specify multiple taxonomies as a comma-separated string or (if you are calling <code>MLAShortcodes::mla_tag_cloud()</code> function directly from your theme or plugin PHP code) as an array.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post_mime_type</td>
<td>The MIME type(s) of the items to include in the term-specific counts. The default is "all", which avoids the additional database effort required to filter by MIME type. You can override the default to, for example, display PDF documents (<code>post_mime_type=application/pdf</code>) or all image MIME types (<code>post_mime_type=image</code>). You can select several MIME types with a comma-separated list, e.g., <code>post_mime_type='audio,video'</code>. Wildcard specifications are also supported. For example, <code>post_mime_type='*/mpeg'</code> to select audio and video mpeg formats or <code>post_mime_type='application/*ms*'</code> to select all Microsoft application formats (Word, Excel, etc.).</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post_type</td>
<td>The <a href="http://codex.wordpress.org/Post_Types" title="WordPress Codex &quot;Post Types&quot; page" target="_blank">post type(s)</a> of the items to include in the term-specific counts. The default is "attachment". You can override the default if you want to count other types for which the taxonomy is registered, e.g., "post" to count Posts in the "category" and "post_tag" taxonomies. The <a href="http://codex.wordpress.org/Post_Types" title="WordPress Codex &quot;Post Types&quot; page" target="_blank">Codex Page</a> documents other post type values. Make sure your "post_status" and "post_type" values are consistant, e.g., use <code>post_type="attachment,post" post_status="inherit,publish"</code> together.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post_status</td>
<td>The <a href="http://codex.wordpress.org/Post_Status" title="WordPress Codex &quot;Post Status&quot; page" target="_blank">post status value(s)</a> of the items to include in the term-specific counts. The default is "inherit", which counts attachments (Media Library Items). You can override the default if you want to count other values, e.g., "publish" to count published Posts in the "category" and "post_tag" taxonomies. If you code "private" and the user is not logged in, "private" will be removed. The <a href="http://codex.wordpress.org/Post_Status" title="WordPress Codex &quot;Post Status&quot; page" target="_blank">Codex page</a> documents other post status values.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">ids</td>
<td>A comma-separated list of <strong>attachment ID</strong> values for an item-specific cloud. Only those terms assigned to the attachment(s) in the list will be included. You can have one or more IDs, and you can include assigned terms from one or more taxonomies. Do not use the "include" parameter if you use the "ids" parameter.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">no_count</td>
<td>The default, "false", computes a term-specific count of the number of attachments assigned to that term. If you have a large number of terms and/or attachments, this can take a long time.<br />
&nbsp;<br />
You can code "true" to omit the attachment-counting process. If you do that, the "post_mime_type", "post_type", "post_status", "minimum", "number" and "orderby=count" parameters are also ignored, since they require counting the attachments.<br />
&nbsp;</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">include</td>
<td>A comma-separated list of term ids (<strong>not</strong> names or slugs) to include. Only the terms in this list that are used in the taxonomies you specified will be retrieved.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">exclude</td>
<td>A comma-separated list of term ids (<strong>not</strong> names or slugs) to exclude from the returned values.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">parent</td>
<td>Get direct children of this term id (only terms whose explicit parent is this value). If 0 is passed, only top-level terms are returned.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">minimum</td>
<td>The minimum number of attachments that must be associated with the term for the term to be included. For example, "minimum=1" will omit "empty" terms.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">number</td>
<td>The maximum number of "most popular" terms to return. The default, zero, returns them all. Terms are sorted by "count DESC, id ASC" to apply this constraint.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">orderby</td>
<td>The sort order of the retrieved terms. Can be one or more of "count", "id" (term_id), "name" (the default), "none", "random", or "slug".</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">order</td>
<td>Can be "ASC" (ascending, the default) or "DESC" (descending).</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">preserve_case</td>
<td>Preserve upper- and lower-case distinctions when sorting by name. The default, "false", specifies a case-insensitive sort order.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">pad_counts</td>
<td>True to include the count of all children in their parents' count. The default, "false", does not include children in their parents' count.<br />
&nbsp;<br />
The "pad_counts" parameter is only applied to the first (or only) taxonomy you specify, and that taxonomy must be hierarchical to see any difference in the counts.<br />
&nbsp;</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">limit</td>
<td>The number of terms to return. This parameter is used for pagination; it is applied <strong>after</strong> and separate from the "number" parameter above.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">offset</td>
<td>The number of terms to skip before returning the results. This parameter is used for pagination.</td>
</tr>
</table>
<p>
You can sort on more than one value, e.g., <code>orderby="count DESC, name"</code> and you can specify ASC/DESC on a value by value basis. <strong>NOTE: multiple orderby values are separated by commas, not spaces.</strong> This is a change from WP_Query.
</p>
<p>
The order parameter (default ASC) can give an ASC/DESC default for any value that doesn't have a specific choice. For example, <code>orderby="count DESC, name" order=ASC</code> is the same as <code>orderby="count DESC, name ASC"</code>.
<a name="tag_cloud_debugging_output"></a>
</p>
<h4>Debugging Output</h4>
<p>
The "mla_debug" parameter controls the display of information about the query parameters and SQL statements used to retrieve tag cloud items. If you code <code>mla_debug=true</code> you will see a lot of information added to the post or page containing the cloud. Of course, this parameter should <strong><em>ONLY</em></strong> be used in a development/debugging environment; it's quite ugly.
<a name="tag_cloud_substitution"></a>
</p>
<h4>Tag Cloud Substitution Parameters</h4>
<p>
Substitution parameters are a powerful way to add general and attachment-specific values to the gallery display. For example, if you code "<code>mla_link_href="{+page_url+}?current_id={+term_id+}&amp;mla_cloud_current={+request:mla_cloud_current+}"</code>, the hyperlinks behind each cloud term will contain the page URL and the taxonomy term ID. There are many parameter names like `page_url` and `term_id` divided in several categories:
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Cloud-specific</td>
<td>values that are known at the beginning of shortcode processing and remain the same for the entire shortcode, such as the ID and URL of the post/page in which the shortcode appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Style</td>
<td>values that are known when the cloud-specific CSS inline styles are composed just before cloud output begins</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Markup</td>
<td>values that are known at the beginning of cloud output processing and remain the same for the entire cloud</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Item-specific</a></td>
<td  style="vertical-align: top">values that change for each term/item in the cloud, such as Name and Description</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold"><a href="#mla_variable_parameters">Field-level</a></td>
<td>additional values from sources like query arguments and shortcode parameters. The "request:" and "query:" field-level prefixes can be used in the cloud. The other prefixes are attachment-specific and have no meaning in a cloud</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold"><a href="#mla_template_parameters">Content Template</a></td>
<td>lets you compose a value from multiple substitution parameters and test for empty values, choose among two or more alternatives or suppress output entirely</td>
</tr>
</table>
&nbsp;<br />
The following paragraphs go into more detail about each category and the parameter names within them.
</p>
<p>
To use a substitution parameter in your shortcode, simply add "{+" before the substitution parameter name and add "+}" after the name. Note that the enclosing delimiters are different than those used in Style and Markup templates, since the WordPress shortcode parser reserves square brackets ("[" and "]") for its own use. Also, because square brackets are reserved, <strong>you must substitute curly braces for square brackets</strong> if your parameter values require them. For example, if your shortcode parameter is <code>mla_link_attributes='rel="shadowbox{sbalbum-{+instance+}};player=img"'</code>, the actual attribute added to the link will be <code>rel="shadowbox[sbalbum-1];player=img"</code>. If you must code a curly brace in a parameter value, preface it with <strong>two backslash characters</strong>, e.g., "\\{" or "\\}".
</p>
<p>
<strong>Cloud-specific substitution parameters</strong> are known at the beginning of shortcode processing and they do not change during processing. They can be used, for example, in any of the data selection parameters to change the items selected for the cloud based on information about the post/page on which the cloud appears. The cloud-specific substitution parameters are:
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">site_url</td>
<td>absolute URL to the site directory, without trailing slash</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">base_url</td>
<td>absolute URL to the upload directory, without trailing slash</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">base_dir</td>
<td>absolute (full) path to the upload directory, without trailing slash</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">instance</td>
<td>starts at '1', incremented for each additional shortcode in the post/page</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">selector</td>
<td>"mla_tag_cloud-{$instance}", e.g., mla_tag_cloud-1</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_ID,<br />id</td>
<td style="vertical-align: top">the <code>ID</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_author</td>
<td>the <code>post_author</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_date</td>
<td>the <code>post_date</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_content</td>
<td>the <code>post_content</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_title</td>
<td>the <code>post_title</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_excerpt</td>
<td>the <code>post_excerpt</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_status</td>
<td>the <code>post_status</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_name</td>
<td>the <code>post_name</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_modified</td>
<td>the <code>post_modified</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_guid</td>
<td>the <code>post_guid</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_type</td>
<td>the <code>post_type</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_url</td>
<td>absolute URL to the page or post on which the cloud appears, if any, with trailing slash</td>
</tr>
</table>
<p>
Style and Markup templates give you great flexibility for the content and format of each [mla_tag_cloud] when you use the "list" and "grid" output formats. You can define as many templates as you need. 
</p>
<p>
Style templates provide cloud-specific CSS inline styles (you can code mla_style=none to suppress the addition of CSS inline styles entirely). Markup templates provide the HTML markup for 1) the beginning of the cloud, 2) the beginning of each row ("grid" format), 3) each cloud item, 4) the end of each row ("grid" format) and 5) the end of the cloud. The MLA Gallery tab on the Settings page lets you add, change and delete custom templates. The default templates are also displayed on this tab for easy reference. 
</p>
<p>
For the "grid" output format, all of the Markup template sections are used. For the "list" output format, only the "Open", "Item" and "Close" sections are used. There are two default templates for the "list" format; "tag-cloud-ul" and "tag-cloud-dl". As the names imply, the "tag-cloud-dl" default is used when the "captiontag" parameter is present in the shortcode. If you name a custom Markup template in your shortcode, it will be used whether the "captiontag" is present or not.
</p>
<p>
The following <strong>field-level substitution parameters</strong> are available in the Style template and any of the Markup template sections:</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">request</td>
<td>The parameters defined in the <code>$_REQUEST</code> array; the "query strings" sent from the browser. The PHP $_REQUEST variable is a superglobal Array that contains the contents of both $_GET, $_POST, and $_COOKIE arrays.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">query</td>
<td>The parameters defined in the <code>[mla_tag_cloud]</code> shortcode. For example, if your shortcode is <code>[mla gallery taxonomy=attachment_tag div-class=some_class]</code> you can access the parameters as <code>[+query:taxonomy+]</code> and <code>[+query:div-class+]</code> respectively. You can define your own parameters, e.g., "div-class"; they will be accessible as field-level data but will otherwise be ignored.</td>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">template</td>
<td>A Content Template, which lets you compose a value from multiple substitution parameters and test for empty values, choosing among two or more alternatives or suppressing output entirely. See the <a href="#mla_template_parameters">Content Templates</a> section for details. Note that the formatting option is not supported for content templates.</td>
</tr>
</table>
<p>
Tag cloud substitution parameters for the <strong>Style template</strong> are:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_style</td>
<td>shortcode parameter, default = 'tag-cloud'</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_markup</td>
<td>shortcode parameter, default = 'tag-cloud-ul', or 'tag-cloud-dl' if the "captiontag" parameter is present.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">taxonomy</td>
<td>the slug of the taxonomy on which the cloud is based. Multiple taxonomy slugs are joined with a dash to form a single value.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">current_item</td>
<td>the current/selected item in the cloud, as entered in the shortcode parameters.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">itemtag</td>
<td>shortcode parameter, default = 'ul', or 'dl' if the "captiontag" parameter is present.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">termtag</td>
<td>shortcode parameter, default = 'li', or 'dd' if the "captiontag" parameter is present.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">captiontag</td>
<td>shortcode parameter, default = '', i.e., no caption tag value.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">columns</td>
<td>shortcode parameter, default = '3'; only meaningful for the "grid" output format.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">itemwidth</td>
<td>shortcode parameter, default is calculated by dividing 100% by the number of columns and subtracting twice the margin value, e.g., 30.3% for three columns and a margin value of 1.5%. Can also contain other dimensional values such as '10px' or CSS-specific values like 'auto' or 'inherit'.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">margin</td>
<td>shortcode parameter, default = '1.5%'. Can also contain other dimensional values such as '10px' or CSS-specific values like 'auto' or 'inherit'.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">float</td>
<td>'right' if current locale is RTL, 'left' if not</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">found_rows</td>
<td>the number of terms retrieved for the cloud</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">min_count</td>
<td>the smallest number of attachments associated with any term</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">max_count</td>
<td>the largest number of attachments associated with any term</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">min_scaled_count</td>
<td>the smallest scaled count associated with any term</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">max_scaled_count</td>
<td>the largest scaled count associated with any term</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">spread</td>
<td>max_scaled_count - min_scaled_count</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">smallest</td>
<td>the text size of the tag with the smallest count value</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">largest</td>
<td>the text size of the tag with the largest count value</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">unit</td>
<td>Unit of measure as pertains to the smallest and largest values</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">font_spread</td>
<td>largest - smallest</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">font_step</td>
<td>font_spread / spread</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">separator</td>
<td>The text/space between tags</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">single_text</td>
<td>Rollover Text when the count value is one</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">multiple_text</td>
<td> Rollover Text when the count value is zero or more than one</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">echo</td>
<td>whether the output is echoed directly to the browser (true) or returned to the caller (false). For a shortcode, always false.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">link</td>
<td>the destination of the item hyperlink</td>
</tr>
</table>
<p>
Tag cloud substitution parameters for the <strong>Markup template</strong> are available in all of the template sections. All of the <strong>cloud-specific substitution parameters</strong> and the <strong>substitution parameters for Style templates</strong> are available for use in markup templates. There are no additional substitution parameters defined at the start of markup processing, but there are <a href="#mla_tag_cloud_hooks">MLA Tag Cloud Filters (Hooks)</a> that could add, modify or delete parameters available for markup processing, if your application uses them.
</p>
<p>
Tag cloud <strong>item-specific substitution parameters</strong> for the Markup template are available in the "Item" section of the template. They include all of the parameters defined above (for the Style and Markup templates) Additional item-specific parameters are:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">index</td>
<td>starts at '1', incremented for each item in the cloud</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">last_in_row</td>
<td>for the "grid" output format, set to "last_in_row" for the last item in each full cloud row, and to an empty string for all other items in the row. If the cloud ends with a partial row, the last_in_row parameter is not set.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">key</td>
<td>set to the "tags" array key/index value. Only useful if the <code>mla_get_terms_query_results()</code> filter has altered the array keys.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">term_id</td>
<td>the term id</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">name</td>
<td>the term display name</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">slug</td>
<td>the term slug</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">term_group</td>
<td>the term group</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">term_taxonomy_id</td>
<td>the term-taxonomy id</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">taxonomy</td>
<td>the primary taxonomy for this term</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">description</td>
<td>the term description, if any</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">parent</td>
<td>the direct parent of the term</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">count</td>
<td>the number of attachments associated with the term</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">scaled_count</td>
<td>scaled count value, for determining font size. The default fomula for scaling the count is <code>round(log10($tag->count + 1) * 100)</code></td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">font_size</td>
<td>the numeric portion of the CSS "font-size" attribute</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">link_url</td>
<td>the URL portion of "thelink" (below). Derived from editlink_url, termlink_url or mla_link_href.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">editlink_url</td>
<td>URL of the term's "edit category/tag" page</td></tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">termlink_url</td>
<td>URL of the term's archive page</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">caption</td>
<td>if captiontag is not empty, contains term description or the mla_caption value</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">link_attributes</td>
<td>link attributes, if any, drawn from the mla_target, mla_link_attributes and mla_link_class parameters</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">current_item_class</td>
<td>set to "mla_current_item" for the current item in the cloud as determined by the "current_item" parameter, and to an empty string for all other items in the cloud.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">rollover_text</td>
<td>the "title" attribute value, drawn from single_text/multiple_text or the mla_rollover_text parameters</td>
</tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">link_style</td>
<td>the CSS "style" attribute, drawn from the font_size and unit parameters</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">link_text</td>
<td>the text enclosed by the hyperlink, drawn from the term name or mla_link_text parameter</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">editlink</td>
<td>full hyperlink to the term's "edit category/tag" page, including all the Display Content parameters</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">termlink</td>
<td>full hyperlink to the term's archive page, including all the Display Content parameters</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">thelink</td>
<td>full hyperlink to the chosen destination as determined by the "link" and "mla_link_href" parameters</td>
</tr>
</table>
<p>
&nbsp;
<a name="tag_cloud_pagination_parameters"></a>
</p>
<h4>Tag Cloud Pagination Parameters</h4>
<p>
If you have a large number of terms in your cloud taxonomy you may want to paginate the cloud display, i.e., divide the cloud into two or more pages of a reasonable size. Pagination support for <code>[mla_tag_cloud]</code> is modeled on similar functions for<code>[mla_gallery]</code>, and you can find more explaination of the ideas behind pagination in the <a href="#mla_output_parameter"><strong>Support for Alternative Gallery Output, e.g., Pagination</strong></a> section. Five parameters are supplied for this purpose:
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">limit</td>
<td>the maximum number of terms to display in one cloud "page". Think of this as a "terms per page" value.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">offset</td>
<td>the number of terms to skip over before starting the current cloud page. This parameter is usually derived automatically from the more useful "mla_cloud_current" parameter.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_page_parameter</td>
<td>the name of the parameter containing the current page number; default "mla_cloud_current". You can change the name if you need multiple paginated clouds on one post/page.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_cloud_current</td>
<td>the current cloud page number. The name of this parameter can be changed to support multiple paginated clouds on one post/page. This parameter will automatically be added to the URLs generated by pagination output types and managed for you.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">term_id</td>
<td>the id of the current term within the cloud. This parameter is used with the "previous_link", "current_link" and "next_link" output types. You <strong>must</strong> supply a term_id value when using these output types.</td>
</tr>
</table>
<p>
The <code>[mla_tag_cloud]</code> shortcode can be used to provide "Previous" and "Next" links that support moving among the individual items in a cloud or among cloud "pages". For example, if you have many terms in your Att. Category or Att. Tag taxonomies you can build a term-specific <code>[mla_gallery]</code> page with links to the previous/next term in the taxonomy (a complete pagination example is included below). You can also build a page that shows a large taxonomy in groups, or "cloud pages", of ten terms with links to the previous/next ten terms or links to all of the cloud pages of terms in the taxonomy.
<p>
The <strong>"mla_output"</strong> parameter determines the type of output the shortcode will return. For pagination output, you can choose from six values: 
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">next_link</td>
<td>returns a link to the next cloud item, based on the "term_id" parameter value. The optional "<strong>,wrap</strong>" qualifier determines what happens at the end of the cloud. If you omit the qualifier, an empty string is returned for the "next_link" from the last item. If you code the ",wrap" qualifier, the "next_link" from the last item will be to the first item.</td>
</tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">current_link</td>
<td>returns a link to the current cloud item, based on the "term_id" parameter value. This gives you an easy way to provide a visual indication of where you are within the taxonomy. The "span" and  "none" link formats are often used with this mla_output type.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">previous_link</td>
<td>returns a link to the previous cloud item, based on the "term_id" parameter value. The optional "<strong>,wrap</strong>" qualifier determines what happens at the beginning of the cloud. If you omit the qualifier, an empty string is returned for the "previous_link" from the first item. If you code the ",wrap" qualifier, "previous_link" from the gallery item will be to the last item.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">next_page</td>
<td>returns a link to the next "page" of cloud items, based on the "mla_cloud_current" parameter value. The optional "<strong>,wrap</strong>" or "<strong>,last</strong>" qualifiers determine what happens at the end of the taxonomy. If you omit the qualifier, an empty string is returned for the "next_page" if there are no more items in the taxonomy. If you code the ",wrap" qualifier, the "next_page" from the last page of items will be to the first page. If you code the ",last" qualifier, the "next_page" link will return to/remain on the last page.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">previous_page</td>
<td>returns a link to the previous "page" of cloud items, based on the "mla_cloud_current" parameter value. The optional "<strong>,wrap</strong>" or "<strong>,first</strong>" qualifiers determine what happens at the beginning of the taxonomy. If you omit the qualifier, an empty string is returned for the "previous_link" from the first page. If you code the ",wrap" qualifier, "previous_page" from the first page will be to the last page. If you code the ",first" qualifier, the "previous_link" link will return to/remain on the first page.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">paginate_links</td>
<td>returns a link to cloud items at the start and end of the list and to pages around the current "cloud page" ( e.g.: &laquo; Previous 1 ... 3 4 5 6 7 ... 9 Next &raquo; ), based on the "mla_cloud_current" parameter value. The optional "<strong>,show_all</strong>" qualifier will show all of the cloud pages instead of a short list around the current page. The optional "<strong>,prev_next</strong>" qualifier will include the "&laquo; Previous" and "Next &raquo;" portions of the link list.</td>
</tr>
</table>
<p>
The best way to understand cloud pagination is by example, as in the next section below.
<a name="tag_cloud_pagination_example"></a>
</p>
<h4>Tag Cloud Pagination Example</h4>
<p>
This section takes you through several of the <code>[mla_tag_cloud]</code> features, step by step. Let's start with a very simple cloud showing all of the terms in the "Att. Category" taxonomy:
</p>
<p>
<code>[mla_tag_cloud taxonomy=attachment_category number=0]</code>
</p>
<p>
The "number=0" parameter overrides the default maximum of 45 terms, showing all of the terms in the taxonomy. Let's paginate the cloud and limit the terms display to ten terms per "page":
</p>
<p>
<code>[mla_tag_cloud taxonomy=attachment_category number=0 limit=10]<br />
[mla_tag_cloud taxonomy=attachment_category number=0 limit=10  mla_output="paginate_links,prev_next"]</code>
</p>
<p>
The "limit=10" parameter (on <strong>both</strong> shortcodes) limits the term display to ten terms. The second <code>[mla_tag_cloud]</code> shortcode, adding the 'mla_output="paginate_links,prev_next"' parameter, displays a line of pagination links below the cloud page. Coordination between the two shortcodes is automatic, using the "mla_cloud_current" parameter added to the URLs by the shortcode.
</p>
<p>Now we'll make the cloud a convenient way to control a term-specific <code>[mla_gallery]</code>. The next step uses the "mla_link_href" parameter to change the link destination of each cloud term, returning to the current page with the term id of the selected term. We also add the "mla_cloud_current" parameter to each of these new links, so the tag cloud page is retained when a term is selected:
</p>
<p>
<code>[mla_tag_cloud taxonomy=attachment_category number=0 limit=10 mla_link_href="{+page_url+}?current_id={+term_id+}&amp;amp;mla_cloud_current={+request:mla_cloud_current+}"]<br />
[mla_tag_cloud taxonomy=attachment_category number=0 limit=10  mla_output="paginate_links,prev_next"]</code>
</p>
<p>
The "&amp;amp;" before the "mla_cloud_current" parameter is required to get by the WordPress Visual Editor. The "{+request:mla_cloud_current+}" value copies the current page number from the URL ($_REQUEST array) and adds it to each term's link. Now, let's use the "current_id={+term_id+}" information in the link to compose a term-specific <code>[mla_gallery]</code>: 
</p>
<p>
<code>[mla_tag_cloud taxonomy=attachment_category number=0 limit=10 mla_link_href="{+page_url+}?current_id={+term_id+}&amp;amp;mla_cloud_current={+request:mla_cloud_current+}"]<br />
[mla_tag_cloud taxonomy=attachment_category number=0 limit=10  mla_output="paginate_links,prev_next"]
<br />&nbsp;<br />
[mla_gallery post_mime_type=all tax_query="array ( 0 => array ( 'taxonomy' => 'attachment_category', 'field' => 'id', 'terms' => array( {+request:current_id+} ), 'include_children' => false ) )" mla_caption="{+title+}" columns=5 size=icon link=file]</code>
</p>
<p>
The most complicated part of the new shortcode is the "tax_query" parameter, which we're using to ensure that the gallery items displayed match the count displayed for each term in the tag cloud. The tag cloud count does not contain items associated with any "child terms", or sub-categories, of the cloud item. To match this count we must use the "include_children=false" and "field=id" parameters of the "tax_query".
</p>
<p>
We can easily paginate the term-specific gallery by adding a second <code>[mla_gallery]</code> shortcode and a "posts_per_page" parameter to both shortcodes:
</p>
<p>
<code>[mla_tag_cloud taxonomy=attachment_category number=0 limit=10 mla_link_href="{+page_url+}?current_id={+term_id+}&amp;amp;mla_cloud_current={+request:mla_cloud_current+}"]<br />
[mla_tag_cloud taxonomy=attachment_category number=0 limit=10  mla_output="paginate_links,prev_next"]
<br />&nbsp;<br />
[mla_gallery post_mime_type=all tax_query="array ( 0 => array ( 'taxonomy' => 'attachment_category', 'field' => 'id', 'terms' => array( {+request:current_id+} ), 'include_children' => false ) )" mla_caption="{+title+}" columns=5 posts_per_page=5 size=icon link=file]
<br />&nbsp;<br />
[mla_gallery post_mime_type=all tax_query="array ( 0 => array ( 'taxonomy' => 'attachment_category', 'field' => 'id', 'terms' => array( {+request:current_id+} ), 'include_children' => false ) )" columns=5 posts_per_page=5 mla_output="paginate_links,prev_next"]</code>
</p>
<p>
The pagination controls for the tag cloud and the gallery operate independently because by default they use different names for their respective "_current" page parameters. Our page now has a lot of functionality without requiring any WordPress templates or PHP code.
</p>
<p>
For extra credit, let's add some more navigation options to the page. We'll build previous, current and next term links at the bottom of the page. These are enclosed in an HTML table so they all appear on one line of the page. Here is just the additional content; the table of three link navigation controls:
</p>
<p>
<code>
&lt;table width=99%&gt;&lt;tr&gt;<br />
&lt;td width=33% style="text-align: left"&gt;[mla_tag_cloud taxonomy=attachment_category number=0 term_id="{+request:current_id+}" mla_output="previous_link" smallest=12 largest=12 mla_link_href="{+page_url+}?current_id={+term_id+}" mla_link_text="Previous: {+name+}"]&lt;/td&gt;<br />&nbsp;<br />
&lt;td width=33% style="text-align: center; font-weight: bold:"&gt;[mla_tag_cloud taxonomy=attachment_category number=0 term_id="{+request:current_id+}" mla_output=current_link smallest=12 largest=12 mla_link_text="Current: {+name+}" link=span]&lt;/td&gt;<br />&nbsp;<br />
&lt;td width=33% style="text-align: right"&gt;[mla_tag_cloud taxonomy=attachment_category number=0 term_id="{+request:current_id+}" mla_output="next_link" smallest=12 largest=12 mla_link_href="{+page_url+}?current_id={+term_id+}" mla_link_text="Next: {+name+}"]&lt;/td&gt;<br />
&lt;/tr&gt;&lt;/table&gt;
</code>
</p>
<p>
The "smallest=12" and "largest=12" parameters make "font-size" the same for all of the term names regardless of how many items are associated with the term. The "mla_link_text" parameters add labels to each of the three navigation links. Finally, the "link=span" parameter in the middle ("mla_output=current_link") shortcode removes the hyperlink behind the term name, since it would just take you back to the page you're already on.
<a name="mla_tag_cloud_hooks"></a>
</p>
<h4>MLA Tag Cloud Filters (Hooks)</h4>
<p>
The <code>[mla_tag_cloud]</code> shortcode supports a comprehensive set of filters that give you complete control over cloud composition from PHP code in your theme or in another plugin. An example of using the hooks from a simple, stand-alone plugin can be found here: <a title="View the Tag Cloud Hooks Example source code" href="[+examples_url+]mla-cloud-hooks-example.php.txt" target="_blank" style="font-size:14px; font-weight:bold">mla-cloud-hooks-example.php.txt</a>. To run the example:
<ol>
<li>Edit the code to, for example, uncomment the <code>error_log()</code> calls so you can see what is passed to the hooks you are interested in.</li>
<li>Remove the ".txt" extension and save the "mla-cloud-hooks-example.php" file in your plugins directory. You can give the plugin and its file any (unique) name you like.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA Tag Cloud Hooks Example" plugin.</li>
<li>Create a new <code>[mla_tag_cloud]</code> shortcode or modify an existing shortcode, adding the <code>my_filter="color cloud"</code> parameter to activate the example output.</li>
<li>View the post or page on which the modified shortcode appears to see a tag cloud with a range of colors applied to the terms.</li>
</ol>
</p>
<p>
The example code documents each hook with comments in the filter/action function that intercepts the hook. Generally, each part of the gallery supports three hooks: 1) a "<strong>values</strong>" hook, which lets you record or update the substitution values for that gallery part, 2) a "<strong>template</strong>" hook, which lets you record/update the template used to generate the HTML markup, and 3) a "<strong>parse</strong>" hook which lets you modify or replace the markup generated for a gallery part. The current hooks are:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_tag_cloud_attributes,<br />mla_tag_cloud_arguments</td>
<td>called at the beginning of the cloud generation. You can record/modify shortcode parameter values before (attributes) or after (arguments) they are combined with all the defaults.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_get_terms_query_attributes,<br />mla_get_terms_query_arguments</td>
<td>called just before the <code>WP_Query->query()</code> call that selects gallery items, with query parameters before or after they are combined with defaults.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_get_terms_clauses</td>
<td>gives you a final opportunity to inspect or modify the SQL clauses for the data selection process.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_get_terms_query_results</td>
<td>called just after the <code>$wpdb->get_results</code> call, so you can inspect/record or modify the results.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_tag_cloud_scale</td>
<td>called as the scaled_count (size) of each term is calculated, so you can modify the results.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">use_mla_tag_cloud_style</td>
<td>allow or suppress the inclusion of CSS styles in the tag cloud output.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_tag_cloud_style_values,<br /> mla_tag_cloud_style_template,<br />mla_tag_cloud_style_parse</td>
<td>for manipulating the Style template.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_tag_cloud_open_values,<br />mla_tag_cloud_open_template,<br />mla_tag_cloud_open_parse</td>
<td>for manipulating the "Open" part of the Markup template used in a "list" or "grid" cloud.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_tag_cloud_row_open_values,<br />mla_tag_cloud_row_open_template,<br />mla_tag_cloud_row_open_parse</td>
<td>for manipulating the "Row Open" part of the Markup template used in a "grid" cloud.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_tag_cloud_item_values,<br />mla_tag_cloud_item_template,<br />mla_tag_cloud_item_parse</td>
<td>for manipulating the "Item" part of the Markup template used in a "list" or "grid" cloud.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_tag_cloud_row_close_values,<br />mla_tag_cloud_row_close_template,<br />mla_tag_cloud_row_close_parse</td>
<td>for manipulating the "Row Close" part of the Markup template used in a "grid" cloud.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_tag_cloud_close_values,<br />mla_tag_cloud_close_template,<br />mla_tag_cloud_close_parse</td>
<td>for manipulating the "Close" part of the Markup template used in a "list" or "grid" cloud.</td>
</tr>
</table>
<a name="gallery_examples"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>MLA Gallery Examples</h3>
<p>
As you can tell from the number of parameters available, the <code>[mla_gallery]</code> shortcode is powerful, but it can be complex. The examples in this section show several of the more popular applications, taken from topics in the MLA Support Forum.
<a name="simple_examples"></a>
</p>
<h4>Simple Examples</h4>
<p>
<ul style="list-style-position:inside; list-style:disc; line-height: 15px; padding-left: 20px">
<li><code>[mla_gallery]</code> - will display all the images "attached" to the current post/page.</li>
<li><code>[mla_gallery ids="1,3,2,4"]</code> - will display specific images on any post/page. The numbers are the ID values of the images. You can use the "Add Media..." popup window and "Create Gallery" to get the list, then change the shortcode name to "mla_gallery" if you want to add other <code>[mla_gallery]</code> specific parameters.</li>
<li><code>[mla_gallery post_parent=all]</code> - will display all the images in your Media Library.</li>
<li><code>[mla_gallery post_parent=all post_mime_type=application/pdf]</code> - will display all the PDF documents in your Media Library. Since PDF documents are not images, the title of the document will display in place of the thumbnail image.</li>
<li><code>[mla_gallery post_parent=all post_mime_type="audio,video"]</code> - will display all the audio and video documents in your Media Library.</li>
<li><code>[mla_gallery post_parent=all post_mime_type=application/pdf size=icon link=file]</code> - will display all the PDF documents in your Media Library. The "PDF icon" will display in place of the thumbnail. When the icon is clicked, the document itself will be displayed in the browser.</li>
</ul>
</p>
<p>
Perhaps the most popular Media Library Assistant feature is the ability to assign category and tag values to Media LIbrary Items and use the values to filter a gallery display. "Categories" and "Tags" are built-in WordPress "taxonomies" and have been used for a long time to organize posts and pages. WordPress does not have built-in support for using them with attachments, and that was one of the original motivations for MLA.
</p>
<p>
With MLA you can extend Categories and Tags support to attachments. MLA also provides two additional taxonomies for your convenience, Att. Categories and Att. Tags. Because of the way WordPress works, using Categories and Tags for attachments as well as posts and pages can be complicated, so many people find that using the separate Att. Categories and Att. Tags is more convenient.
</p>
<p>
To use a taxonomy you must create one or more "terms" within it. For example, you could create terms in the Category taxonomy like "Big Dog" and "Little Dog". For each term, WordPress automatically creates a "slug", e.g., "big-dog" and "little-dog" for the previous examples. Removing capital letters, spaces and punctuation makes it easier to organize and search the database. It's the slug you can use in [mla_gallery] shortcodes. To "<em>display the attachments that have been assigned to a single category/tag</em>", use the term's slug; for the four taxonomies we've discussed:
</p>
<ul style="list-style-position:inside; list-style:disc; line-height: 15px; padding-left: 20px">
<li>Categories: <code>[mla_gallery category_name=big-dog]</code></li>
<li>Tags: <code>[mla_gallery tag=big-dog]</code></li>
<li>Att. Categories: <code>[mla_gallery attachment_category=big-dog]</code></li>
<li>Att. Tags: <code>[mla_gallery attachment_tag=big-dog]</code></li>
</ul>
<p>
The category_name example does not follow the general rule of "taxonomy-slug = term-slug" because it was created long ago, when Categories and Tags were the only taxonomies allowed. The tag example does not follow the rule, either, since the actual taxonomy-slug is "post_tag", not "tag".
<a name="paginated_gallery"></a>
</p>
<h4>A Paginated Gallery</h4>
<p>
If your gallery display includes a large number of items it may be useful to divide the display into "pages" with a fixed upper limit of items per page. The <a href="#mla_output_parameter"><strong>Support for Alternative Gallery Output, e.g., Pagination</strong></a> section explains several ways to do that; here is one example:
<blockquote>
<code>[mla_gallery attachment_category=big-dog posts_per_page=12]</code><br />
&nbsp;<br />
<code>[mla_gallery attachment_category=big-dog posts_per_page=12 mla_output="paginate_links,prev_next"]</code>
</blockquote>
</p>
<p>
Put both of these shortcodes on a post or page to display a paginated gallery. The first <code>[mla_gallery]</code> displays the images assigned to <code>attachment_category=big-dog</code> and displays a maximum of 12 images at once. The second <code>[mla_gallery]</code> has <strong>exactly the same</strong> data selection parameter and posts per page parameter; that's essential to match up with the first shortcode. It adds one more parameter, <code>mla_output</code>. This parameter changes the display from a set of images to a set of pagination controls.
</p>
<p>
MLA will add and manage a "current page" parameter of its own so the two shortcodes stay in synch as you navigate from page to page. That's all there is to it.
<a name="cloud_and_gallery"></a>
</p>
<h4>Tag Cloud and Gallery</h4>
<p>
Adding the "taxonomy=term" parameter to your shortcode is all well and good, but letting the viewer choose a term when they view the post/page is often better. One easy way to do this is to add the <code>[mla_tag_cloud]</code> shortcode. Here is a simple combination of a cloud and a gallery display:
<blockquote>
<code>[mla_tag_cloud taxonomy=attachment_category number=0 mla_link_href="{+page_url+}?term_slug={+slug+}"]</code><br />
&nbsp;<br />
<code>[mla_gallery attachment_category="{+template:({+request:term_slug+}|a-bad-term)+}" mla_nolink_text="Click a term to display the gallery."]</code>
</blockquote>
</p>
<p>
The <code>[mla_tag_cloud]</code> displays Att. Categories terms in the familiar cloud format. The <code>number=0</code> parameter ensures that all of the terms are displayed. The <code>mla_link_href</code> parameter links each term back to the current page (<code>{+page_url}</code>) and passes a variable back with the term selection (<code>?term_slug={+slug+}</code>). If you put the <code>[mla_tag_cloud]</code> shortcode on another page or in a widget you will have to hard-code the URL portion of the link.
</p>
<p>
The <code>[mla_gallery]</code> displays the images assigned to the selected attachment_category term. The <code>mla_nolink_text</code> parameter gives the text to display when the gallery is empty, e.g., before you click on a term. In this shortcode:
</p>
<ul style="list-style-position:inside; list-style:disc; line-height: 15px; padding-left: 20px">
<li>The <code>template:</code> prefix says that this is a Content Template</li>
<li>The parentheses "()" around the two elements are used to group them into a list of alternatives</li>
<li>The vertical bar "|" between the two elements means "stop when you get a non-empty alternative"</li>
<li><code>{+request:term_slug+}</code> will be empty unless there is a term_slug in the URL</li>
<li><code>a-bad-term</code> is a literal value (and thus never empty) which does not match any term in the attachment_category taxonomy, so the gallery will be empty if this alternative is used</li>
</ul>
<p>
You can read more about templates in the <a href="#mla_template_parameters">Content Templates</a> section. You can paginate your gallery by adding a third shortcode to the post/page. Put the new shortcode between the cloud and gallery so the pagination controls will appear above the gallery display:
<blockquote>
<code>[mla_tag_cloud taxonomy=attachment_category number=0 mla_link_href="{+page_url+}?term_slug={+slug+}"]</code><br />
&nbsp;<br />
<code>[mla_gallery attachment_category="{+template:({+request:term_slug+}|a-bad-term)+} posts_per_page=12" mla_output="paginate_links,prev_next" mla_link_href="{+page_url+}?term_slug={+request:term_slug+}"]</code><br />
&nbsp;<br />
<code>[mla_gallery attachment_category="{+template:({+request:term_slug+}|a-bad-term)+}" posts_per_page=12 mla_nolink_text="Click a term to display the gallery."]</code>
</blockquote>
</p>
<p>
The <code>posts_per_page=12</code> parameter has been added to the gallery display shortcode (the third shortcode). A new <code>[mla_gallery]</code> is added to display the pagination controls. The data selection parameter and <code>posts_per_page=12</code> parameter match the gallery display shortcode below it. The <code>mla_output</code> parameter displays the pagination controls. Finally, the <code>mla_link_href="{+page_url+}?term_slug={+request:term_slug+}"</code> parameter is added so the pagination controls pass the <code>term_slug</code> from page to page.
<a name="search_form_and_gallery"></a>
</p>
<h4>Search Form and Gallery</h4>
<p>
A common alternative to the taxonomy filtering in the previous examples is a keyword-based search. This example shows a simple HTML form with a text box and a button to run the search. The user can enter one or more words to search for in the Title or Description of Media Library items, then click "Search" to display a gallery of matching images:
<blockquote>
<code>&lt;form id="mla-search-form" action="." method="post"><br />
&lt;input id="mla-search-box" name="search-string" type="text" value="" />&amp;nbsp;&lt;input id="submit" name="submit" type="submit" value="Search" /><br />
&lt;/form></code><br />
&nbsp;<br />
<code>[mla_gallery s="{+template:({+request:search-string+}|a-bad-term)+}" mla_nolink_text="Enter a search value above to display gallery."]</code>
</blockquote>
</p>
<p>
In this example the <code>name="search-string"</code> parameter is passed from the form to the <code>s="{+request:search-string+}</code>... parameter in the shortcode. As in the Cloud and Gallery example a Content Template is used to supply <code>a-bad-term</code> before the form is completed, which displays an empty gallery because it doesn't match anything. You can find more information on the <code>s=</code> parameter and other search parameters in the <a href="#search_keywords">Keyword(s) Search</a> section.
<p>
As in the Cloud and Gallery example, paginating your gallery display requires a slight modification of the <code>[mla_gallery]</code> shortcode (at the bottom of the next example) and adding a second <code>[mla_gallery]</code> shortcode (in the middle of the next example) to display the pagination controls:
<blockquote>
<code>&lt;form id="mla-search-form" action="." method="post"><br />
&lt;input id="mla-search-box" name="search-string" type="text" value="" />&amp;nbsp;&lt;input id="submit" name="submit" type="submit" value="Search" /><br />
&lt;/form></code><br />
&nbsp;<br />
<code>[mla_gallery s="{+template:({+request:search-string+}|a-bad-term)+}" posts_per_page=12 mla_output="paginate_links,prev_next" mla_link_href="{+page_url+}?search-string={+request:search-string+}"]</code><br />
&nbsp;<br />
<code>[mla_gallery s="{+template:({+request:search-string+}|a-bad-term)+}" mla_nolink_text="Enter a search value above to display gallery." posts_per_page=12]</code>
</blockquote>
</p>
<p>
The <code>posts_per_page=12</code> parameter has been added to the gallery display shortcode (the third shortcode). A new <code>[mla_gallery]</code> is added to display the pagination controls. The data selection parameter (<code>s="{+request:search-string+}</code>...) and <code>posts_per_page=12</code> parameter match the gallery display shortcode below it. The <code>mla_output</code> parameter displays the pagination controls. Finally, the <code>mla_link_href="{+page_url+}?search-string={+request:search-string+}"</code> parameter is added so the pagination controls pass the <code>search-string</code> from page to page.
<a name="mla_output_parameter"></a>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Support for Alternative Gallery Output, e.g., Pagination</h3>
<p>
The <code>[mla_gallery]</code> shortcode can be used to provide "Previous" and "Next" links that support moving among the individual items in a gallery or among gallery "pages". For example, if you have many items with a specific Att. Category or Att. Tag value you can build a single-image page with links to the previous/next item having that value. You can also build a page that shows a large gallery in groups, or "gallery pages", of ten items with links to the previous/next ten items or links to all of the gallery pages of items having that value. Finally, you can get a set of links to all pages in the gallery or links around the current page ( e.g.: &laquo; Previous 1 ... 3 4 5 6 7 ... 9 Next &raquo; ).
</p>
<h4>The <code>mla_output</code> parameter</h4>
<p>
The <strong>"mla_output"</strong> parameter determines the type of output the shortcode will return. Explanation and examples of each output type are given later in this section. You can choose from seven values:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">gallery</td>
<td>The default value; returns the traditional gallery of image thumbnails, captions, etc.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">next_link</td>
<td>returns a link to the next gallery item. The optional "<strong>,wrap</strong>" qualifier determines what happens at the end of the gallery. If you omit the qualifier, an empty string is returned for the "next_link" from the last item in the gallery. If you code the ",wrap" qualifier, the "next_link" from the last item will be to the first gallery item.</td>
</tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">current_link</td>
<td>returns a link to the current gallery item. This gives you an easy way to provide a visual indication of where you are within the overall gallery. The "span" and  "none" link formats are often used with this mla_output type.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">previous_link</td>
<td>returns a link to the previous gallery item. The optional "<strong>,wrap</strong>" qualifier determines what happens at the beginning of the gallery. If you omit the qualifier, an empty string is returned for the "previous_link" from the first gallery item. If you code the ",wrap" qualifier, "previous_link" from the first gallery item will be to the last gallery item.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">next_page</td>
<td>returns a link to the next "page" of gallery items. The optional "<strong>,wrap</strong>" or "<strong>,last</strong>" qualifiers determine what happens at the end of the gallery. If you omit the qualifier, an empty string is returned for the "next_page" if there are no more items in the gallery. If you code the ",wrap" qualifier, the "next_page" from the last page of items will be to the first page of gallery items. If you code the ",last" qualifier, the "next_page" link will return to/remain on the last page of gallery items.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">previous_page</td>
<td>returns a link to the previous "page" of gallery items. The optional "<strong>,wrap</strong>" or "<strong>,first</strong>" qualifiers determine what happens at the beginning of the gallery. If you omit the qualifier, an empty string is returned for the "previous_link" from the first page of gallery items. If you code the ",wrap" qualifier, "previous_page" from the first page of gallery items will be to the last page of gallery items. If you code the ",first" qualifier, the "previous_link" link will return to/remain on the first page of gallery items.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">paginate_links</td>
<td>returns a link to gallery items at the start and end of the list and to pages around the current "gallery page" ( e.g.: &laquo; Previous 1 ... 3 4 5 6 7 ... 9 Next &raquo; ). The optional "<strong>,show_all</strong>" qualifier will show all of the gallery pages instead of a short list around the current page. The optional "<strong>,prev_next</strong>" qualifier will include the "&laquo; Previous" and "Next &raquo;" portions of the link list.</td>
</tr>
</table>
<h4>Next and previous gallery items; the <code>next_link</code> and <code>previous_link</code> output types</h4>
<p>
WordPress provides functions that generate links to the "<em>next/previous image attached to the current post</em>." These are not useful when your Media Library items are not images or are not attached to a specific post or page.  If, for example, you use an <code>[mla_gallery]</code> shortcode to build a gallery of items with a specific Att. Tag value you can use the <code>next_link</code> and <code>previous_link</code> output types to move through single-item pages for the gallery. You will need one more parameter to specify the "current item" in the gallery:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">id</td>
<td>(optional) the ID of the "current" gallery item. If you omit this parameter, the default value is the ID of the current "post". The default value is only useful if you are enhancing the PHP code of the "image.php" template for the "Attachment Page" associated with a Media Library item.</td>
</tr>
</table>
<p>
The next or previous link returned is drawn from the attachment-specific "link" substitution parameter for the next or previous gallery item. This means you can use all of the <a href="#gallery_display_content">Gallery Display Content</a> parameters to control each element of the link. For example, you can code <code>mla_rollover_text='&amp;larr; Previous'</code> to replace the thumbnail image with a generic text link to the "previous_link" item. You can also add HTML arguments to the link to pass values along from one page to the next.
</p>
<p>
Expanding the example, you can select images using the MLA Att. Tag taxonomy and have each gallery item link to a page (<em><strong>page_id=893</strong></em> in this case) that displays a larger version of the single image:
</p>
<code>
[mla_gallery attachment_tag="sample" mla_caption="{+title+}" mla_link_href="{+site_url+}?page_id=893&amp;current_id={+attachment_ID+}&amp;attachment_tag={+query:attachment_tag+}"]
</code>
<p>
Note the use of <code>attachment_tag={+query:attachment_tag+}</code> in the href to pass the tag value from the gallery page to the single-image page. The single-image page would have three <code>[mla+gallery]</code> shortcodes; one to display the image and two for the "Previous Sample" and "Next Sample" links:
</p>
<code>
[mla_gallery columns=1 ids="{+request:current_id+}" size=medium]
<br />&nbsp;<br>
&lt;div style="clear: both; float: left"&gt;<br />
[mla_gallery mla_output="previous_link,wrap" mla_link_text='&amp;larr; Previous Sample' attachment_tag="{+request:attachment_tag+}" id="{+request:current_id+}" mla_caption="{+title+}" mla_link_href="{+site_url+}?page_id=893&amp;current_id={+attachment_ID+}&amp;attachment_tag={+query:attachment_tag+}"]<br>
&lt;/div&gt;<br>
&lt;div style="float: right"&gt;<br>
[mla_gallery mla_output="next_link,wrap" mla_link_text='Next Sample &amp;rarr;' attachment_tag="{+request:attachment_tag+}" id="{+request:current_id+}" mla_caption="{+title+}" mla_link_href="{+site_url+}?page_id=893&amp;current_id={+attachment_ID+}&amp;attachment_tag={+query:attachment_tag+}"]<br>
&lt;/div&gt;
</code>
<p>
Consider the following points:
</p>
<ol>
<li>The "ids" parameter in the first <code>[mla_gallery]</code> takes the "current_id" value (for the single image to be displayed) from the HTML $_REQUEST array. 
</li>
<li>The "id" parameters in the second and third <code>[mla_gallery]</code> take the "current_id" value from the HTML $_REQUEST array. In these "galleries" the "current_id" is the item from which "previous" and "next" are calculated.
</li>
<li>The "attachment_tag" parameters in the second and third <code>[mla_gallery]</code> take the their value from the HTML $_REQUEST array as well. The Att. Tag value is used to reconstruct the original gallery for the previous/next calculation.
</li>
</ol>
<p>
This example shows the power of the substitution parameters and in particular the "query" and "request" prefixes that can be used to pass information into an <code>[mla_gallery]</code> and from one page to the next. All of this without modifying PHP templates or requiring other code modifications!
</p>
<h4>Next and previous gallery pages; the <code>next_page</code> and <code>previous_page</code> output types</h4>
<p>
WordPress provides functions that generate links to the "<em>next/previous set of posts within the current query</em>." These are not useful because the "current query" is for posts/pages, <strong>not</strong> Media Library items. What's needed is a way to paginate an <code>[mla_gallery]</code> shortcode on a single post or page. If, for example, you use an <code>[mla_gallery]</code> shortcode to build a gallery of items with a specific Att. Tag value you can use the <code>next_page</code> and <code>previous_page</code> output types to move through the gallery in groups of, say, ten items per "gallery page". Here is a very simple example of MLA pagination:
</p>
<p>
<code>[mla_gallery post_parent=all posts_per_page=6]<br />
[mla_gallery post_parent=all posts_per_page=6 mla_output=paginate_links]</code>
</p>
<p>
The first shortcode displays the gallery. The data selection parameter is post_parent=all, which will select all of the images in your Media Library. The posts_per_page=6 parameter will divide the gallery into pages of six images each. In the second shortcode, mla_output=paginate_links tells the shortcode to display pagination controls instead of the gallery images.
</p>
<p>
WordPress uses the "paged" parameter to indicate the current "<em>set of posts within the current query</em>." To avoid built-in WordPress logic that uses this parameter, MLA has its own "mla_paginate_current" parameter to indicate the current set of items within the gallery (the current gallery page). MLA will automatically manage this parameter for you, but you can also use it explicitly to handle special cases.
</p>
<h4>Page selection parameters for <code>next_page</code> and <code>previous_page</code> output types</h4>
<p>
Use the following parameters to specify the size of each gallery page and the current gallery page:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">posts_per_page</td>
<td>sets the number of gallery items on each gallery "page" </td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">numberposts</td>
<td>synonym for "posts_per_page" </td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_paginate_current</td>
<td>the "current" gallery page; defaults to one (1) if not specified. MLA will usually manage this for you, adding it to the hyperlinks for the previous and next gallery pages. MLA will look for this parameter in the HTML $_REQUEST array if it is not coded in the gallery shortcode.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_page_parameter</td>
<td>the name of the parameter containing the current page number; default "mla_paginate_current". You can change the name if you need multiple paginated galleries on one post/page. If you use this parameter, make sure you add it to the gallery shortcode and all pagination shortcodes for that gallery, and use the same unique value in all shortcodes for the specific gallery.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_paginate_total</td>
<td>the highest page number you want to display; defaults to (total items / posts_per_page) if not specified, which is usually what you want. </td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_paginate_rows</td>
<td>If you have some other way of computing the total number of items you want to paginate you can use <code>mla_paginate_rows</code> to simplify your shortcode parameters and avoid redundant database access. If, for example, you want pagination controls for a gallery that you know has fifty items you can code <code>[mla_gallery mla_output=paginate_links mla_paginate_rows=50]</code> and then add any other page selection or gallery display content parameters you need.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">offset, paged</td>
<td><strong>DO NOT USE THESE PARAMETERS; THEY WILL BREAK MLA PAGINATION</strong></td>
</tr>
</table>
<p>For most applications, "posts_per_page" is the only pagination parameter you need to specify. Make sure this parameter is the same for your main gallery shortcode and for the pagination shortcodes that go with it. Also, make sure you use exactly the same item selection and sorting parameters in both shortcodes.
</p>
<h4>Gallery Display Content parameters for <code>next_page</code> and <code>previous_page</code> output types</h4>
<p>
The next or previous link returned can use the following Gallery Display Content parameters to control each element of the link:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_link_attributes</td>
<td>adds one or more HTML attributes to the hyperlink </td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_link_class</td>
<td><strong>adds</strong> one or more classes to those already defined for the hyperlink </td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_link_href</td>
<td>replaces the HTML &quot;href&quot; attribute in the hyperlink </td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_link_text</td>
<td>replaces the link text </td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_prev_text</td>
<td>the "previous page" text (default "&laquo; Previous"); an alternative to "mla_link_text" for <code>mla_output=previous_page</code></td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_next_text</td>
<td>the "next page" text (default "Next &raquo;") an alternative to "mla_link_text" for <code>mla_output=next_page</code></td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_nolink_text</td>
<td>replaces the empty string displayed when there is no link and link text, e.g., no previous or next page link </td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_rollover_text</td>
<td>replaces the HTML &quot;title&quot; attribute in the hyperlink. This is the text displayed when the mouse rolls or hovers over the link text </td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_target</td>
<td>adds an HTML &quot;target&quot; attribute to the hyperlink </td>
</tr>
</table>
<h4>Markup Substitution Parameters for <code>next_page</code> and <code>previous_page</code> output types</h4>
<p>You can use any of the <a href="#mla_markup_parameters"><strong>Substitution parameters for markup templates</strong></a> in your next/previous page links (since the links are at the "gallery page" level, the attachment-specific substitution parameters are not available). The following additional substitution parameters are available for the <code>next_page</code> and <code>previous_page</code> output types:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">current_page</td>
<td>the number of the current page</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">new_page</td>
<td>the number of the new (previous or next) page; zero for paginate_links</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">last_page</td>
<td>the number of the last/highest/maximum page</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">posts_per_page</td>
<td>the number of items on each gallery page</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">found_rows</td>
<td>the number of items in the gallery</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">current_offset</td>
<td>the number of items skipped before the current page</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">new_offset</td>
<td>the number of items skipped before the new page</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">current_page_text</td>
<td>'mla_paginate_current="[+current_page+]"'</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">new_page_text</td>
<td>'mla_paginate_current="[+new_page+]"'</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">last_page_text</td>
<td>'mla_paginate_total="[+last_page+]"'</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">posts_per_page_text</td>
<td>'posts_per_page="[+posts_per_page+]"'</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">scheme</td>
<td>the HTTP protocol used to access the page; usually "http://" but might be "https://"</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">http_host</td>
<td>contents of the <em>Host:</em> header of the current request; usually a domain name such as "mysite.com" or an IP address</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">request_uri</td>
<td>the URI given to access the page, e.g., "wordpress/2013/06/sample-post" or "wordpress/tag-gallery-page?attachment_tag=sample". MLA manages pagination by adding the "mla_paginate_current" query parameter to the URI value</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">new_url</td>
<td>concatenation of scheme + http_host + request_uri</td>
</tr>
</table>
<h4>An example of the <code>next_page</code> and <code>previous_page</code> output types</h4>
<p>
Expanding the "attachment tag gallery" example, you can select images using the MLA Att. Tag taxonomy and divide the  gallery into fixed-size pages. Following the main gallery shortcode are the previous/next page links:
</p>
<code>
[mla_gallery attachment_tag="sample" posts_per_page=10 mla_caption="{+title+}"]
<br>&nbsp;<br>
&lt;div style="clear: both; float: left"&gt;<br />
[mla_gallery attachment_tag="sample" posts_per_page=10 mla_output="previous_page,first" mla_link_text='&amp;larr; Previous Gallery Page' mla_rollover_text="Previous or first page for this tag"]<br>
&lt;/div&gt;<br>
&lt;div style="float: right"&gt;<br>
[mla_gallery attachment_tag="sample" posts_per_page=10 mla_output="next_page,last" mla_link_text='&amp;larr; Next Gallery Page' mla_rollover_text="Next or last page for this tag"]<br>
&lt;/div&gt;
</code>
<p>
This example is simpler that the earlier single-item paging example because the "current page" handling is done by MLA, and the "sample" tag value is hard-coded. You could also develop a generic "Att. Tag" gallery page and pass the tag value in the URI for that page (as in the single-item pagination example earlier in this section).
</p>
<h4>Generalized paginated link list; the <code>paginate_links</code> output type</h4>
<p>
WordPress provides a function that "<em>can be used to create paginated link list for any area</em>." The "paginate_links" output type is modeled on this function and lets you generate a list of links for moving among "gallery pages".
</p>
<p>
The <strong>Page Selection Parameters</strong>, <strong>Gallery Display Content Parameters</strong> and <strong>Markup Substitution Parameters</strong> defined above also apply to the "paginate_links" output type. There are five additional parameters unique to this output type.
</p>
<h4>Specific parameters for the <code>paginate_links</code> output type</h4>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_end_size</td>
<td>How many numbers (default 1) appear on either the start and the end list edges</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_mid_size</td>
<td>How many numbers (default 2) appear to either side of current page, but not including current page</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_prev_text</td>
<td>the "previous page" text (default "&laquo; Previous") , which appears when the ",prev_next" qualifier is added to the output_type</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_next_text</td>
<td>the "next page" text (default "Next &raquo;") , which appears when the ",prev_next" qualifier is added to the output_type</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_paginate_type</td>
<td>the format of the return value. "<strong>plain</strong>" (the default) returns a string with links separated by the newline character. "<strong>list</strong>" returns an unordered (ul) HTML list.</td>
</tr>
</table>
<p>If you code the "<strong>,show_all</strong>" qualifier, most of the above parameters have no effect; the "mla_paginate_type" parameter is the exception.
</p>
<h4>An example of the <code>paginate_links</code> output type</h4>
<p>
Expanding the "attachment tag gallery" example, you can select images using the MLA Att. Tag taxonomy and divide the  gallery into fixed-size pages. Following the main gallery shortcode is the list of page links:
</p>
<code>
[mla_gallery attachment_tag="sample" posts_per_page=10 mla_caption="{+title+}"]
<br>&nbsp;<br>
[mla_gallery attachment_tag="sample" posts_per_page=10 mla_output="paginate_links,prev_next" mla_nolink_text='No Gallery Pages']<br>
</code>
<p>
This example is even simpler that the two earlier examples because there's just one additional <code>[mla_gallery]</code> shortcode for pagination links.
</p>
<a name="alt_shortcode"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Support for Other Gallery-generating Shortcodes</h3>
<p>
The <code>[mla_gallery]</code> shortcode can be used in combination with other gallery-generating shortcodes to give you the data selection power of <code>[mla_gallery]</code> and the formatting/display power of popular alternatives such as the WordPress.com Jetpack Carousel and Tiled Galleries modules. Any shortcode that accepts "ids=" or a similar parameter listing the attachment ID values for the gallery can be used. Two parameters implement this feature:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_alt_shortcode</td>
<td>the name of the shortcode to be called for gallery format and display</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_alt_ids_name</td>
<td>(optional, default "ids") the name of the parameter used to pass a list of attachment ID values to the alternate shortcode</td>
</tr>
</table>
<p>
For example, if you want to select images using the MLA Att. Category taxonomy but want to display a "Tiled Mosaic" gallery, you can code:
</p>
<code>
[mla_gallery attachment_category=vegetable tax_operator="NOT IN" mla_alt_shortcode=gallery type="rectangular" mla_alt_ids_name=include]
</code>
<p>
This example selects all the images that are "NOT IN" the Att. Category "vegetable". The selected images are passed to the <code>[gallery]</code> shortcode in an "include" parameter, along with the "type=rectangular" parameter. The result is as if you had coded:
</p>
<code>
[gallery include="1,2,3" type="rectangular"]
</code>
<p>
In the above example, the <code>mla_alt_ids_name=include</code> parameter isn't really necessary, since the <code>[gallery]</code> shortcode accepts the "ids" parameter. It was included in the example just to show how the "mla_alt_ids_name" might be used for some other shortcode that requires a different name for the parameter.
</p>
<p>
You can pass any parameters you need through the <code>[mla_gallery]</code> shortcode and on to the alternate shortcode you're using. Here's another example, using the Photonic Gallery plugin:
</p>
<code>
[mla_gallery attachment_tag=fauna orderby=rand mla_alt_shortcode=gallery type=default style=strip-below slideshow_height=320 slide_size=medium]
</code>
<p>
Here, <code>[mla_gallery]</code> selects the images with an Att. Tag of "fauna" and sorts them in a random order. It then calls on the <code>[gallery]</code> shortcode (which Photonic also uses), as if you had coded:
</p>
<code>
[gallery ids="3,1,4,2,7" type=default style=strip-below slideshow_height=320 slide_size=medium]
</code>
<p>
Photonic recognizes the <code>type=default</code> parameter and takes over, using the other three parameters to format its results. This example is a less convenient but more flexible alternative to the native Photonic support built-in to <code>[mla_gallery]</code> (see next section).
</p>
<p>
You can also use the "enclosing shortcode" form if the alternate shortcode, such as Fullscreen Galleria's "fsg_link", requires it. You would code this form as:
</p>
<code>
[mla_gallery ids="1,2,3" mla_alt_shortcode=fsg_link mla_alt_ids_name=include class=button]View the gallery[/mla_gallery]
</code>
<p>If you mix the self-closing and enclosing versions of <code>[mla_gallery]</code> on one post/page you must use the "xhtml-style closing shortcodes like [mla_gallery /]" for the self-closing shortcodes.
</p>
<p>
<strong>NOTE:</strong> When you use "mla_alt_shortcode" to pass format/display responsibility off to another shortcode you will lose the <code>[mla_gallery]</code> Gallery Display Style (e.g. "mla_float") and Gallery Display Content (e.g. "mla_caption") parameters. There is no reliable way for <code>[mla_gallery]</code> to pass this information on to the other shortcode you've specified.
</p>
<p>
<a name="photonic_gallery"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Support for &#8220;Photonic Gallery for Flickr, Picasa, SmugMug, 500px and Instagram&#8221;</h3>
<p>
The <a href="http://wordpress.org/extend/plugins/photonic/" title="Photonic Gallery plugin directory page" target="_blank">Photonic Gallery for Flickr, Picasa, SmugMug, 500px and Instagram</a> plugin adds several new parameters to the <code>[mla_gallery]</code> shortcode to enhance your galleries. All you have to do is install the plugin, then add a "style=" parameter to your <code>[mla_gallery]</code> shortcode to use the Photonic styling and markup in place of the native <code>[mla_gallery]</code> style and markup templates.
</p>
<p>
You can use the "Photonic" screen of the Insert Media dialog to build the display portion of your shortcode parameters. After you click "Insert into post", change the shortcode name from "gallery" to "mla_gallery" and add the query parameters you need to select the attachments for the gallery. The <code>[mla_gallery]</code> code will compile the list of attachments for your gallery, then hand control over to Photonic to format the results.
<a name="mla_gallery_templates"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Style and Markup Templates</h3>
<p>
The Style and Markup templates give you great flexibility for the content and format of each <code>[mla_gallery]</code> or <code>[mla_tag_cloud]</code> (list and grid formats). You can define as many templates as you need.
</p>
<p>
Style templates provide gallery-specific (or cloud-specific) CSS inline styles (you can code <code>mla_style=none</code> to suppress the addition of CSS inline styles entirely). Markup templates provide the HTML markup for 1) the beginning of the gallery, 2) the beginning of each row, 3) each gallery item, 4) the end of each row and 5) the end of the gallery. The attachment-specific markup parameters let you choose among most of the attachment fields, not just the caption.
</p>
<p>
The MLA Gallery tab on the Settings page lets you add, change and delete custom templates. The default templates are also displayed on this tab for easy reference.
</p>
<p>
In a template, substitution parameters are surrounded by opening ('[+') and closing ('+]') delimiters to separate them from the template text; see the default templates for many examples.
<a name="gallery_specific"></a>
</p>
<h4>Gallery-specific Substitution Parameters</h4>
<p>
Gallery-specific substitution parameters are known at the beginning of shortcode processing and they do not change during processing. They can be used, for example, in any of the data selection parameters to change the items selected for the gallery based on information about the post/page on which the gallery appears. The gallery-specific substitution parameters are:
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">site_url</td>
<td>absolute URL to the site directory, without trailing slash</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">base_url</td>
<td>absolute URL to the upload directory, without trailing slash</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">base_dir</td>
<td>absolute (full) path to the upload directory, without trailing slash</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">instance</td>
<td>starts at '1', incremented for each additional shortcode in the post/page</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">selector</td>
<td>"mla_gallery-{$instance}", e.g., mla_gallery-1</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_ID,<br />id</td>
<td style="vertical-align: top">the <code>ID</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_author</td>
<td>the <code>post_author</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_date</td>
<td>the <code>post_date</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_content</td>
<td>the <code>post_content</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_title</td>
<td>the <code>post_title</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_excerpt</td>
<td>the <code>post_excerpt</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_status</td>
<td>the <code>post_status</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_name</td>
<td>the <code>post_name</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_modified</td>
<td>the <code>post_modified</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_guid</td>
<td>the <code>post_guid</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_type</td>
<td>the <code>post_type</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">page_url</td>
<td>absolute URL to the page or post on which the gallery appears, if any, with trailing slash</td>
</tr>
</table>
<a name="mla_style_parameters"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Substitution parameters for style templates</h4>
All of the <a href="#gallery_specific">gallery-specific substitution parameters</a> are available for use in style templates. These additional substitution parameters are also available:
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_style</td>
<td>shortcode parameter, default = 'default'</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_markup</td>
<td>shortcode parameter, default = 'default'</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">itemtag</td>
<td>shortcode parameter, default = 'dl', or 'figure' for HTML5 themes</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">icontag</td>
<td>shortcode parameter, default = 'dt', or 'div' for HTML5 themes</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">captiontag</td>
<td>shortcode parameter, default = 'dd', or 'figcaption' for HTML5 themes</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">columns</td>
<td>shortcode parameter, default = '3'</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">itemwidth</td>
<td>shortcode parameter, default is calculated by dividing 100% by the number of columns and subtracting twice the margin value, e.g., 30.3% for three columns and a margin value of 1.5%. Can also contain other dimensional values such as '10px' or CSS-specific values like 'auto' or 'inherit'.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">margin</td>
<td>shortcode parameter, default = '1.5%'. Can also contain other dimensional values such as '10px' or CSS-specific values like 'auto' or 'inherit'.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">float</td>
<td>'right' if current locale is RTL, 'left' if not</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">size_class</td>
<td>shortcode 'size' parameter, default = 'thumbnail'</td>
</tr>
</table>
<a name="mla_markup_parameters"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Substitution parameters for markup templates</h4>
<p>
All of the <a href="#gallery_specific">gallery-specific substitution parameters</a> and the  <a href="#mla_style_parameters">Substitution parameters for style templates</a> are available for use in markup templates. There are no additional substitution parameters defined at the start of markup processing, but there are <a href="#mla_gallery_hooks">MLA Gallery Filters (Hooks)</a> that could add, modify or delete parameters available for markup processing, if your application uses them.
<a name="mla_attachment_parameters"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Attachment-specific substitution parameters for the markup template Item part</h4>
<p>
These substitution parameters are only available in the "Item" part of the markup template, since they require an attachment for their data source. In addition to the parameters in the list below, you can use any of the <a href="#field_level_data_sources">Data sources for custom field mapping</a> (except "None", "Metadata" and "Template").
</p>
<p>
You may need to append one of the <a href="#field_level_formats">format options</a> to the name depending on the context in which the substitution parameter is used. If you need both the native format and the altered format, simply wrap the altered format in a content template, e.g., <code>[+template:([+width,commas+])+]</code>. The template will prevent the native value from being over-written with the formatted value.
</p>
<p>
The item-level substitution parameter names are:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">index</td>
<td>starts at '1', incremented for each attachment in the gallery</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">last_in_row</td>
<td>set to "last_in_row" for the last item in each full gallery row, and to an empty string for all other items in the row. If the gallery ends with a partial row, the last_in_row parameter is not set.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">caption</td>
<td>if captiontag is not empty, contains caption/post_excerpt</td>
</tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">excerpt</td>
<td>always contains post_excerpt</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">attachment_ID</td>
<td>attachment post ID</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mime_type</td>
<td>attachment post_mime_type</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">menu_order</td>
<td>attachment menu_order</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">date</td>
<td>attachment post_date</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">modified</td>
<td>attachment post_modified</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">parent</td>
<td>attachment post_parent (ID)</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">parent_title</td>
<td>post_title of the parent, or '(unattached)'</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">parent_type</td>
<td>'post', 'page' or custom post type of the parent</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">parent_date</td>
<td>upload date of the parent</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">title</td>
<td>attachment post_title</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">slug</td>
<td>attachment post_name</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">width</td>
<td>width in pixels, for image types</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">height</td>
<td>height in pixels, for image types</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">orientation</td>
<td>"portrait" (height > width) or "landscape", for image types; empty for non-image types</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">image_meta</td>
<td>image metadata, for image types</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">image_alt</td>
<td>ALT text, for image types. If there are multiple values (unlikely) only the first value is available. If you need to process multiple values, use the field-level data source "alt_text".</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">base_file</td>
<td>path and file name relative to uploads directory</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">path</td>
<td>path portion of base_file</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">file</td>
<td>file name portion of base_file</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">description</td>
<td>attachment post_content</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">file_url</td>
<td>attachment guid</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">author_id</td>
<td>attachment post_author</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">author</td>
<td>author display_name, or 'unknown'</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">link</td>
<td>hyperlink to the attachment page (default) or file (shortcode 'link' parameter = "file")</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">pagelink</td>
<td>always contains a hyperlink to the attachment page</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">filelink</td>
<td>always contains a hyperlink to the attachment file</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">link_url</td>
<td>the URL portion of <em>link</em></td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">pagelink_url</td>
<td>the URL portion of <em>pagelink</em></td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">filelink_url</td>
<td>the URL portion of <em>filelink</em></td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">thumbnail_content</td>
<td>complete content of the gallery item link. This will either be an "&lt;img ... &gt;" tag<br />or a text string for non-image items</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">thumbnail_width</td>
<td>for image/icon items, width of the gallery image/icon</td>
</tr>
<tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">thumbnail_height</td>
<td>for image/icon items, height of the gallery image/icon</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">thumbnail_url</td>
<td>for image/icon items, URL of the gallery image/icon</td>
</tr>
</table>
<h4>Field-level substitution parameters for the markup template Item part</h4>
<p>
You can use the <a href="#mla_variable_parameters"><strong>field-level substitution parameters</strong></a> in the item part to draw data from a wide variety of sources and format it as required. See that section of the Documentation for more information.
<a name="mla_table_example"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>A Table-based Style and Markup Template Example</h3>
<p>
Here's a small example that shows a gallery using <code>&lt;table&gt;</code> markup.
The Item markup section shows how to use the "terms", "custom", "iptc" and "exif" substitution parameters.
</p>
<h4>Style Template</h4>
<code>
&lt;style type='text/css'&gt;<br />
&nbsp;&nbsp;#[+selector+] {<br />
&nbsp;&nbsp;&nbsp;&nbsp;margin: auto;<br />
&nbsp;&nbsp;}<br />
&nbsp;&nbsp;#[+selector+] .gallery-row {<br />
&nbsp;&nbsp;&nbsp;&nbsp;float: [+float+];<br />
&nbsp;&nbsp;&nbsp;&nbsp;margin-top: 10px;<br />
&nbsp;&nbsp;&nbsp;&nbsp;border-top: 1px solid #ddd;<br />
&nbsp;&nbsp;&nbsp;&nbsp;text-align: center;<br />
&nbsp;&nbsp;&nbsp;&nbsp;width: [+itemwidth+]%;<br />
&nbsp;&nbsp;}<br />
&nbsp;&nbsp;#[+selector+] .gallery-row td.gallery-icon {<br />
&nbsp;&nbsp;&nbsp;&nbsp;width: 60;<br />
&nbsp;&nbsp;&nbsp;&nbsp;height: 60;<br />
&nbsp;&nbsp;&nbsp;&nbsp;vertical-align: top;<br />
&nbsp;&nbsp;}<br />
&nbsp;&nbsp;#[+selector+] .gallery-row .gallery-icon img {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: 2px solid #cfcfcf;<br />
&nbsp;&nbsp;}<br />
&nbsp;&nbsp;#[+selector+] .gallery-caption {<br />
&nbsp;&nbsp;&nbsp;&nbsp;margin-left: 0;<br />
&nbsp;&nbsp;&nbsp;&nbsp;vertical-align: top;<br />
&nbsp;&nbsp;}<br />
&lt;/style&gt;
</code>
<h4>Markup Template</h4>
<table width="700" border="0" cellpadding="5">
	<tr>
		<td style="vertical-align: top; font-weight:bold">Open</td>
		<td><code>&lt;table id='[+selector+]' class='gallery galleryid-[+id+]<br />gallery-columns-[+columns+] gallery-size-[+size_class+]'&gt;</code></td>
	</tr>
	<tr>
		<td style="vertical-align: top; font-weight:bold">Row Open</td>
		<td><code>&lt;tr class='gallery-row'&gt;</code></td>
	</tr>
	<tr>
		<td style="vertical-align: top; font-weight:bold">Item</td>
		<td><code>&lt;td class='gallery-icon'&gt;<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+link+]<br />
	&lt;/td&gt;<br />
	&lt;td class='wp-caption-text gallery-caption'&gt;<br />
		&nbsp;&nbsp;&nbsp;&nbsp;&lt;strong&gt;[+title+]&lt;/strong&gt;&lt;br /&gt;<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+description+]&lt;br /&gt;<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+date+]<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+custom:client,single+]<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+terms:category+]<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+iptc:caption-or-abstract+]<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+iptc:2#025,single+]<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+exif:Artist+]
	&lt;/td&gt;</code>
</td>
	</tr>
	<tr>
		<td style="vertical-align: top; font-weight:bold">Row Close</td>
		<td><code>&lt;/tr&gt;</code></td>
	</tr>
	<tr>
		<td style="vertical-align: top; font-weight:bold">Close</td>
		<td><code>&lt;/table&gt;</code></td>
	</tr>
</table>
<a name="mla_variable_parameters"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Field-level Substitution Parameters</h3>
<p>
Field-level substitution parameters let you access query arguments, custom fields, taxonomy terms and attachment metadata for display in an MLA gallery or in an MLA tag cloud. You can also use them in IPTC/EXIF or Custom Field mapping rules. For field-level parameters, the value you code within the surrounding the ('[+' and '+]' or '{+' and '+}') delimiters has three parts; the prefix, the field name (or template content) and, if desired, an option/format value.
</p>
<p>
The <strong>prefix</strong> defines which type of field-level data you are accessing. It must immediately follow the opening ('[+' or '{+') delimiter and end with a colon (':'). There can be no spaces in this part of the parameter.
</p>
<p>
The <strong>field name</strong> defines which field-level data element you are accessing. It must immediately follow the colon (':'). There can be no spaces between the colon and the field name. Spaces are allowed within the field name to accommodate custom field names that contain them. <strong>Compound names</strong> are used to access elements within arrays, e.g., &quot;<strong>sizes.thumbnail.file</strong>&quot; is used to specify the file name for the thumbnail version of an image. For the "template" prefix, the field name is replaced by the template content; see the <a href="#mla_template_parameters">Content Templates</a> section for details.
</p>
<p>
The <strong>option/format value</strong>, if present, immediately follows the field name using a comma (,) separator and ends with the closing delimiter ('+]' or '+}'). There can be no spaces in this part of the parameter.
<a name="field_level_prefixes"></a>
</p>
<h4>Prefix values</h4>
<p>
There are ten prefix values for field-level parameters. Prefix values must be coded as shown; all lowercase letters.
</p>
<table>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">request</td>
		<td>The parameters defined in the <code>$_REQUEST</code> array; the "query strings" sent from the browser. The PHP $_REQUEST variable is a superglobal Array that contains the contents of both $_GET, $_POST, and $_COOKIE arrays. It can be used to collect data sent with both the GET and POST methods. For example, if the URL is <code>http://www.mysite.com/mypage?myarg=myvalue</code> you can access the query string as <code>[+request:myarg+]</code>, which has the value "myvalue".</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">query</td>
		<td>The parameters defined in the <code>[mla_gallery]</code> shortcode. For example, if your shortcode is <code>[mla_gallery attachment_tag=my-tag div-class=some_class]</code> you can access the parameters as <code>[+query:attachment_tag+]</code> and <code>[+query:div-class+]</code> respectively. Only the parameters actually present in the shortcode are accessible; default values for parameters not actually present are not available. You can define your own parameters, e.g., "div-class"; they will be accessible as field-level data but will otherwise be ignored.</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">custom</td>
		<td>WordPress Custom Fields, which you can define and populate on the Edit Media screen or map from various sources on the Settings/Media Library Assistant Custom and IPTC/EXIF tabs. The field name, or key, can contain spaces and some punctuation characters. You <strong><em>cannot use the plus sign ('+')</em></strong> in a field name you want to use with <code>[mla_gallery]</code>. Custom field names are case-sensitive; "client" and "Client" are not the same.
		<br />&nbsp;<br />
		For custom fields only, the <strong>",raw" option</strong> bypasses the code to sanitize the returned value. Use this option to allow HTML tags to be returned from a custom field.
		<br />&nbsp;<br />
		One special custom "pseudo-value" is available; <strong>ALL_CUSTOM</strong> (<code>[+custom:ALL_CUSTOM+]</code>). This returns a string representation of all custom field values. You can use this pseudo-values to quickly examine which fields are populated for a given Media Library item and what its values are.
		<br />&nbsp;<br />
		The ALL_CUSTOM value is altered in two ways. First, values of more than 256 characters are truncated to 256 characters. This prevents large fields from dominating the display. Second, array values are shown '(ARRAY)'.</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">terms</td>
		<td>WordPress Category, tag or custom taxonomy terms. For this category, you code the name of the taxonomy as the field name. The term(s) associated with the attachment will be displayed in the <code>[mla_gallery]</code>. Note that you must use the name/slug string for taxonomy, not the "title" string. For example, use "attachment_category" or "attachment_tag", not "Att. Category" or "Attachment Category".</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">meta</td>
		<td>WordPress attachment metadata, if any, embedded in the image/audio/video file. For this category, you can code any of the field names embedded in the _wp_attachment_metadata array. The "Attachment Metadata" display in the Media/Edit Media screen will show you the names and values of these fields. Note that the fields available differ among image, audio and video attachments.<br />
		&nbsp;<br />
		The "image_meta" portion of the attachment metadata is of particular interest. This array contains some "extended image metadata" drawn from IPTC and EXIF fields by WordPress and improved a bit. You can find more information in the Codex <a href="http://codex.wordpress.org/Function_Reference/wp_read_image_metadata" title="Codex information for image_meta" target="_blank">Function Reference/wp read image metadata</a>. For example, to get the ISO speed rating for an image, code <code>[+meta:image_meta.iso+]</code>.</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">pdf</td>
		<td>
		The Document Information Dictionary (D.I.D.)and XMP metadata, if any, embedded in a PDF file. For this category, you can code any of the nine D.I.D. entries (Title, Author, Subject, Keywords, Creator, Producer, CreationDate, ModDate, Trapped). For many documents there is also a rich collection of additional metadata stored in XMP Metadata Streams; see the <a href="#pdf_metadata">Metadata in PDF documents</a> section below for details on accessing PDF metadata.<br />
		&nbsp;<br />
		You can find more PDF information at the <a href="http://www.adobe.com/devnet/pdf.html" title="Adobe PDF Technology Center" target="_blank">Adobe PDF Technology Center</a>.<br />&nbsp;</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">iptc</td>
		<td>
		The IPTC (International Press Telecommunications Council) metadata, if any, embedded in the image file. For this category, you can code any of the IPTC DataSet tag and field identifiers, e.g., "2#025" for the Keywords field. You can also use the "friendly name" MLA defines for most of the IPTC fields; see the <a href="#mla_iptc_identifiers">table of identifiers and friendly names</a> below.<br />
		&nbsp;<br />
		You can find more IPTC information in the <a href="http://www.iptc.org/std/IIM/4.1/specification/IIMV4.1.pdf" title="IPTC-NAA Information Interchange Model Version No. 4.1 specification (PDF)" target="_blank">IPTC-NAA Information Interchange Model Version No. 4.1 specification (PDF document)</a>.
		<br />&nbsp;<br />
		A special iptc "pseudo-value" is available; <strong>ALL_IPTC</strong> (<code>[+iptc:ALL_IPTC+]</code>). It returns a string representation of all IPTC data. You can use the pseudo-value to examine the metadata in an image, find field names and see what values are embedded in the image.
		<br />&nbsp;<br />
		The ALL_IPTC value is altered in two ways. First, values of more than 256 characters are truncated to 256 characters. This prevents large fields such as keyword arrays from dominating the display. Second, array values are shown once, at their expanded level.<br />&nbsp;
		</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">exif</td>
		<td>
		The EXIF (EXchangeable Image File) metadata, if any, embedded in a JPEG DCT or TIFF Rev 6.0 image file. 
		Though the specification is not currently maintained by any industry or standards organization, almost all camera manufacturers use it. It is also supported by many image editing programs such as Adobe PhotoShop.
		For this category, you can code any of the field names embedded in the image by the camera or editing software. There is no official list of standard field names, so you just have to know the names your camera and software use; field names are case-sensitive.
		<br />&nbsp;<br />
		You can find more information in the <a href="http://en.wikipedia.org/wiki/Exchangeable_image_file_format" title="Exchangeable image file format Wikipedia article" target="_blank">Exchangeable image file format</a> article on Wikipedia. You can find External Links to EXIF standards and tag listings at the end of the Wikipedia article.
		<br />&nbsp;<br />
		MLA uses a standard PHP function, <a href="http://php.net/manual/en/function.exif-read-data.php" title="PHP Manual page for exif_read_data" target="_blank">exif_read_data</a>, to extract EXIF data from images. The function returns three arrays in addition to the raw EXIF data; COMPUTED, THUMBNAIL and COMMENT. You can access the array elements by prefacing the element you want with the array name. For example, the user comment text is available as "COMPUTED.UserComment" and "COMPUTED.UserCommentEncoding". You can also get "COMPUTED.Copyright" and its two parts (if present), "COMPUTED.Copyright.Photographer" and "COMPUTED.Copyright.Editor". The THUMBNAIL and COMMENT arrays work in a similar fashion.
		<br />&nbsp;<br />
		A special exif "pseudo-value" is available; <strong>ALL_EXIF</strong> (<code>[+exif:ALL_EXIF+]</code>). It returns a string representation of all EXIF data. You can use the pseudo-value to examine the metadata in an image, find field names and see what values are embedded in the image.
		<br />&nbsp;<br />
		The ALL_EXIF value is altered in two ways. First, values of more than 256 characters are truncated to 256 characters. This prevents large fields such as image thumbnails from dominating the display. Second, array values are shown once, at their expanded level. For example the "COMPUTED" array is displayed as 'COMPUTED' => '(ARRAY)' and then 'COMPUTED.Width' => "2816", etc.<br />&nbsp;</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">xmp</td>
		<td>
Data defined by the <a href="https://www.adobe.com/products/xmp/" title="Adobe XMP site" target="_blank">Extensible Metadata Platform (XMP)</a> framework, if present. XMP metadata varies from image to image but is often extensive. MLA provides access to this data in three ways:
<ol>
<li>
MLA will copy appropriate values from the XMP data into the nine "<a href="#pdf_metadata">PDF Document Information Dictionary</a>" fields to populate them as often as possible. For example, the "creator" value(s) in the "dc" namespace ("dc.creator") might be copied to an empty "Author" field, or the "dc.subject" value(s) might be copied to an empty Keywords field.
</li>
<li>
Additional values in the "xmp", "xmpMM", "xmpRights", "xap", "xapMM" and "dc" namespaces are copied up to the root level for easier access. For example, the "xmp.ModifyDate" value can be accessed as "ModifyDate", without the "xmp." portion of the compound name.
</li>
<li>
Other namespaces in the document are copied to arrays at the root level. For example, some documents contain information in the "photoshop" namespace, such as "photoshop.CaptionWriter" and "photoshop.AuthorsPosition". The native values of some fields, e.g., "dc.creator", can be an array.
</li>
</ol>
MLA adds three fields of its own to the XMP metadata information:
<br />&nbsp;<br />
<table>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">xmptk</td>
		<td>the XMP software used to create the metadata</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">xmlns</td>
		<td>an array of the namespaces found in the document, such as <code>'dc' => 'http://purl.org/dc/elements/1.1/'</code></td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">ALL_XMP</td>
		<td>a special "pseudo value" that returns a string representation of all the metadata. You can use this pseudo-value to examine the metadata in a document, find field names and see what values are present.</td>
	</tr>
</table>
		The ALL_XMP value is altered in two ways. First, values of more than 256 characters are truncated to 256 characters. This prevents large fields such as image thumbnails from dominating the display. Second, array values are shown once, at their expanded level. For example the "dc" array is displayed as 'dc' => '(ARRAY)' and then 'dc.creator' => "Author's name", etc.
		<br />&nbsp;</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">template</td>
		<td>A Content Template, which lets you compose a value from multiple substitution parameters and test for empty values, choosing among two or more alternatives or suppressing output entirely. See the <a href="#mla_template_parameters">Content Templates</a> section for details. Note that the formatting option is not supported for templates.</td>
	</tr>
</table>
<a name="field_level_formats"></a>
&nbsp;<br />
<h4>Field-level option/format values</h4>
<p>
You can use a field-level option or format value to specify the treatment of fields with multiple values or to change the format of a field for display/mapping purposes. If no option/format value is present, fields with multiple values are formatted as a comma-delimited text list. The option/format value, if present, immediately follows the field name using a comma (,) separator and ends with the closing delimiter ('+]' or '+}'). There can be no spaces in this part of the parameter.
</p>
<p>
Two "option" values change the treatment of fields with multiple values:
</p>
<table>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">,single</td>
		<td>If this option is present, only the first value of the field will be returned. Use this option to limit the data returned for a custom field, taxonomy or metadata field that can have many values. For example, if you code <code>[+meta:sizes.thumbnail,single+]</code> the result will be "20120313-ASK_5605-150x150.jpg".
		</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">,export</td>
		<td>If this option is present, the PHP <code>var_export</code> function is used to return a string representation of all the elements in an array field. For example, if you code <code>[+meta:sizes.thumbnail,export+]</code> the result will be "array ('file' => '20120313-ASK_5605-150x150.jpg', 'width' => 150, 'height' => 150, 'mime-type' => 'image/jpeg'".
		</td>
	</tr>
</table>
<p>
Eight "format" values help you reformat fields or encode them for use in HTML attributes and tags:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">,raw</td>
<td>If you want to avoid filtering a value through the WordPress <code>sanitize_text_field()</code> function you can add the ",raw" option. This is helpful when, for example, you are using a field that contains HTML markup such as a hyperlink.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">,commas</td>
<td>For numeric data source parameters such as "file_size" you can add the ",commas" option to format the value for display purposes.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">,attr</td>
<td>If you use a substitution parameter in an HTML attribute such as the <code>title</code> attribute of a hyperlink (<code>a</code>) or <code>img</code> tag you can add the ",attr" option to encode the <, >, &, " and ' (less than, greater than, ampersand, double quote and single quote) characters.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">,url</td>
<td>If you use a substitution parameter in an HTML <code>href</code> attribute such as a hyperlink (<code>a</code>) or <code>img</code> tag you can add the ",url" option to convert special characters such as quotes, spaces and ampersands to their URL-encoded equivalents.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold; white-space:nowrap">,substr(s,l)</td>
<td>If you need to limit the length of a value or extract a portion of it the ",substr" option will return part of the value. This option accepts one or two parameters, "start" (s) and "length" (l). The first character in the value is at position zero (0) so, for example, ",substr(2,3)" would return "cde" from a value of "abcdef". You can find complete information on "start" and "length", including the effect of negative values, at: <a href="http://php.net/manual/en/function.substr.php" title="PHP substr parameters" target="_blank">http://php.net/manual/en/function.substr.php</a>.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold; white-space:nowrap">,fraction(f,s)</td>
<td>Many of the EXIF metadata fields are expressed as "rational" quantities, i.e., separate numerator and denominator values separated by a slash. For example, <code>[+exif:ExposureTime+]</code> can be expressed as "1/200" seconds. The "fraction" format converts these to a more useful format.<br />&nbsp;<br />There two optional arguments; "f" (format_string)and "s" (show_fractions). The "format_string" (default "2") can either be the number of decimal places desired or a sprintf()-style format specification. For example, <code>[+exif:ExposureTime,fraction(4)+]</code> will display 7/6 as "+1.1667". A format specification such as '%1$.2f' will display 7/6 as "1.17". Numbers between -1 and +1, i.e. true fractions, will display in their original form, e.g., "1/6". If the optional "show_fractions" (default true) argument is "false" fractional values will convert to a decimal equivalent. For example, fraction(4,false) will display 1/6 as "+0.1667", and <code>[+exif:ExposureTime,fraction( '%1$.2f', false )+]</code> will display 1/6 as "0.17".</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold; white-space:nowrap">,timestamp(f)</td>
<td>Many date and time values such as <code>[+meta:image_meta.created_timestamp+]</code> are stored as a UNIX timestamp. The ",timestamp" format converts a timestamp into a variety of date and/or time string formats, using the PHP date() function. Details on the format_string argument can be found at: <a href="http://php.net/manual/en/function.date.php" title="PHP Date format parameters" target="_blank">http://php.net/manual/en/function.date.php</a>.<br />&nbsp;<br />The default format string is "d/m/Y H:i:s", e.g., "31/12/2014 23:59:00" (just before midnight on new year's eve). You could code <code>[+meta:image_meta.created_timestamp,timestamp('j F, Y')+]</code> to display "31 December, 2014".</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold; white-space:nowrap">,date(f)</td>
<td>Many EXIF date and time values such as DateTimeOriginal and DateTimeDigitized are stored as strings with a format of "YYYY:MM:DD HH:MM:SS". You can parse this format and just about any English textual datetime description into a Unix timestamp, then format the result by using the ",date" format. This format first uses the PHP strtotime() function, then the date() function. The "Supported Date and Time Formats" can be found at: <a href="http://php.net/manual/en/datetime.formats.php" title="PHP Supported Date and Time Formats" target="_blank">http://php.net/manual/en/datetime.formats.php</a>.<br />&nbsp;<br />The default format string is "d/m/Y H:i:s", e.g., "31/12/2014 23:59:00" (just before midnight on new year's eve). You could code <code>[+exif:DateTimeOriginal,date('j F, Y')+]</code> to display "31 December, 2014".</td>
</tr>
</table>
<p>
<a name="field_level_data_sources"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Field-level data sources</h4>
Each Media Library attachment item has a row in the "posts" database table that records information such as the Title, Author and Parent post/page. It also has an "attached file" with attributes like the file name and file size. All of this information and more is available as "field-level data sources" that can be used for <code>[mla_gallery]</code> or mapping purposes. The data sources are:
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post_id, ID</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post_author</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post_date</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post_date_gmt</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post_content</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post_title</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post_excerpt</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post_status</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">comment_status</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">ping_status</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post_name</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post_modified</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post_modified_gmt</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">post_content_filtered</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">parent,<br />post_parent</td>
<td style="vertical-align: top">the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">guid</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">menu_order</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mime_type,<br />post_mime_type</td>
<td style="vertical-align: top">the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">comment_count</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">alt_text</td>
<td style="padding-bottom: 2em;">ALT text, for image types. If there are multiple values (unlikely) they will be returned as a comma-separated list. You can use the ",single" or ",export" option values to change that.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">absolute_path</td>
<td>complete path portion of the attachment file, e.g., C:/site/wordpress/wp-content/uploads/2012/11/</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">absolute_file_name</td>
<td>complete path and file name of the attachment file, e.g., C:/site/wordpress/wp-content/uploads/2012/11/filename.ext</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">base_file</td>
<td>relative path (within uploads directory) and file name of the attachment file, e.g., 2012/11/image.jpg</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">path</td>
<td>path portion of the base_file value, e.g., 2012/11/</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">file_name</td>
<td>file name and extension portion of the base_file value, e.g., image.jpg</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">name_only</td>
<td>file name portion of the base_file value, e.g., image</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">extension</td>
<td>extension portion of the base_file value, e.g., jpg</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">file_size</td>
<td>file size in bytes</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">upload_date</td>
<td style="padding-bottom: 2em;">date and time attachment was added to the Media Library</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">dimensions</td>
<td>for image types, width x height, e.g., 1024x768</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">pixels</td>
<td>for image types, size in pixels, e.g., 307200 for a 640x480 image</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">width</td>
<td>for image types, width in pixels</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">height</td>
<td>for image types, height in pixels</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">orientation</td>
<td>"portrait" (height > width) or "landscape", for image types; empty for non-image types</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">hwstring_small</td>
<td>HTML dimensions of a "small" image, i.e., 128 or less width, 96 or less height. Not computed for images uploaded in WordPress 3.5 and later.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">size_keys</td>
<td>image size names for thumbnail versions of the image, e.g., "thumbnail, medium, large"</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">size_names</td>
<td>image file names for thumbnail versions of the image, e.g., "image-150x150.jpg, image-300x225.jpg, image-600x288.jpg"</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">size_bytes</td>
<td>file size in bytes for thumbnail versions of the image, e.g., "5127, 11829, 33968"</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">size_pixels</td>
<td>image size in pixels for thumbnail versions of the image, e.g., "22500, 67500, 172800"</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">size_dimensions</td>
<td>image dimensions for thumbnail versions of the image, e.g., "150x150, 300x225, 600x288"</td>
</tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">size_name[size]</td>
<td>image file name for a specific thumbnail version, e.g., size_name[medium] = "image-300x225.jpg"; set to empty string if the specified size does not exist. There will be a [size] choice for every thumbnail version registered with WordPress for the site.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">size_bytes[size]</td>
<td>file size in bytes for a specific thumbnail version, e.g., size_bytes[medium] = "11829"</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">size_pixels[size]</td>
<td>image size in pixels for a specific thumbnail version, e.g., size_pixels[medium] = "67500"</td>
</tr>
<tr>
<tr>
<td style="width: 12em; padding-right: 10px; vertical-align: top; font-weight:bold">size_dimensions[size]</td>
<td style="padding-bottom: 2em;">image dimensions for a specific thumbnail version, e.g., size_dimensions[medium] = "300x225"; set to empty string if the specified size does not exist. There will be a [size] choice for every thumbnail version registered with WordPress for the site.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">parent_date</td>
<td>for "attached" (post_parent not zero) objects, "published on" date of the parent object</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">parent_type</td>
<td>for "attached" (post_parent not zero) objects, post type of the parent object</td>
</tr>
<tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">parent_title</td>
<td>for "attached" (post_parent not zero) objects, post title of the parent object</td>
</tr>
<tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">parent_issues</td>
<td>summary of parent status (only) "issues", e.g., bad parent, invalid parent, unattached</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">reference_issues</td>
<td>summary of all reference and parent status "issues", e.g., orphan, bad parent, invalid parent, unattached</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">featured_in</td>
<td>the title, post/page type and id number of each post/page for which this item is the "featured image"</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">featured_in_title</td>
<td>the title of each post/page for which this item is the "featured image"</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">inserted_in</td>
<td>the title, post/page type and id number of each post/page where this item is inserted in the post/page content</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">inserted_in_title</td>
<td>the title of each post/page where this item is inserted in the post/page content</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">gallery_in</td>
<td>the title, post/page type and id number of each post/page where this item appears in a <code>[gallery]</code> shortcode</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">gallery_in_title</td>
<td>the title of each post/page where this item appears in a <code>[gallery]</code> shortcode</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_gallery_in</td>
<td>the title, post/page type and id number of each post/page where this item appears in an <code>[mla_gallery]</code> shortcode</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_gallery_in_title</td>
<td style="padding-bottom: 2em;">the title of each post/page where this item appears in an <code>[mla_gallery]</code> shortcode</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">aperture</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">credit</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">camera</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">caption</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">created_timestamp</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">copyright</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">focal_length</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">iso</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">shutter_speed</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">title</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
</table>
<a name="mla_iptc_identifiers"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Field-level IPTC Identifiers and Friendly Names</h4>
<p>
The IPTC specification defines all of the allowed fields and organizes them into "Records" and "DataSets" (fields). When you use the "iptc:" prefix to source a field-level substitution parameter you can specify the field you want in either of two ways. First you can use the Record number and DataSet tag, such as "2#005" for Record 2, DataSet 005; this is the "Object Name" DataSet. Second, you can use the Friendly Name, such as "object-name". The MLA Friendly Name values differ in some cases from the names in the IPTC specification but the table below should be easy to follow.
</p>
<table>
<tr><td colspan="3" style="font-weight:bold">Envelope Record</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">model-version</td><td style="padding-right: 10px; vertical-align: top">1#000</td><td style="padding-right: 10px; vertical-align: top">2 octet binary IIM version number</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">destination</td><td style="padding-right: 10px; vertical-align: top">1#005</td><td style="padding-right: 10px; vertical-align: top">Max 1024 characters of Destination (ISO routing information); repeatable</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">file-format</td><td style="padding-right: 10px; vertical-align: top">1#020</td><td style="padding-right: 10px; vertical-align: top">2 octet binary file format number, see IPTC-NAA V4 Appendix A</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">file-format-version</td><td style="padding-right: 10px; vertical-align: top">1#022</td><td style="padding-right: 10px; vertical-align: top">2 octet binary file format version number</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">service-identifier</td><td style="padding-right: 10px; vertical-align: top">1#030</td><td style="padding-right: 10px; vertical-align: top">Max 10 characters of Service Identifier and product</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">envelope-number</td><td style="padding-right: 10px; vertical-align: top">1#040</td><td style="padding-right: 10px; vertical-align: top">8 Character Envelope Number</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">product-id</td><td style="padding-right: 10px; vertical-align: top">1#050</td><td style="padding-right: 10px; vertical-align: top">Max 32 characters subset of provider's overall service; repeatable</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">envelope-priority</td><td style="padding-right: 10px; vertical-align: top">1#060</td><td style="padding-right: 10px; vertical-align: top">1 numeric character of envelope handling priority (not urgency)</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">date-sent</td><td style="padding-right: 10px; vertical-align: top">1#070</td><td style="padding-right: 10px; vertical-align: top">8 numeric characters of Date Sent by service - CCYYMMDD</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">time-sent</td><td style="padding-right: 10px; vertical-align: top">1#080</td><td style="padding-right: 10px; vertical-align: top">11 characters of Time Sent by service - HHMMSS±HHMM</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">coded-character-set</td><td style="padding-right: 10px; vertical-align: top">1#090</td><td style="padding-right: 10px; vertical-align: top">Max 32 characters of control functions, etc.</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">uno</td><td style="padding-right: 10px; vertical-align: top">1#100</td><td style="padding-right: 10px; vertical-align: top">14 to 80 characters of eternal, globally unique identification for objects</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">arm-identifier</td><td style="padding-right: 10px; vertical-align: top">1#120</td><td style="padding-right: 10px; vertical-align: top">2 octet binary Abstract Relationship Model Identifier</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">arm-version</td><td style="padding-right: 10px; vertical-align: top">1#122</td><td style="padding-right: 10px; vertical-align: top">2 octet binary Abstract Relationship Model Version</td></tr>
<tr><td colspan="3" style="font-weight:bold">&nbsp;<br />Application Record</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">record-version</td><td style="padding-right: 10px; vertical-align: top">2#000</td><td style="padding-right: 10px; vertical-align: top">2 octet binary Information Interchange Model, Part II version number</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">object-type-reference</td><td style="padding-right: 10px; vertical-align: top">2#003</td><td style="padding-right: 10px; vertical-align: top">3 to 67 Characters of Object Type Reference number and optional text</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">object-attribute-reference</td><td style="padding-right: 10px; vertical-align: top">2#004</td><td style="padding-right: 10px; vertical-align: top">3 to 67 Characters of Object Attribute Reference number and optional text; repeatable</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">object-name</td><td style="padding-right: 10px; vertical-align: top">2#005</td><td style="padding-right: 10px; vertical-align: top">Max 64 characters of the object name or shorthand reference</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">edit-status</td><td style="padding-right: 10px; vertical-align: top">2#007</td><td style="padding-right: 10px; vertical-align: top">Max 64 characters of the status of the objectdata</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">editorial-update</td><td style="padding-right: 10px; vertical-align: top">2#008</td><td style="padding-right: 10px; vertical-align: top">2 numeric characters of the type of update this object provides</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">urgency</td><td style="padding-right: 10px; vertical-align: top">2#010</td><td style="padding-right: 10px; vertical-align: top">1 numeric character of the editorial urgency of content</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">subject-reference</td><td style="padding-right: 10px; vertical-align: top">2#012</td><td style="padding-right: 10px; vertical-align: top">13 to 236 characters of a structured definition of the subject matter; repeatable</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">category</td><td style="padding-right: 10px; vertical-align: top">2#015</td><td style="padding-right: 10px; vertical-align: top">Max 3 characters of the subject of the objectdata, DEPRECATED</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">supplemental-category</td><td style="padding-right: 10px; vertical-align: top">2#020</td><td style="padding-right: 10px; vertical-align: top">Max 32 characters (each) of further refinement of subject, DEPRECATED; repeatable</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">fixture-identifier</td><td style="padding-right: 10px; vertical-align: top">2#022</td><td style="padding-right: 10px; vertical-align: top">Max 32 characters identifying recurring, predictable content</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">keywords</td><td style="padding-right: 10px; vertical-align: top">2#025</td><td style="padding-right: 10px; vertical-align: top">Max 64 characters (each) of tags; repeatable</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">content-location-code</td><td style="padding-right: 10px; vertical-align: top">2#026</td><td style="padding-right: 10px; vertical-align: top">3 characters of ISO3166 country code or IPTC-assigned code; repeatable</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">content-location-name</td><td style="padding-right: 10px; vertical-align: top">2#027</td><td style="padding-right: 10px; vertical-align: top">Max 64 characters of publishable country/geographical location name; repeatable</td></tr>

<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">release-date</td><td style="padding-right: 10px; vertical-align: top">2#030</td><td style="padding-right: 10px; vertical-align: top">8 numeric characters of Release Date (earliest use) - CCYYMMDD</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">release-time</td><td style="padding-right: 10px; vertical-align: top">2#035</td><td style="padding-right: 10px; vertical-align: top">11 characters of Release Time (earliest use) - HHMMSS±HHMM</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">expiration-date</td><td style="padding-right: 10px; vertical-align: top">2#037</td><td style="padding-right: 10px; vertical-align: top">8 numeric characters of Expiration Date (latest use) -  CCYYMDD</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">expiration-time</td><td style="padding-right: 10px; vertical-align: top">2#038</td><td style="padding-right: 10px; vertical-align: top">11 characters of Expiration Time (latest use) - HHMMSS±HHMM</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">special-instructions</td><td style="padding-right: 10px; vertical-align: top">2#040</td><td style="padding-right: 10px; vertical-align: top">Max 256 Characters of editorial instructions, e.g., embargoes and warnings</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">action-advised</td><td style="padding-right: 10px; vertical-align: top">2#042</td><td style="padding-right: 10px; vertical-align: top">2 numeric characters of type of action this object provides to a previous object</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">reference-service</td><td style="padding-right: 10px; vertical-align: top">2#045</td><td style="padding-right: 10px; vertical-align: top">Max 10 characters of the Service ID (1#030) of a prior envelope; repeatable</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">reference-date</td><td style="padding-right: 10px; vertical-align: top">2#047</td><td style="padding-right: 10px; vertical-align: top">8 numeric characters of prior envelope Reference Date (1#070) - CCYYMMDD; repeatable</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">reference-number</td><td style="padding-right: 10px; vertical-align: top">2#050</td><td style="padding-right: 10px; vertical-align: top">8 characters of prior envelope Reference Number (1#040); repeatable</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">date-created</td><td style="padding-right: 10px; vertical-align: top">2#055</td><td style="padding-right: 10px; vertical-align: top">8 numeric characters of intellectual content Date Created - CCYYMMDD</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">time-created</td><td style="padding-right: 10px; vertical-align: top">2#060</td><td style="padding-right: 10px; vertical-align: top">11 characters of intellectual content Time Created - HHMMSS±HHMM</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">digital-creation-date</td><td style="padding-right: 10px; vertical-align: top">2#062</td><td style="padding-right: 10px; vertical-align: top">8 numeric characters of digital representation creation date - CCYYMMDD</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">digital-creation-time</td><td style="padding-right: 10px; vertical-align: top">2#063</td><td style="padding-right: 10px; vertical-align: top">11 characters of digital representation creation time - HHMMSS±HHMM</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">originating-program</td><td style="padding-right: 10px; vertical-align: top">2#065</td><td style="padding-right: 10px; vertical-align: top">Max 32 characters of the program used to create the objectdata</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">program-version</td><td style="padding-right: 10px; vertical-align: top">2#070</td><td style="padding-right: 10px; vertical-align: top">Program Version - Max 10 characters of the version of the program used to create the objectdata</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">object-cycle</td><td style="padding-right: 10px; vertical-align: top">2#075</td><td style="padding-right: 10px; vertical-align: top">1 character where a=morning, p=evening, b=both</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">by-line</td><td style="padding-right: 10px; vertical-align: top">2#080</td><td style="padding-right: 10px; vertical-align: top">Max 32 Characters of the name of the objectdata creator, e.g., the writer, photographer; repeatable</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">by-line-title</td><td style="padding-right: 10px; vertical-align: top">2#085</td><td style="padding-right: 10px; vertical-align: top">Max 32 characters of the title of the objectdata creator; repeatable</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">city</td><td style="padding-right: 10px; vertical-align: top">2#090</td><td style="padding-right: 10px; vertical-align: top">Max 32 Characters of the city of objectdata origin</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">sub-location</td><td style="padding-right: 10px; vertical-align: top">2#092</td><td style="padding-right: 10px; vertical-align: top">Max 32 Characters of the location within the city of objectdata origin</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">province-or-state</td><td style="padding-right: 10px; vertical-align: top">2#095</td><td style="padding-right: 10px; vertical-align: top">Max 32 Characters of the objectdata origin Province or State</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">country-or-primary-location-code</td><td style="padding-right: 10px; vertical-align: top">2#100</td><td style="padding-right: 10px; vertical-align: top">3 characters of ISO3166 or IPTC-assigned code for Country of objectdata origin</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">country-or-primary-location-name</td><td style="padding-right: 10px; vertical-align: top">2#101</td><td style="padding-right: 10px; vertical-align: top">Max 64 characters of publishable country/geographical location name; repeatable</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">original-transmission-reference</td><td style="padding-right: 10px; vertical-align: top">2#103</td><td style="padding-right: 10px; vertical-align: top">Max 32 characters of a code representing the location of original transmission</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">headline</td><td style="padding-right: 10px; vertical-align: top">2#105</td><td style="padding-right: 10px; vertical-align: top">Max 256 Characters of a publishable entry providing a synopsis of the contents of the objectdata</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">credit</td><td style="padding-right: 10px; vertical-align: top">2#110</td><td style="padding-right: 10px; vertical-align: top">Max 32 Characters that identifies the provider of the objectdata (Vs. the owner/creator)</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">source</td><td style="padding-right: 10px; vertical-align: top">2#115</td><td style="padding-right: 10px; vertical-align: top">Max 32 Characters that identifies the original owner of the intellectual content</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">copyright-notice</td><td style="padding-right: 10px; vertical-align: top">2#116</td><td style="padding-right: 10px; vertical-align: top">Max 128 Characters that contains any necessary copyright notice</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">contact</td><td style="padding-right: 10px; vertical-align: top">2#118</td><td style="padding-right: 10px; vertical-align: top">Max 128 characters that identifies the person or organization which can provide further background information; repeatable</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">caption-or-abstract</td><td style="padding-right: 10px; vertical-align: top">2#120</td><td style="padding-right: 10px; vertical-align: top">Max 2000 Characters of a textual description of the objectdata</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">caption-writer-or-editor</td><td style="padding-right: 10px; vertical-align: top">2#122</td><td style="padding-right: 10px; vertical-align: top">Max 32 Characters that the identifies the person involved in the writing, editing or correcting the objectdata or caption/abstract; repeatable</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">rasterized-caption</td><td style="padding-right: 10px; vertical-align: top">2#125</td><td style="padding-right: 10px; vertical-align: top">7360 binary octets of the rasterized caption - 1 bit per pixel, 460x128-pixel image</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">image-type</td><td style="padding-right: 10px; vertical-align: top">2#130</td><td style="padding-right: 10px; vertical-align: top">2 characters of color composition type and information</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">image-orientation</td><td style="padding-right: 10px; vertical-align: top">2#131</td><td style="padding-right: 10px; vertical-align: top">1 alphabetic character indicating the image area layout - P=portrait, L=landscape, S=square</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">language-identifier</td><td style="padding-right: 10px; vertical-align: top">2#135</td><td style="padding-right: 10px; vertical-align: top">2 or 3 alphabetic characters containing the major national language of the object, according to the ISO 639:1988 codes</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">audio-type</td><td style="padding-right: 10px; vertical-align: top">2#150</td><td style="padding-right: 10px; vertical-align: top">2 characters identifying monaural/stereo and exact type of audio content</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">audio-sampling-rate</td><td style="padding-right: 10px; vertical-align: top">2#151</td><td style="padding-right: 10px; vertical-align: top">6 numeric characters representing the audio sampling rate in hertz (Hz)</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">audio-sampling-resolution</td><td style="padding-right: 10px; vertical-align: top">2#152</td><td style="padding-right: 10px; vertical-align: top">2 numeric characters representing the number of bits in each audio sample</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">audio-duration</td><td style="padding-right: 10px; vertical-align: top">2#153</td><td style="padding-right: 10px; vertical-align: top">6 numeric characters of the Audio Duration - HHMMSS</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">audio-outcue</td><td style="padding-right: 10px; vertical-align: top">2#154</td><td style="padding-right: 10px; vertical-align: top">Max 64 characters of the content of the end of an audio objectdata</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">objectdata-preview-file-format</td><td style="padding-right: 10px; vertical-align: top">2#200</td><td style="padding-right: 10px; vertical-align: top">2 octet binary file format of the ObjectData Preview</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">objectdata-preview-file-format-version</td><td style="padding-right: 10px; vertical-align: top">2#201</td><td style="padding-right: 10px; vertical-align: top">2 octet binary particular version of the ObjectData Preview File Format</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">objectdata-preview-data</td><td style="padding-right: 10px; vertical-align: top">2#202</td><td style="padding-right: 10px; vertical-align: top">Max 256000 binary octets containing the ObjectData Preview data</td></tr>
<tr><td colspan="3" style="font-weight:bold">&nbsp;<br />Pre ObjectData Descriptor Record</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">size-mode</td><td style="padding-right: 10px; vertical-align: top">7#010</td><td style="padding-right: 10px; vertical-align: top">1 numeric character - 0=objectdata size not known, 1=objectdata size known at beginning of transfer</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">max-subfile-size</td><td style="padding-right: 10px; vertical-align: top">7#020</td><td style="padding-right: 10px; vertical-align: top">4 octet binary maximum subfile dataset(s) size</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">objectdata-size-announced</td><td style="padding-right: 10px; vertical-align: top">7#090</td><td style="padding-right: 10px; vertical-align: top">4 octet binary objectdata size if known at beginning of transfer</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">maximum-objectdata-size</td><td style="padding-right: 10px; vertical-align: top">7#095</td><td style="padding-right: 10px; vertical-align: top">4 octet binary largest possible objectdata size</td></tr>
<tr><td colspan="3" style="font-weight:bold">&nbsp;<br />ObjectData</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">subfile</td><td style="padding-right: 10px; vertical-align: top">8#010</td><td style="padding-right: 10px; vertical-align: top">Subfile DataSet containing the objectdata itself; repeatable</td></tr>
<tr><td colspan="3" style="font-weight:bold">&nbsp;<br />Post ObjectData Descriptor Record</td></tr>
<tr><td style="padding-right: 10px; vertical-align: top; font-weight:bold">confirmed-objectdata-size</td><td style="padding-right: 10px; vertical-align: top">9#010</td><td style="padding-right: 10px; vertical-align: top">4 octet binary total objectdata size</td></tr>
</table>
<a name="mla_camera_values"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Field-level enhanced EXIF CAMERA values</h4>
<p>
The EXIF specification defines many "Tags Relating to Picture-taking Conditions". Some of these are processed by WordPress and added to the "image_meta" array (as aperture, camera, focal_length, iso, shutter_speed). The field-level values in this section supplement those values and provide convenient access to additional values as well.
</p>
<p>
The native format of this data is somewhat complicated, so MLA converts the most common elements into more convenient formats. For example, "rational" values are expressed as decimal equialents or converted to forms more often seen in photographic applications. You can use the enhanced values as-is or use them in a Content Template to compose the format(s) you need. You can access the native values with the names defined in the EXIF specification, e.g., "ExposureTime". The enhanced values are provided in the "CAMERA" array and accessed with compound names, e.g., "CAMERA.ExposureTime". The MLA enhanced values are:</p>
<table>
<tr style="font-weight: bold"><td>Field</td><td>Example</td><td>Content</td></tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">ExposureTime</td>
<td style="padding-right: 10px; vertical-align: top">1.04, 1/250</td>
<td style="padding-right: 10px; vertical-align: top">Exposure time, given in seconds.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">ShutterSpeed from ExposureTime</td>
<td style="padding-right: 10px; vertical-align: top">1.04, 1/250</td>
<td style="padding-right: 10px; vertical-align: top">Derived from ExposureTime and more often converted to the more useful "one over something" format.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">FNumber</td>
<td style="padding-right: 10px; vertical-align: top">7.1, 8</td>
<td style="padding-right: 10px; vertical-align: top">The F Number.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">ExposureBiasValue</td>
<td style="padding-right: 10px; vertical-align: top">-1, +1/3</td>
<td style="padding-right: 10px; vertical-align: top">The exposure bias. The unit is the APEX value, usually in the range of -99.99 to 99.99.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Flash</td>
<td style="padding-right: 10px; vertical-align: top">no, yes</td>
<td style="padding-right: 10px; vertical-align: top">The "flash fired" portion of the flash status.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">FocalLength</td>
<td style="padding-right: 10px; vertical-align: top">420, 500</td>
<td style="padding-right: 10px; vertical-align: top">The actual focal length of the lens, in mm. It is not converted to the focal length of a 35mm film camera.</td>
</tr>
</table>
<p>
The EXIF specification defines several "Other Tags" with more information about each image; these tags are not recognized by the PHP <code>exif_read_data()</code> function. 
The MLA enhanced values for "Other Tags" are:</p>
<table>
<tr style="font-weight: bold"><td>Field</td><td>Example</td><td>Content</td></tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">ImageUniqueID</td>
<td style="padding-right: 10px; vertical-align: top"></td>
<td style="padding-right: 10px; vertical-align: top">an identifier assigned uniquely to each image. It is recorded as an ASCII string equivalent to hexadecimal notation and 128-bit fixed length.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">CameraOwnerName</td>
<td style="padding-right: 10px; vertical-align: top"></td>
<td style="padding-right: 10px; vertical-align: top">records the owner of a camera used in photography as an ASCII string.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">BodySerialNumber</td>
<td style="padding-right: 10px; vertical-align: top">6033674</td>
<td style="padding-right: 10px; vertical-align: top">the serial number of the camra body as an ASCII string.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LensSpecification</td>
<td style="padding-right: 10px; vertical-align: top">"80/1, 400/1, 45/10, 56/10"</td>
<td style="padding-right: 10px; vertical-align: top">a four-element array containing minimum focal length, maxinum focal length, minimum F number in the minimum focal length and minimum F number in the maximum focal length.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LensMinFocalLength</td>
<td style="padding-right: 10px; vertical-align: top">80</td>
<td style="padding-right: 10px; vertical-align: top">minimum focal length element of the LensSpecification array.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LensMaxFocalLength</td>
<td style="padding-right: 10px; vertical-align: top">400</td>
<td style="padding-right: 10px; vertical-align: top">maximum focal length element of the LensSpecification array.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LensMinFocalLengthFN</td>
<td style="padding-right: 10px; vertical-align: top">4.5</td>
<td style="padding-right: 10px; vertical-align: top">minimum F number in the minimum focal length element of the LensSpecification array.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LensMaxFocalLengthFN</td>
<td style="padding-right: 10px; vertical-align: top">5.6</td>
<td style="padding-right: 10px; vertical-align: top">minimum F number in the maximum focal length element of the LensSpecification array.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LensMake</td>
<td style="padding-right: 10px; vertical-align: top">Canon</td>
<td style="padding-right: 10px; vertical-align: top">the lens manufacturer as an ASCII string.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LensModel</td>
<td style="padding-right: 10px; vertical-align: top">80.0-400.0 mm f/4.5-5.6</td>
<td style="padding-right: 10px; vertical-align: top">the lens's model name and model number as an ASCII string.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LensSerialNumber</td>
<td style="padding-right: 10px; vertical-align: top"></td>
<td style="padding-right: 10px; vertical-align: top">the serial number of the interchangable lens as an ASCII string.</td>
</tr>
</table>
<a name="mla_gps_values"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Field-level enhanced EXIF GPS values</h4>
<p>
There are three basic forms of writing geographic coordinates; they are explained in a Wikipedia article, <a href="http://en.wikipedia.org/wiki/Geographic_coordinate_conversion" title="Wikipedia on Geographic coordinate conversion" target="_blank">Geographic coordinate conversion</a>. The <a href="http://www.cipa.jp/english/hyoujunka/kikaku/pdf/DC-008-2010_E.pdf" title="EXIF Version 2.3 specification" target="_blank">Exif Standard version 2.3</a> (PDF) document explains the structure and defines the rules for 32 GPS elements.
</p>
<p>
The native format of this data is somewhat complicated, so MLA converts the most common elements into a variety of convenient formats. You can use the enhanced values as-is or use them in a Content Template to compose the format(s) you need. You can access the native values with the names defined in the EXIF specification, e.g., "GPSLatitude". The enhanced values are provided in th "GPS" array and accessed with compound names, e.g., "GPS.Latitude". The MLA enhanced values are:</p>
<table>
<tr style="font-weight: bold"><td>Field</td><td>Example</td><td>Content</td></tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Version</td>
<td style="padding-right: 10px; vertical-align: top">2.2.0.0</td>
<td style="padding-right: 10px; vertical-align: top">The version of the GPS Information specification</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LatitudeRef</td>
<td style="padding-right: 10px; vertical-align: top">N or S</td>
<td style="padding-right: 10px; vertical-align: top">Indicates whether the latitude is north or south latitude</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LatitudeRefS</td>
<td style="padding-right: 10px; vertical-align: top">empty or "-"</td>
<td style="padding-right: 10px; vertical-align: top">Blank for north, "-" for south</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Latitude</td>
<td style="padding-right: 10px; vertical-align: top">44d 7' 34.0167" N</td>
<td style="padding-right: 10px; vertical-align: top">Latitude expressed as degrees, minutes and seconds</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LatitudeD</td>
<td style="padding-right: 10px; vertical-align: top">44</td>
<td style="padding-right: 10px; vertical-align: top">Degree portion of Latitude</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LatitudeM</td>
<td style="padding-right: 10px; vertical-align: top">7</td>
<td style="padding-right: 10px; vertical-align: top">Minute portion of Latitude</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LatitudeS</td>
<td style="padding-right: 10px; vertical-align: top">34.0167</td>
<td style="padding-right: 10px; vertical-align: top">Second portion of Latitude</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LatitudeSDM</td>
<td style="padding-right: 10px; vertical-align: top">44 7.5669</td>
<td style="padding-right: 10px; vertical-align: top">Latitude expressed as degrees and decimal minutes (MinDec),<br />with a leading "-" for Southern values</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LatitudeSDD</td>
<td style="padding-right: 10px; vertical-align: top">44.126116</td>
<td style="padding-right: 10px; vertical-align: top">Latitude expressed as decimal degrees,<br />with a leading "-" for Southern values</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LatitudeDM</td>
<td style="padding-right: 10px; vertical-align: top">44 7.5669N</td>
<td style="padding-right: 10px; vertical-align: top">Latitude expressed as degrees and decimal minutes (MinDec)</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LatitudeDD</td>
<td style="padding-right: 10px; vertical-align: top">44.126116N</td>
<td style="padding-right: 10px; vertical-align: top">Latitude expressed as decimal degrees</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LatitudeMinDec</td>
<td style="padding-right: 10px; vertical-align: top">7.5669</td>
<td style="padding-right: 10px; vertical-align: top">Decimal Minutes portion of Latitude</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LatitudeDegDec</td>
<td style="padding-right: 10px; vertical-align: top">.126116</td>
<td style="padding-right: 10px; vertical-align: top">Decimal Degrees portion of Latitude</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LongitudeRef</td>
<td style="padding-right: 10px; vertical-align: top">E or W</td>
<td style="padding-right: 10px; vertical-align: top">Indicates whether the Longitude is east or west longitude</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LongitudeRefS</td>
<td style="padding-right: 10px; vertical-align: top">empty or "-"</td>
<td style="padding-right: 10px; vertical-align: top">Blank for east, "-" for west</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Longitude</td>
<td style="padding-right: 10px; vertical-align: top">145d 5' 9.2055" E</td>
<td style="padding-right: 10px; vertical-align: top">Longitude expressed as degrees, minutes and seconds</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LongitudeD</td>
<td style="padding-right: 10px; vertical-align: top">145</td>
<td style="padding-right: 10px; vertical-align: top">Degree portion of Longitude</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LongitudeM</td>
<td style="padding-right: 10px; vertical-align: top">5</td>
<td style="padding-right: 10px; vertical-align: top">Minute portion of Longitude</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LongitudeS</td>
<td style="padding-right: 10px; vertical-align: top">9.2055</td>
<td style="padding-right: 10px; vertical-align: top">Second portion of Longitude</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LongitudeSDM</td>
<td style="padding-right: 10px; vertical-align: top">145 5.1534</td>
<td style="padding-right: 10px; vertical-align: top">Longitude expressed as degrees and decimal minutes (MinDec),<br />with a leading "-" for Western values</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LongitudeSDD</td>
<td style="padding-right: 10px; vertical-align: top">145.085890</td>
<td style="padding-right: 10px; vertical-align: top">Longitude expressed as decimal degrees,<br />with a leading "-" for Western values</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LongitudeDM</td>
<td style="padding-right: 10px; vertical-align: top">145 5.1534E</td>
<td style="padding-right: 10px; vertical-align: top">Longitude expressed as degrees and decimal minutes (MinDec)</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LongitudeDD</td>
<td style="padding-right: 10px; vertical-align: top">145.085890E</td>
<td style="padding-right: 10px; vertical-align: top">Longitude expressed as decimal degrees</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LongitudeMinDec</td>
<td style="padding-right: 10px; vertical-align: top">5.1534</td>
<td style="padding-right: 10px; vertical-align: top">Decimal Minutes portion of Longitude</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">LongitudeDegDec</td>
<td style="padding-right: 10px; vertical-align: top">.085890</td>
<td style="padding-right: 10px; vertical-align: top">Decimal Degrees portion of Longitude</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">AltitudeRef</td>
<td style="padding-right: 10px; vertical-align: top">0 or 1</td>
<td style="padding-right: 10px; vertical-align: top">0 = above sea level, 1 = below sea level</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">AltitudeRefS</td>
<td style="padding-right: 10px; vertical-align: top">blank or "-"</td>
<td style="padding-right: 10px; vertical-align: top">Blank above sea level, "-" below sea level</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Altitude</td>
<td style="padding-right: 10px; vertical-align: top">247.0825</td>
<td style="padding-right: 10px; vertical-align: top">Altitude in meters</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">AltitudeFeet</td>
<td style="padding-right: 10px; vertical-align: top">810.64</td>
<td style="padding-right: 10px; vertical-align: top">Altitude in feet</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">TimeStamp</td>
<td style="padding-right: 10px; vertical-align: top">01:00:34</td>
<td style="padding-right: 10px; vertical-align: top">The time as UTC (Coordinated Universal Time)</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">TimeStampH</td>
<td style="padding-right: 10px; vertical-align: top">01</td>
<td style="padding-right: 10px; vertical-align: top">The hours portion of TimeStamp</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">TimeStampM</td>
<td style="padding-right: 10px; vertical-align: top">00</td>
<td style="padding-right: 10px; vertical-align: top">The minutes portion of TimeStamp</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">TimeStampS</td>
<td style="padding-right: 10px; vertical-align: top">34</td>
<td style="padding-right: 10px; vertical-align: top">The seconds portion of TimeStamp</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">DateStamp</td>
<td style="padding-right: 10px; vertical-align: top">2013:08:09</td>
<td style="padding-right: 10px; vertical-align: top">The date as UTC (Coordinated Universal Time)</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">DateStampY</td>
<td style="padding-right: 10px; vertical-align: top">2013</td>
<td style="padding-right: 10px; vertical-align: top">The year portion of DateStamp</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">DateStampM</td>
<td style="padding-right: 10px; vertical-align: top">08</td>
<td style="padding-right: 10px; vertical-align: top">The month portion of DateStamp</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">DateStampD</td>
<td style="padding-right: 10px; vertical-align: top">09</td>
<td style="padding-right: 10px; vertical-align: top">The day portion of DateStamp</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">MapDatum</td>
<td style="padding-right: 10px; vertical-align: top">WGS-84</td>
<td style="padding-right: 10px; vertical-align: top">The geodetic survey data used by the GPS receiver</td>
</tr>
</table>
<a name="pdf_metadata"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Field-level metadata in PDF documents</h4>
<p>
Metadata in PDF documents comes from two sources. Early versions of the PDF specification defined a Document Information Dictionary (D.I.D.) containing up to nine (optional) fields:
</p>
<table>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Title</td>
		<td>The document's title</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Author</td>
		<td>The name of the person who created the document</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Subject</td>
		<td>The subject of the document</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Keywords</td>
		<td>Keywords associated with the document</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Creator</td>
		<td>If the document was converted to PDF from another format, the name of the application (for example, Adobe FrameMaker&reg;) that created the original document from which it was converted</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Producer</td>
		<td>If the document was converted to PDF from another format, the name of the application (for example, Acrobat Distiller) that converted it to PDF</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">CreationDate</td>
		<td>The date and time the document was created, in human-readable form</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">ModDate</td>
		<td>The date and time the document was most recently modified, in human-readable form</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Trapped</td>
		<td>A keyword (True, False, Unknown) indicating whether the document has been modified to include trapping information</td>
	</tr>
</table>
<p>
More recent versions of the specification add a second source of metadata, Metadata Streams, holding data defined by the <a href="https://www.adobe.com/products/xmp/" title="Adobe XMP site" target="_blank">Extensible Metadata Platform (XMP)</a> framework. XMP metadata varies from document to document but is often extensive. MLA provides access to this data in four ways:
<ol>
<li>
If a D.I.D. field is not stored in the document, MLA will copy appropriate values from the XMP data into the empty field to populate it as often as possible. For example, the "creator" value(s) in the "dc" namespace ("dc.creator") might be copied to an empty "Author" field, or the "dc.subject" value(s) might be copied to an empty Keywords field.
</li>
<li>
Additional values in the "xmp", "xmpMM", "xmpRights", "xap", "xapMM", "dc", "pdf" and "pdfx" namespaces are copied up to the root level for easier access. For example, the "pdfx.SourceModified" value can be accessed as "SourceModified", without the "pdfx." portion of the compound name.
</li>
<li>
Other namespaces in the document are copied to arrays at the root level. For example, some documents contain information in the "photoshop" namespace, such as "photoshop.CaptionWriter" and "photoshop.AuthorsPosition". The native values of some fields, e.g., "dc.creator", can be an array.
</li>
<li>
For consistency with other file types, all XMP data found in a PDF document is also available with the "xmp:" prefix.
</li>
</ol>
</p>
<p>
MLA adds five fields of its own to the metadata information:
</p>
<table>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">PDF_Version</td>
		<td>the version of the PDF specification to which the file conforms. For a file conforming to PDF 1.7, this would be PDF−1.7</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">PDF_VersionNumber</td>
		<td>the numeric portion of the PDF_Version. For a file conforming to PDF 1.7, this would be 1.7</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">xmptk</td>
		<td>the XMP software used to create the metadata</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">xmlns</td>
		<td>an array of the namespaces found in the document, such as <code>'dc' => 'http://purl.org/dc/elements/1.1/'</code></td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">ALL_PDF</td>
		<td>a special "pseudo value" that returns a string representation of all the metadata. You can use this pseudo-value to examine the metadata in a document, find field names and see what values are present.</td>
	</tr>
</table>
<a name="mla_template_parameters"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Content Templates</h3>
<p>
Content Templates (templates) are one of the Field-level Markup Substitution Parameters, indicated by a prefix value ( <code>[+template: ... +]</code> ). Within a template you can have any combination of four elements:
</p>
<table>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">String</td>
		<td>text and/or field-level substitution parameters, e.g., <code>[+template: Base File - [+base_file+] +]</code></td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Conditional</td>
		<td>text and/or field-level substitution parameters that will be tested for missing values. Any field-level substitution parameter that is not valid, is empty or contains only whitespace will cause the entire conditional to be eliminated. Conditional elements are enclosed in parentheses. For example, <code>[+template: (ITPC Title: [+iptc:object-name+] ) +]</code>. If the IPTC field is missing or blank both it and the preceding "ITPC Title: " literal are eliminated.</td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Choice</td>
		<td>two or more alternatives from which the first valid, non-empty value will be taken. Choice elements are separated by vertical bars ("|"), e.g., <code>[+template: Summary: ([+caption+]|[+description+]|[+title+]) +]</code></td>
	</tr>
	<tr>
		<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Template</td>
		<td>another template. There is no particular advantage to nesting templates, but it works.</td>
	</tr>
</table>
<p>
The conditional and choice elements are the key to templates' power, particularly with custom fields and metadata such as ITPC and EXIF. With the conditional element you can combine literal text with a substitution value and eliminate the text if the value is missing. With the choice element you can specify multiple sources for a value and decide the order in which they are tested. In the choice example above the text "Description: " will always be used, followed by the attachment's caption (if present) or the description value or the literal "none" if both of the other values are missing. In other words, each alternative of the choice element is evaluated as a conditional element; no need for more parentheses.
</p>
<p>
Conditional, choice and template elements can be nested as needed. For example, a conditional element can have a choice element within it or a choice alternative could include a conditional. Here's an example:
<p><code>[+template: Terms: (([+terms:category+], [+terms:post_tag+])|[+ terms: category +]|[+terms:post_tag +]|none)+]</code>
</p>
<p>
This template has a String, "Terms: " and a Conditional, "(([+terms: ... none)". This Conditional separates the "Terms: " literal from the first alternative in the Choice. Within the Conditional is a Choice having four alternatives. The first alternative is a Conditional, which will be empty unless both categories and tags are present.  The second and third alternatives handle the cases where one of the two taxonomies has terms, and the final alternative is used when neither categories nor tags are present.
</p>
<p>
In the Media/Assistant submenu table  Bulk Edit area and the IPTC/EXIF Standard Field mapping fields you can use the special <code>template:[+empty+]</code> value to support deleting the content of the Title, Caption, Description and ALT Text fields.
</p>
<h4>Special characters inside templates</h4>
<p>
The conditional and choice elements require delimiters, "(", ")" and "|". If you want to put any of these three characters in your template, preface them with two backslash characters, e.g., "\\(". If you need a backslash in your template, code it as four backslash characters, i.e., "\\\\". The doubling of backslash characters is required because of the way WordPress processes shortcode parameters.
</p>
<a name="mla_text_widget"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>The MLA Text Widget</h3>
<p>
The MLA Text Widget lets you add content such as <code>[mla_gallery]</code> and <code>[mla_tag_cloud]</code> displays to your site's sidebars. It is an easy way to add slide shows and navigation features to all your pages. The MLA Text Widget is based on the WordPress Text widget, but adds the ability to include <strong>any</strong> shortcode to widget content. To use the MLA Text Widget:
<ol>
<li>Go to the Appearance/Widgets Administration screen</li>
<li>Open the sidebar, footer, or Theme section to which you wish to add the Text Widget</li>
<li>Find the Text Widget in the list of Widgets</li>
<li>Click and drag the Widget to the spot you wish it to appear</li>
</ol>
</p>
<p>
To open and edit the MLA Text Widget: 
<ol>
<li>Click the down arrow to the right of the MLA Text Widget title</li>
<li>Set the MLA Text Widget Title (optional)</li>
<li>Add the text or HTML code to the box or edit what is currently there</li>
<li>If desired, choose the option to Automatically add paragraphs to wrap each block of text in an HTML paragraph tag</li>
<li>Click Save to save the Widget</li>
<li>Click Close to close the Widget</li>
<li>Switch tabs in your browser and review the results; make changes if necessary</li>
</ol>
</p>
<p>
To add an <code>[mla_gallery]</code> or <code>[mla_tag_cloud]</code> shortcode to your widget, simply enter the shortcode name and parameters just as you would in the body of a post or page. Aside from the usually more limited area devoted to displaying the widget content, there are no differences in the way shortcodes are processed in the MLA Widget. Also, there is nothing special about the two MLA shortcodes; <strong>any</strong> shortcode can be added to the MLA Widget.
<a name="terms_search"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Terms Search - filtering on taxonomy term names</h3>
<p>
The "Terms Search" features let you filter the Media/Assistant submenu table and the Media Manager Modal Window by matching one or more phrases in the Name field of taxonomy terms. There are two ways to access this feature:
</p>
<ol>
<li>Check the "Terms" box under the "Search Media" button on the Media/Assistant submenu table or the Media Manager toolbar. The phrase(s) you enter in the search box will match taxonomy term names as well as any other search fields you have checked.</li>
<li>Click the "Terms Search" button beside the terms filter dropdown. This will bring up the "Search Terms" popup window with several additional controls to refine your search. They are described below.</li>
</ol>
<h4>Entering words and phrases</h4>
<p>
You can enter one or more words/phrases in the Search Media or Search Terms text box, separated by spaces. A multi-word phrase is created by surrounding two or more words with double quotes ( " ). For example:
</p>
<ul class="mla_settings">
<li>' man bites dog ' is three separate one-word phrases</li>
<li>' man "bites dog" ' is a one-word phrase (man) and a two-word phrase (bites dog)</li>
<li>' "man bites dog" ' is one three-word phrase</li>
</ul>
<p>
The first example would match each word separately. The second would match "man" and "bites dog" separately, with exactly one space between "bites" and "dog". 
</p>
<p>
Quote marks have another effect on the search; they restrict the match to a word boundary. For example, if you enter 'man' without enclosing quotes it will match "man" or "woman", because "<strong>man</strong>" appears as a part of "wo<strong>man</strong>". If you add quotes, i.e., ' "man" ', it will match "man" or "big man" but it will not match the "man" portion of "woman".
</p>
<h4>Connecting multiple phrases</h4>
The search is further defined by the connector used between multiple phrases:
</p>
<ul class="mla_settings">
<li>'and'/'All phrases' - all of the phrases must appear in the search field/term name.</li>
<li>'or'/'Any phrase' - any one (or more) of the phrases must appear in the search field/term name.</li>
</ul>
<p>
For example, if you choose the default 'and'/'All phrases' connector and enter 'man "bites dog"' in the text box:
</p>
<ul class="mla_settings">
<li>'man that bites dog' will match, but 'man that dog bites' will not match.</li>
<li>'dog bites man' will not match.</li>
<li>'man bites man with dog' will not match.</li>
</ul>
<p>
If, however you remove the quotes and enter 'man bites dog' all of the above examples will match, because all three of the phrases appear somewhere in the text. On the other hand 'man bites man' would not match because "dog" does not appear in the text.
</p>
<p>
If you choose the 'or'/'Any phrase' connector and enter 'man "bites dog"' in the text box:
</p>
<ul class="mla_settings">
<li>'man that bites dog' will match.</li>
<li>'man that dog bites' will match because "man" is present.</li>
<li>'dog bites man' will match because "man" is present.</li>
<li>'dog bites another dog' will not match.</li>
</ul>
<h4>Exact phrase matching</h4>
<p>
The Search Terms popup window has an additional capability, "Exact match" and a checkbox to activate it. When you check the "Exact" box, each phrase must match the entire text of a term name. For example, if you check "Exact", the phrase "man" will match a term of the same name but not a term named "big man". If you check "Exact" and enter "big man" you will match terms named "big" or "man" <strong>but not</strong> "big man". If you want an exact match on a multi-word term such as "big man", put quotes around the name, i.e., ' "big man" '.
</p>
<h4>Entering multiple terms</h4>
<p>
The Search Terms popup window has an additional capability and another control to refine it. The additional capability lets you search for multiple terms and the control sets the connector between terms. For example, consider two taxonomies, each with several terms:
</p>
<ul class="mla_settings">
<li>Att. Categories, containing "big animal", "small animal" and "other being"</li>
<li>Att. Tags, containing "male", "female", "cat" and "dog"</li>
</ul>
<p>
If you choose 'All phrases' and 'Any term' (the defaults) and enter 'big dog' there are no matches because none of the terms contain both 'big' and 'dog'. If you choose 'Any phrase' and 'Any term' you will get items assigned to the 'big animal' Att. Category or the 'dog' Att. Tag. If you choose 'Any phrase' and 'All terms' you will get only the items assigned to both the 'big animal' Att. Category <strong>and</strong> the 'dog' Att. Tag.
</p>
<p>
If you enter 'big,dog', separating the two phrases with a comma, the search results will change. Terms will be matched against "big" and "dog" separately. The 'All phrases'/Any phrase' choice will not matter because both of the phrases contain just one word. Choose 'All terms' and you will get any items assigned to 'big animal' <strong>and</strong> to 'dog'. Choose 'Any term' and you will get all of the 'big animal' matches and all of the 'dog' matches; that includes small dogs and big cats.
</p>
<h4>Selecting taxonomies</h4>
<p>
By default, the Att. Categories and Att. Tags taxonomies are included in the terms search. In the Taxonomy Support section of the Settings/Media Library Assistant General tab you can use the checkboxes in the Terms Search column to add or remove any of the supported taxonomies from the search process.
</p>
<p>
In the Search Terms popup window you will find a list of all supported taxonomies, with checkboxes reflecting their participation in the search process. You can add or remove taxonomies from the process on a search-by-search basis.
<a name="select_parent"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Select Parent Popup Window</h3>
<p>
The "Select Parent" popup window lets you find the parent post/page/custom post type for one or more attachments. You can access the popup window in four ways:
</p>
<ol>
<li>Click the "Set Parent" link in the "Attached to" column of the Media/Assistant submenu table.</li>
<li>Click the "Select" button in the Media/Assistant submenu table Quick Edit area.</li>
<li>Click the "Select" button in the Media/Assistant submenu table Bulk Edit area.</li>
<li>Click the "Select" button in the Media/Edit Media submenu "Parent Info" meta box.</li>
</ol>
<p>
In all cases the Select Parent popup window will appear and will be filled with up to 50 parent candidates. If the current parent is in the list its radio button will be selected. You can select a new parent, including "(unattached)", by clicking anywhere in the row of the candidate you want.
</p>
<p>
If you don't see the candidate you want you have three ways of updating the list:
</p>
<ol>
<li>Enter one or more keywords in the text box at the top of the window and click "Search". The word(s) you enter will filter the list by searching the Title and Content fields for matches.</li>
<li>Select a post type from the dropdown list at the top of the window. The list will be filtered to show candidates from the post type you choose.</li>
<li>Click the "next page" (" &raquo; ") button in the Media/Assistant submenu table Bulk Edit area. The list will move to the next page of up to 50 additional candidates. You can click the "previous page" (" &laquo; ") button to move back towards the top of the list.</li>
</ol>
<p>
Once you have chosen a new parent, click the "Update" button at the lower right of the window to save your choice. You will be returned to your starting point with the new value filled in. Changes made in the "Attached to" column are immediate; changes to the Quick Edit, Bulk Edit and Parent Info meta box are made later, when you click the "Update" button in those areas to save all your changes.
</p>
<p>
If you change your mind you can close the window without making a change by clicking the "X" in the upper-right corner of the window or the "Cancel" button in the lower-left corner of the window.
<a name="mla_media_modal_filters"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Media Manager Enhancement filters (Hooks)</h3>
<p>
Media Library Assistant adds several controls to the toolbar in the Media Manager Modal Window; more MIME type filters, year/month filter, taxonomy term filter and an enhanced Search media box. You can change the initial values set for these controls when the Modal Window opens using a filter that MLA provides.An example of using the hooks from a simple, stand-alone plugin can be found here: <a title="View the Meta Box Hooks Example source code" href="[+examples_url+]mla-media-modal-hooks-example.php.txt" target="_blank" style="font-size:14px; font-weight:bold">mla-media-modal-hooks-example.php.txt</a>. To run the example:
<ol>
<li>Remove the ".txt" extension and save the "mla-media-modal-hooks-example.php" file in your plugins directory. You can give the plugin and its file any (unique) name you like.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA Media Modal Hooks Example" plugin.</li>
<li>Make any changes or additions you want to in the example plugin source code. For example, you can uncomment the <code>$initial_values</code> assignments and setting a new initial value for one or more controls.</li>
<li>Click the "Add Media" button for a post or page to see the effect of your changes.</li>
</ol>
<a name="mla_edit_meta_boxes"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Edit Media additional meta boxes (and Hooks)</h3>
<p>
Media Library Assistant adds support for the "Custom Fields" meta box to the Media/Edit Media screen. MLA also adds several meta boxes to this screen with more information about the item and where it is  used on your site. You can enable/disable the additional meta boxes with an option on the Settings/Media Library Assistant General tab.
</p>
<p>
You can also make individual changes in which meta boxes are displayed and in their content by using one or more of the filters MLA provides. An example of using the hooks from a simple, stand-alone plugin can be found here: <a title="View the Meta Box Hooks Example source code" href="[+examples_url+]mla-metabox-hooks-example.php.txt" target="_blank" style="font-size:14px; font-weight:bold">mla-metabox-example.php.txt</a>. To run the example:
<ol>
<li>Edit the code to, for example, uncomment the <code>error_log()</code> calls so you can see what is passed to the hooks you are interested in.</li>
<li>Remove the ".txt" extension and save the "mla-metabox-example.php" file in your plugins directory. You can give the plugin and its file any (unique) name you like.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA Meta Box Hooks Example" plugin.</li>
<li>Make any changes or additions you want to in the example plugin source code. For example, you can modify the <code>mla_inserted_in_metabox</code> example to display a simplified version of the "Inserted in" information.</li>
<li>View the Media/Edit Media screen for an item to see the effect of your changes.</li>
</ol>
</p>
<p>
The example code documents each hook with comments in the filter function that intercepts the hook. Generally, each meta box filter lets you change the size of the text box (if appropriate) and the content that appears in the box. There is also a second filter for each meta box that lets you replace <strong>all</strong> of the HTML content for most boxes; use these with caution. The current hooks are:
</p>
<table>
<tr>
<td style="padding 0 0 2em 1em; vertical-align: top; font-weight:bold">mla_edit_media_support</td>
<td>suppress the addition of Custom Fields to the Edit Media screen. To suppress Custom Fields, return an empty array, i.e., <code>return array();</code></td>
</tr>
<tr>
<td style="padding 0 0 2em 1em; vertical-align: top; font-weight:bold">mla_edit_media_meta_boxes</td>
<td style="vertical-align: top">record the original list of meta box slugs. You can also remove elements from the array to suppress one or more meta boxes. To suppress a box, remove it from the array, e.g., <code>unset( $active_boxes['mla-menu-order'] );</code></td>
</tr>
<tr>
<td style="padding 0 0 2em 1em; vertical-align: top; font-weight:bold">mla_parent_info_meta_box</td>
<td style="vertical-align: top">modify the text portion of the "Parent Info" meta box.</td>
</tr>
<tr>
<td style="padding 0 0 2em 1em; vertical-align: top; font-weight:bold">mla_menu_order_meta_box</td>
<td style="vertical-align: top">modify the "Menu Order" meta box.</td>
</tr>
<tr>
<td style="padding 0 0 2em 1em; vertical-align: top; font-weight:bold">mla_image_metadata_meta_box<br />mla_image_metadata_meta_box_html</td>
<td style="vertical-align: top">modify the rows, columns and content of the "Attachment Metadata" meta box.</td>
</tr>
<tr>
<td style="padding 0 0 2em 1em; vertical-align: top; font-weight:bold">mla_featured_in_meta_box<br />mla_featured_in_meta_box_html</td>
<td style="vertical-align: top">modify the rows, columns and content of the "Featured in" meta box.</td>
</tr>
<tr>
<td style="padding 0 0 2em 1em; vertical-align: top; font-weight:bold">mla_inserted_in_meta_box<br />mla_inserted_in_meta_box_html</td>
<td style="vertical-align: top">modify the rows, columns and content of the "Inserted in" meta box.</td>
</tr>
<tr>
<td style="padding 0 0 2em 1em; vertical-align: top; font-weight:bold">mla_gallery_in_meta_box<br />mla_gallery_in_meta_box_html</td>
<td style="vertical-align: top">modify the rows, columns and content of the "Gallery in" meta box.</td>
</tr>
<tr>
<td style="padding 0 0 2em 1em; vertical-align: top; font-weight:bold">mla_mla_gallery_in_meta_box<br />mla_mla_gallery_in_meta_box_html</td>
<td style="vertical-align: top">modify the rows, columns and content of the "MLA Gallery in" meta box.</td>
</tr>
</table>
<p>
<a name="mla_views"></a>
&nbsp;
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Library Views/Post MIME Type Processing</h3>
<p>
WordPress uses <em><strong>Post MIME Types</strong></em> (a terrible name; they have nothing to do with Posts or Pages), to define the views for the Media/Library screen and the Media Manager/Add Media "media items" drop down list. MLA's Media/Assistant screen uses an enhanced version of the list, <em><strong>Table Views</strong></em>, to support views with multiple MIME Types (e.g., "audio,video") and wildcard specifications (e.g. "*/*ms*").
</p>
<p>
The first time it is invoked, MLA will retrieve the current list of Post MIME Types and use it to initialize the list. MLA will add any custom items it finds added to the list by other plugins and code. Once the list is initialized, MLA's list will be used and other plugins and code will have no effect. You can disable MLA handling of the list by clearing the <em><strong>Enable View and Post MIME Type Support</strong></em> checkbox at the bottom of the screen and clicking "Save Changes".
</p>
<h4>Post MIME Type</h4>
<p>
The Post MIME Type list uses the Slug, Singular Label and Plural Label values. The Slug is most important; it uniquely identifies the list entry. The Slug value must be all lowercase and contain only letters, numbers, periods (.), slashes (/) and hyphens (-). For &ldquo;Post MIME Type&rdquo; items, the slug is also the MIME type specification and must be a single, valid MIME specification, e.g., &ldquo;image&rdquo; or &ldquo;image/jpeg&rdquo;. The labels are displayed in various admin screens.
</p>
<h4>Use Within WordPress</h4>
<p>
Within WordPress, the Post MIME Types list is returned from <code>/wp-includes/post.php, function get_post_mime_types()</code>. That function is called from:
</p>
<ul class="mla_settings">
<li><code>/wp-admin/includes/media.php function get_media_item()</code>, to validate the type of an attachment when it is edited,</li>
<li><code>/wp-admin/includes/post.php, function wp_edit_attachments_query()</code> to count the number of attachments of each type, and</li>
<li><code>/wp-includes/media.php function wp_enqueue_media()</code>, to populate the the Media Manager/Add Media "media items" drop down list.</li>
</ul>
<h4>Table View</h4>
<p>
The Table View list adds several enhancements to the Post MIME Type list. In the Specification field you can select several MIME types with a comma-separated list, e.g., "audio,video". Wildcard specifications are also supported. For example, "*/mpeg" to select audio and video mpeg formats or "application/*ms*" to select all Microsoft application formats (Word, Excel, etc.). In the Menu Order field you can enter numeric values to re-arrange the order in which the list entries are displayed in, for example, the Media/Assistant screen.
</p>
<p>
The Table View list also supports custom field queries. You can choose from three forms of the custom field specification:
</p>
<ul class="mla_settings">
<li>To return all items that have a non-NULL value in the field, simply enter the prefix "custom:" followed by the custom field name. For example, <code>custom:My Featured Items</code></li>
<li>To return all items that have a NULL value in the field, enter the prefix "custom:" followed by the custom field name and then ",null". For example, <code>custom:My Featured Items,null</code></li>
<li>To return all items that match one or more values, enter the prefix "custom:" followed by the custom field name and then "=" followed by a list of values. For example, <code>custom:Color=red</code> or <code>custom:Color=red,green,blue</code>. Wildcard specifications are also supported; for example, "*post" to match anything ending in "post" or "th*da*" to match values like "the date" and "this day".</li>
</ul>
<p>
If you have enabled the <em><strong>Media Manager Enhanced MIME Type filter</strong></em>, the Table View list will also be available in the Media Manager/Add Media "media items" drop down list.
</p>
<a name="mla_uploads"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>File Extension and MIME Type Processing</h3>
<p>
The file extension/MIME Type associations are used by WordPress to decide what kind of files can be uploaded to the Media Library and to fill in the <code>post_mime_type</code> value for files added to the Media Library. To upload a file, the file extension must be in this list and be active. 
</p>
<p>
The first time it is invoked, MLA will retrieve the current list of extensions and  MIME Types and use it to initialize the list. MLA will add any custom items it finds added to the list by other plugins and code. Once the list is initialized, MLA's list will be used and other plugins and code will have no effect. You can disable MLA handling of the list by clearing the <em><strong>Enable Upload MIME Type Support</strong></em> checkbox at the bottom of the screen and clicking "Save Changes".
</p>
<h4>Extension and MIME Type</h4>
<p>
The Extension is the file extension for this type, and unique key for the item. It must be all lowercase and contain only letters, numbers and hyphens (-). The MIME Type value must be all lowercase and contain only letters, numbers, periods (.), slashes (/) and hyphens (-). The MIME type specification must be a single, valid MIME specification, e.g., "image" or "image/jpeg". These two values are used to compose the list of valid extension/type associations for use within WordPress.
<p>
When a file is uploaded to your Media Library the MIME type associated with that file extension is saved in the WordPress database record for the item. Later, you can use the <code>post_mime_type</code> to, for example, include or exclude the item from an <code>[mla_gallery]</code> display. You can think of the MIME Type as another way to categorize items in the Media Library. Once assigned, the MIME Type is not changed if you later alter the association between file extension and MIME Type. Think twice, therefore, when adding a new association to the list or changing the MIME type associated with an existing extension on the list.
</p>
<h4>Icons and Icon Types</h4>
<p>WordPress maintains a list of "file types" which associate file extensions with type names used to select an icon image. For example, an "audio" file type is associated with an image of musical notes. There are nine of these types: archive, audio, code, default, document, interactive, spreadsheet, text and video. MLA has a much longer list; 112 icon types/images in all. If the "Enable MLA File Type Icons Support" checkbox at the bottom of the Settings screen, Uploads tab  is checked, the enhanced icon images will be used in place of the WordPress images.</p>
<p>The MLA icon images are slightly larger than the default images and square; 64x64 pixels. The images are drawn (with permission) from the <a href="http://www.softicons.com/free-icons/system-icons/crystal-project-icons-by-everaldo-coelho" target="_blank">Crystal Project Icons</a>, created by <a href="http://www.everaldo.com" target="_blank">Everaldo Coelho</a>, founder of <a href="http://www.yellowicon.com/" target="_blank">Yellowicon</a>. You can find the images in the <code>/plugins/media-library-assistant/images/crystal</code> directory.</p>
<p>You can change the icon image associated with any file extension by selecting a new value from the dropdown list on the Edit Upload MIME Type screen or in the Quick Edit area. You can change the icon image for several extensions at once using the Bulk Edit action.</p>
<p>If you have some other plugin or mechanism for handling the Upload MIME Type items, you can disable MLA support entirely. Clear the checkbox at the bottom-left corner of the screen and click "Save Changes".</p>
<h4>Source and Status</h4>
<p>
The "Source" of an Upload MIME Type reveals where the extension/MIME Type association comes from:
<ul class="mla_settings">
<li><strong>core</strong>: WordPress defines a core set of extensions and associated MIME types, and this list changes with new WordPress releases. These are the "official" items. You can't delete them, but you can inactivate them so they are not used to validate file uploads.</li>
<li><strong>mla</strong>: Media Library Assistant adds several more extension/type items, drawing from the most popular items found in other plugins and web sites. They are initialized as "inactive" items, so you must explicitly decide to activate them for use in file upload validation.</li>
<li><strong>custom</strong>: Defined by some other plugin or code, or by manual action. When MLA first builds its list it will automatically add anything it finds in your current list as a new, active custom item. After that, you can use MLA to manage them.</li>
</ul>
<p>
The "Status" of an item determines whether it is used by WordPress to validate file uploads and assign MIME types to attachments in your Media Library. Only "active" items are used in this way; making an item "inactive" will prevent further uploads with that extension but will NOT affect any attachments already in your Media Library.
</p>
<h4>Use Within WordPress</h4>
<p>
Within WordPress, the Uploads list is returned from two different functions. In the current MLA release, the same list is returned from both functions. It appears that <code>wp_get_mime_types()</code> is designed to be more liberal than <code>get_allowed_mime_types()</code>. If you have a reason to return different results from one or the other function, let me know and I will consider enhancing the plugin.
</p>
<p>
The first function is <code>/wp-includes/functions.php, function wp_get_mime_types()</code>. That function is called from:
</p>
<ul class="mla_settings">
<li><code>/wp-includes/class-wp-image-editor.php function get_mime_type()</code>, to validate the type of an attachment when it is edited,</li>
<li><code>/wp-includes/class-wp-image-editor.php function get_extension()</code>, to validate the type of an attachment when it is edited,</li>
<li><code>/wp-includes/functions.php, function do_enclose()</code> to "check content for video and audio links to add as enclosures", and</li>
<li><code>/wp-includes/functions.php, function get_allowed_mime_types()</code>, to populate the the Media Manager/Add Media "media items" drop down list.</li>
</ul>
<p>
The second function is <code>/wp-includes/functions.php, function get_allowed_mime_types()</code>. That function is called from:
</p>
<ul class="mla_settings">
<li><code>/wp-includes/formatting.php function sanitize_file_name()</code>, to validate the name of a file, and</li>
<li><code>/wp-includes/functions.php, function wp_check_filetype()</code>, to validate the type of a file before it is uploaded</li>
</ul>
<p>
The list is also used in <code>/wp-includes/ms-functions.php, function check_upload_mimes()</code>, which "is used to filter that list against the filetype whitelist provided by Multisite Super Admins at <code>/wp-admin/network/settings.php</code>." Multisite installs must respect this restriction, so any list we produce will be passed thru that function if it exists.
</p>
<p>
The Icon Type information is used primarily in a function that matches a file extension to an icon image:
</p>
<ul class="mla_settings">
<li><code>/wp-includes/post.php, function wp_mime_type_icon()</code></li>
</ul>
<p>
The icon images can be returned in a <code>[gallery]</code> or an <code>[mla_gallery]</code> shortcode when <code>size=icon</code> is specified. The icons also appear on the Media/Library and Media/Assistant submenu tables.
</p>
<a name="mla_optional_uploads"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Searching for Upload MIME Types</h3>
<p>
The association between file extensions and MIME Types is an inexact science, as you might imagine. Over the years many companies, standards bodies and other organizations have laid claim to file extensions for different purposes and defined MIME Types to suit their needs. As this is written there are hundreds of web sites with lists of extensions and corresponding MIME Types; most of them give no explanation or justification for their choices. 
</p>
<p>
If you come across a new file extension, or if the existing extension/MIME type association does not suit you, you can search the MLA list of over 1,500 alternatives. The list was compiled from several Internet sources and a vigorous attempt was made to get a Description for each choice. If you find a mistake or an entry missing from the list, let me know!
</p>
<p>
The <em><strong>Known File Extension/MIME Type Associations</strong></em> list will often list several MIME Types for a given file extension. Think carefully before choosing one that differs from the WordPress and MLA Types, if they exist. Once you choose an association and upload files of that type, think <strong>very carefully</strong> before changing it, because changes will <strong>not</strong> be applied to existing Media Library items.
</p>
<p>
For your own research, I suggest starting with these resources:
<ul class="mla_settings">
<li><a href="http://www.iana.org/assignments/media-types" target="_blank">Internet Assigned Number Authority MIME Media Types</a></li>
<li><a href="http://en.wikipedia.org/wiki/Internet_media_type" target="_blank">Wikipedia: Internet Media Type</a></li>
<li><a href="http://en.wikipedia.org/wiki/Mailcap" target="_blank">Wikipedia: Mailcap</a></li>
<li><a href="http://filext.com/" target="_blank">FILExt: A free online resource by Uniblue</a></li>
</ul>
<p>
Put on your boots and have a paddle handy - it's a swamp! Good luck.
<a name="mla_custom_field_mapping"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Custom Field and Attachment Metadata Processing Options</h3>
<p>
In the Custom Fields tab of the Settings screen you can define the rules for mapping several types of file and image metadata to WordPress custom fields. Custom field mapping can be applied automatically when an attachment is added to the Media Library. You can refresh the mapping for <strong><em>ALL</em></strong> attachments using the command buttons on the screen. You can selectively apply the mapping in the bulk edit area of the Media/Assistant submenu table and/or on the Edit Media screen for a single attachment.
</p>
<p>
You can also use this screen to define rules for adding or updating elements within the WordPress-supplied "Attachment Metadata", stored in the "_wp_attachment_metadata" custom field. See the <a href="#attachment_metadata_mapping">Adding or changing Attachment Metadata</a> section below for details.
</p>
<p>
This is a powerful tool, but it comes at the price of additional database storage space and processing time to maintain and retrieve the data. <strong><em>Think carefully about your needs before you use this tool.</em></strong> You can disable or delete any rules you create, so you might want to set up some rules for a special project or analysis of your library and then discard them when you're done. That said, the advantages of mapping metadata to custom fields are:
</p>
<ul class="mla_settings">
<li>You can add the data to an <code>[mla_gallery]</code> with a field-level markup substitution parameter. For example, add the image dimensions or a list of all the intermediate sizes available for the image.</li>
<li>You can add the data as a sortable, searchable column to the Media/Assistant submenu table. For example, you can find all the "orphans" in your library by adding "reference_issues" and then sorting by that column. You can also click on any value in the column to filter the display on a single custom field value.</li>
</ul>
<p>
If you just want to add a custom field to the Media/Assistant submenu, the quick edit area and/or the bulk edit area you can bypass the mapping logic by leaving the Data Source value as "-- None (select a value) --".
<a name="custom_field_mapping_example"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Custom field mapping example</h4>
<p>
Here is a simple example of mapping the items' file size to a custom field, so you can display it in the Media/Assistant submenu table and use it in and <code>[mla_gallery]</code> shortcode. You can go to the Settings/Media Library Assistant Custom Fields tab and define a rule that maps file size to a WordPress custom field. The steps required are:
<ol>
<li>Navigate to the Settings/Media Library Assistant "Custom Fields" tab.</li>
<li>Make sure the "Enable custom field mapping when adding new media" box is checked. If not, check the box, scroll down to the bottom of the page and click "Save Changes".</li>
<li>Scroll down to the "Add a new Field and Mapping Rule" area.</li>
<li>In the first text box, give your field a name, e.g., "File Size".</li>
<li>From the Data Source dropdown list, select "file_size".</li>
<li>In the "Existing Text" dropdown list, select "Replace".</li>
<li>In the "Format" dropdown list, select "Commas". This will format the values in a more attractive way.</li>
<li>Click the "MLA Column" check box to make the field available in the Media/Assistant submenu table. You can also click the "Quick Edit" and "Bulk Edit" check boxes to make the field available in the Media/Assistant submenu table Quick Edit and Bulk Edit areas if that's useful for you.</li>
<li>In the "Option:" dropdown list, select "Text".</li>
<li>Click the "Delete NULL Values" checkbox.</li>
<li>Click the "Add Field and Map All Attachments" button to save your work and create the "File Size" value for the items already in your Media Library.</li>
</ol>
<p>
On the Media/Assistant screen you can now display a File Size column. If you don't see the column, pull down the Screen Options (upper-right corner) and check the box next to File Size. Each of the terms in the column is a link; click on a value to get a list filtered by that value. You can also sort the table on File Size by clicking on the column header.</p>
<p>
You can use the meta_key, orderby and order parameters to sort an <code>[mla_gallery]</code> by your custom field. For example:<br />
&nbsp;<br />
<code>[mla_gallery post_parent=all meta_key="File Size" orderby=meta_value order=DESC]</code><br />
&nbsp;<br />
The three parameters in the above example will select all of the images in your media library and sort your gallery so the largest files appear first. You can replace <code>post_parent=all</code> with any other data selection parameters to get the items you want. For example, you can use a "meta_query" to select only those items (of any MIME Type) whose File Size is less than 82,168 bytes (and display the size in the gallery item caption):<br />
&nbsp;<br />
<code>[mla_gallery post_mime_type=all meta_query="array( array( 'key' => 'File Size', 'value' => array( '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;', '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;82,168' ), 'compare' => 'BETWEEN' ) )" meta_key="File Size" orderby="meta_value" order="DESC" mla_caption="{+caption+}<br>{+custom:File Size+}"]</code>
</p>
<p>
Note the format of the <code>value</code> and <code>compare</code> parameters within the <code>meta_query</code>. Because the File Size custom field uses the "Commas" format, the values are stored as 15-character strings with leading spaces; this makes the values display and sort sensibly. You must use <code>'compare' => 'BETWEEN'</code> and give the lowest and highest values as an array in the <code>'value' => array( '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;', '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;82,168' )</code> parameter, padding each value out to exactly 15 characters wide.
<a name="custom_field_mapping_table"></a>&nbsp;
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>The custom field mapping table</h4>
<p>
The table contains the rules that map data sources to custom fields. Each rule is displayed as two rows of rule parameters followed by command buttons for maintaining the rule and using it to map attachment data. The rule parameters are:
</p>
<dl>
<dt>Enable custom field mapping when adding new media</dt>
<dd>
Check this box to enable mapping when uploading new media (attachments). Click Save Changes at the bottom of the screen if you change this option. Does NOT affect the operation of the "Map" buttons on the bulk edit, single edit and settings screens.<dt>Field Title</dt>
</dd>
<dd>
Contains the name of the custom field or metadata element to which the rule applies. Attachment metadata elements are displayed as a "meta:" prefix followed by the element name; see the <a href="#attachment_metadata_mapping">Adding or changing Attachment Metadata</a> section for more details.
</dd>
<dt>Data Source dropdown</dt>
<dd>
Contains a list of data elements you can map to the custom field. You can also select "Metadata" or "Template" and use the text box below the dropdown to specify attachment metadata or a content template for the source.
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">-- None (select a value) --</td>
<td>nothing, i.e., no change to existing value (if any). Use this source if you just want to add a custom field to the Media/Assistant submenu and/or the inline edit areas.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">--&nbsp;Metadata&nbsp;(see&nbsp;below)&nbsp;--</td>
<td>WordPress attachment metadata, from the <em>_wp_attachment_metadata</em> array. Enter the field you want in the text box below the dropdown list. More coding guidelines are given in the "<a href="#attachment_metadata_mapping">Adding or changing Attachment Metadata</a>" section above.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">--&nbsp;Template&nbsp;(see&nbsp;below)&nbsp;--</td>
<td style="padding-bottom: 2em;">A Content Template; enter the template text (without the "template:" prefix) in the text box below the dropdown list. More coding guidelines are given in the "<a href="#custom_field_mapping_with_templates">Custom field mapping with Content Templates</a>" section above.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">(other data source)</td>
<td> See the <a href="#field_level_data_sources">Data sources for custom field mapping</a> section for definitions of the other data elements you can select from.
</td>
</tr>
</table>
If you just want to add a custom field to the Media/Assistant submenu, the quick edit area and/or the bulk edit area you can bypass the mapping logic by leaving the Data Source value as "-- None (select a value) --".
<br />&nbsp;<br />
Most of the data elements are static, i.e., they do not change after the attachment is added to the Media Library.
The parent/reference information (parent_type, parent_title, parent_issues, reference_issues) and the "where-used" information (featured in, inserted in, gallery in and MLA gallery in) is dynamic; it will change as you define galleries, insert images in posts, define featured images, etc. Because of the database processing required to update this information, <strong><em>parent, where-used and reference data are NOT automatically refreshed</em></strong>. If you use these elements, you must manually refresh them with the "map data" buttons on the Settings screen, the bulk edit area or the Edit Media screen.
<br />&nbsp;<br />
Several of the data elements are sourced from the WordPress "image_meta" array. The credit, caption, copyright and title elements are taken from the IPTC/EXIF metadata (if any), but they go through a number of filtering rules that are not easy to replicate with the MLA IPTC/EXIF processing rules. You may find these "image_meta" elements more useful than the raw IPTC/EXIF metadata.
</dd>
<dt>Existing Text dropdown</dt>
<dd>
If the custom field already has values for one or more items, you can use "Keep" to retain them or "Replace" to delete them. For options other than "Multi", "Keep" means that an item with a non-blank value in the field will be unchanged, and new values will be stored only in those items that do not have an existing value. For the "Multi" option, the existing value(s) will be retained and any new values will be added as separate instances. 
<br />&nbsp;<br />
You can combine "Keep" and "Multi" in useful ways. For example, you might enter some values manually or source them from another plugin or application. Then, map the same field using an MLA data source with the "Keep" and "Multi" parameters. That will add the MLA values to the values you already entered, giving you a single column with both results.
</dd>
<dt>Format dropdown</dt>
<dd>
Sorting by custom fields in the Media/Assistant submenu is by string values. For numeric data this can cause odd-looking results, e.g., dimensions of "1200x768" will sort before "640x480". Numeic data sources are converted to strings and padded on the left with spaces if you use the "<strong>commas</strong>" format. This padding makes them sort more sensibly. The following example shows the results for the &quot;size_bytes[large]&quot; data source, sorted in ascending order:
<table style="margin-left: 40px; margin-bottom: 10px;">
<thead>
<tr>
<td style="width: 80px; text-align:left">
Native
</td>
<td style="width: 80px; text-align:right">
Commas
</td>
<td style="padding-left: 40px; width: 80px; text-align:left">
Raw
</td>
</tr>
</thead>
<tbody>
<tr>
<td>&nbsp;</td>
<td style="text-align:right">&nbsp;</td>
<td style="padding-left: 40px;">0</td>
</tr>
<tr>
<td>374871</td>
<td style="text-align:right">4,096</td>
<td style="padding-left: 40px;">374871</td>
</tr>
<tr>
<td>4096</td>
<td style="text-align:right">8,192</td>
<td style="padding-left: 40px;">4096</td>
</tr>
<tr>
<td>440242</td>
<td style="text-align:right">374,871</td>
<td style="padding-left: 40px;">440242</td>
</tr>
<tr>
<td>8192</td>
<td style="text-align:right">440,242</td>
<td style="padding-left: 40px;">8192</td>
</tr>
</tbody>
</table>
Four data sources, "file_size", "pixels", "width" and "height", are padded on the left with spaces even if you use the "<strong>native</strong>" format.<br />
&nbsp;<br />
You can also use the "<strong>raw</strong>" format to avoid the conversion of empty values, such as a numeric zero, to a single space. The first row in the above table shows this "<strong>raw</strong>" treatment; it can be useful for fields like "parent".
</dd>
<dt>MLA Column checkbox</dt>
<dd>
Check this box if you want a custom field to appear as a sortable column in the Media/Assistant submenu table. Attachment metadata elements cannot be used as a table column; this box is ignored if the Field Title contains the "meta:" prefix.
</dd>
<dt>Quick Edit checkbox</dt>
<dd>
Check this box if you want the field to appear in the Media/Assistant submenu Quick Edit area.
</dd>
<dt>Bulk Edit checkbox</dt>
<dd>
Check this box if you want the field to appear in the Media/Assistant submenu Bulk Edit area.
</dd>
<dt>Template/Metadata text</dt>
<dd>
If you select "<strong>-- Metadata (see below) --</strong>" as the data source you must specify the name of the field you want in the text box below the data source dropdown box. Any of the fields in the <em>_wp_attachment_metadata</em> array may be named, including the new audio/video fields available with WordPress 3.6 and later. For example, "length_formatted" will return the length of a video attachment. You can specify elements within an array with a compound name, e.g., "audio.sample_rate" to get the sampling rate field from the "audio" array of a video attachment. If you simply specify "audio", you will get the values of every array element, e.g., "mp4,ISO/IEC 14496 AAC,48000,2,16,false,stereo".
<br />&nbsp;<br />
If you select "<strong>-- Template (see below) --</strong>" as the data source you must enter your template in the text box below the data source dropdown box. See the <a href="#custom_field_mapping_with_templates">Custom field mapping with Content Templates</a> section for more details.
</dd>
<dt>Option Dropdown</dt>
<dd>
Several data sources can return more than one value. For example, the "Inserted in" source can return a list of posts/pages that contain references to Media Library items. The format option dropdown can further refine your specification where multiple values exist. There are five options:
<table style="margin-left: 40px; margin-bottom: 10px;">
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Text</td>
<td>(the default) stores a list of the data source values, separated by commas</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Single</td>
<td>stores the first value and discards any additional values, e.g., "mp4" for the "audio" example below</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Export</td>
<td>for single values, same as Text. For multiple values, stores all the field names and values (including nested arrays). For example, the below audio data would be returned in Export format as "array ('dataformat' => 'mp4', 'codec' => 'ISO/IEC 14496-3 AAC', 'sample_rate' => 48000, 'channels' => 2, 'bits_per_sample' => 16, 'lossless' => false, 'channelmode' => 'stereo')".</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Array</td>
<td>stores an array of values in a single instance (database row) of the custom field.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">Multi</td>
<td>stores each unique value in a separate instance (database row) of the custom field. This is the most flexible format, as explained below.</td>
</tr>
</table>
The "Multi" option takes advantage of WordPress' ability to store multiple values for a given custom field name (key) as distinct instances (database rows). For example, consider an image that has been inserted in two different posts, "First Post" and "Second Post". The "Text" option would store both titles in a single custom field instance; "First Post,Second Post". The "Multi" option would store two instances, "First Post" and "Second Post". If the custom field is added to the Media/Assistant submenu table as a column, you could click on either of the two values to filter the table listing by value. That would show you all the items inserted in First Post or all the items inserted in Second Post.
</dd>
<dt>Delete NULL values checkbox</dt>
<dd>
The "Delete NULL values" checkbox lets you control what happens if the data source you've selected does not have a value for every attachment. If the checkbox is cleared (not checked), a single space character will be stored for each attachment if the data source value is empty. If the checkbox is set (checked), there will be no entry/row at all in the metadata table for empty data source values and the custom field will not appear in the Edit Media screen for those attachments. This saves space but might confuse other applications that expect a value to be present for all attachments.
<br />&nbsp;<br />
If you use the "Multi" option you will almost certainly want to use the "Delete NULL values" option as well.
</dd>
</dl>
<a name="custom_field_mapping_buttons"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Custom field mapping command buttons</h4>
<p>
The screen contains command buttons for maintaining the rules and using them to map attachment data. For each of the existing rules the command buttons are:
</p>
<dl>
<dt>Delete Rule</dt>
<dd>
Click this button to delete the mapping rule but leave the custom field values assigned to attachments intact.
</dd>
<dt>Delete Rule AND Field</dt>
<dd>
Click this button to delete the mapping rule AND delete the custom field values assigned to attachments as well.
</dd>
<dt>Update Rule</dt>
<dd>
Click this button to save any changes to the rule parameters, but do not perform any mapping.
</dd>
<dt>Map All Attachments</dt>
<dd>
Click this button to map all attachments using this one rule with its current parameters.  Rule changes are <strong><em>NOT</em></strong> saved when you click this button, and <strong><em>THERE IS NO UNDO FOR THE MAPPING ACTIONS!</em></strong>
</dd>
</dl>
<p>
At the bottom of the screen are command buttons for adding a new rule, adding a new field and mapping attachment data using all of the existing rules:
</p>
<dl>
<dt>Add Rule</dt>
<dd>
To define a new rule for an existing custom field, select the field name from the dropdown list, enter the rule parameters and click this button.
</dd>
<dt>Add Rule and Map All Attachments</dt>
<dd>
Click this button to define a new rule and map all attachments using all the rule&rsquo;s parameters.
</dd>
<dt>Add Field</dt>
<dd>
To define a new rule and a new custom field, enter the field name in the text box, enter the rule parameters and click this button.
</dd>
<dt>Add Field and Map All Attachments</dt>
<dd>
Click this button to define a new rule, define a new custom field and map all attachments using all the rule&rsquo;s parameters.
</dd>
<dt>Save Changes</dt>
<dd>
Click this button to update all of the existing rules at one time. This is handy of you change several rules at once.
</dd>
<dt>Map All Rules, All Attachments Now</dt>
<dd>
Click this button to map all attachments using all of the rules with their current parameters. Rule changes are <strong><em>NOT</em></strong> saved when you click this button, and <strong><em>THERE IS NO UNDO FOR THE MAPPING ACTIONS!</em></strong>
</dd>
</dl>
<a name="attachment_metadata_mapping"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Adding or changing Attachment Metadata</h4>
<p>
WordPress stores an array of information for image, audio and video items in the "_wp_attachment_metadata" custom field. Plugins such as "Fullscreen Galleria" also use this field to store information like GPS coordinates. Many of the array elements, such as the "sizes" array for images, are in turn arrays of more detailed values. <strong>Compound names</strong> are used to access elements within arrays, e.g., &quot;<strong>sizes.thumbnail.file</strong>&quot; is used to specify the file name for the thumbnail version of an image.
</p>
<p>
As explained elsewhere, you can access all of this data with the "meta:" <a href="#mla_variable_parameters">Field-level markup substitution parameter</a>. By coding the "meta:" prefix in the Field Title column of a field mapping rule you can add to or update this data as well, from any of the data sources listed below. You can use a <a href="#mla_template_parameters">Content Template</a> to compose a value from multiple substitution parameters and test for empty values, choosing among two or more alternatives or suppressing the mapping altogether for a given item.
<p>
Let's say, for example, that you want to add GPS coordinates to the "image_meta" element of the Attachment Metadata.
<ol>
<li>
Open the Settings/Media Library Assistant submenu and select the Custom Fields tab. Scroll down to the "Add a new Field and Mapping Rule" section.
</li>
<li>
In the Field Title text box, enter "meta:image_meta.latitude". The rule will store its results in the "latitude" element of the "image_meta" array within the Attachment Metadata field.
</li>
<li>
In the Data Source dropdown, select "-- Template (see below) --". In the text box below the dropdown, enter "([+exif:GPS.LatitudeSDD+])". This is a Content Template that extracts the "GPS.LatitudeSDD" value from the EXIF data embedded in an image file. The parentheses test the result to eliminate empty values; only non-empty values will be mapped into the image_meta array.
</li>
<li>
Set the other parts of the rule as needed. You can select "Keep" if some of your items already have this information or "Replace" to update all items. "Native" and "Text" are appropriate for this example. You can check "Delete NULL values" to remove any existing, empty values for this element. The "MLA Column", "Quick Edit" and "Bulk Edit" checkboxes have no meaning for Attachment Metadata elements and can be left blank; they will be ignored if checked.
</li>
</ol>
</p>
<p>
If you are creating an IPTC/EXIF mapping rule the details are a bit different.
<ol>
<li>
Open the Settings/Media Library Assistant submenu and select the IPTC/EXIF tab. Scroll down to the "Add a new Field and Mapping Rule" section.
</li>
<li>
In the Field Title text box, enter "meta:image_meta.latitude". The rule will store its results in the "latitude" element of the "image_meta" array within the Attachment Metadata field.
</li>
<li>
In the "EXIF/Template" text box, enter "template:([+exif:GPS.LatitudeSDD+])". This is a Content Template that extracts the "GPS.LatitudeSDD" value from the EXIF data embedded in an image file. The parentheses test the result to eliminate empty values; only non-empty values will be mapped into the image_meta array.
</li>
<li>
Set the other parts of the rule as needed. You can select "EXIF" unless you also select an IPTC value and want it to have priority. You can select "Keep" if some of your items already have this information or "Replace" to update all items.
</li>
</ol>
</p>
<a name="custom_field_mapping_with_templates"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Custom field mapping with Content Templates</h4>
<p>
If you select "<strong>-- Template (see below) --</strong>" as the data source you must enter your template in the text box below the data source dropdown box. Do not code the "template:" prefix, just enter the template text.
</p>
<p>
Within a template, all of the data sources listed above are available. For example, you can code <code>[+pixels+]</code> or <code>[+size_keys,single+]</code>.
</p>
<p>
You can use a template to compose a custom field from multiple data sources, e.g., "<code>Taken with [+meta:camera+] at [+dimensions+] using ISO [+exif:ISOSpeedRatings,single+] and [+exif:ExposureTime+] exposure time</code>".
<p>
</p>
You can use a template to compose a custom field from alternative data sources, depending on which fields are populated for a given attachment. For example, "<code>[+pdf:Keywords+]|[+iptc:2#025+]|none</code>" will use the PDF Keywords field, if populated, then the IPTC keywords field, if populated, or the literal "none" if neither field contains a value. With this template you can get keywords from both PDF documents and images in a single field.
<p>
Using a template with the Option Dropdown "Text" or "Single" values will yield a text result. For example, multiple IPTC keywords would be converted into a comma-delimited list as a string. If you combine a template with the "Export", "Array" or "Multi" values the template will deliver an array result if the fields inside the template have multiple values. For example, with "Multi" you can code "<code>([+iptc:2#020<strong>,array</strong>+])([+iptc:2#025<strong>,array</strong>+])</code>" to store each of the IPTC supplemental-category <em><strong>and</strong></em> keywords values (there is no "|" in the template) in a separate custom field value. Note the use of the <strong>,array</strong> formatting option in each field; this is required to get an array result for the field. Also, note that each of the fields is enclosed in parentheses, so the field is suppressed if it contains no values.
</p>
<p>
<strong>CAUTION:</strong> If you use the <code>[+custom:ALL_CUSTOM+]</code> pseudo value in a mapping rule, and you apply the rule more than once, you will see copies of the field you are mapping to in the result. To "clear out" a field you are mapping ALL_CUSTOM into, clear out the text box containing the template, select "Replace" and check the "Delete NULL values" box. Then, click "Map All Attachments"; that will delete the old values and give you a clean start. You'll also see that the template you deleted will be restored after the mapping is complete.
</p>
<a name="other_custom_field_mapping"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Other mapping techniques</h4>
<p>
There are two other ways you can perform custom field mapping for one or more existing attachments:
<dl>
<dt>Single Item Edit/Edit Media screen</dt>
<dd>For WordPress 3.5 and later, you can click the "Map Custom Field metadata" link in the "Image Metadata" postbox to apply the existing mapping rules to a single attachment.  For WordPress 3.4.x and earlier, you can click the "Map Custom Field metadata" button on the Single Item Edit screen to apply the existing mapping rules.
</dd>
<dt>Bulk Action edit area</dt>
<dd>To perform mapping for a group of attachments you can use the Bulk Action facility on the main Assistant screen. Check the attachments you want to map, select "edit" from the Bulk Actions dropdown list and click "Apply". The bulk edit area will open with a list of the checked attachments in the left-hand column. You can click the "Map Custom Field metadata" button in the lower left corner of the area to apply the existing mapping rules to the attachments in the list.
</dd>
</dl>
<a name="mla_iptc_exif_mapping"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>IPTC &amp; EXIF Processing Options</h3>
<p>
Some image file formats such as JPEG DCT or TIFF Rev 6.0 support the addition of data about the image, or <em>metadata</em>, in the image file. Many popular image processing programs such as Adobe PhotoShop allow you to populate metadata fields with information such as a copyright notice, caption, the image author and keywords that categorize the image in a larger collection. WordPress uses some of this information to populate the Title, Slug and Description fields when you add an image to the Media Library.
</p>
<p>
The Media Library Assistant has powerful tools for copying image metadata to:
<ul style="line-height: 1em; list-style-type:disc; margin-left: 20px ">
<li>the WordPress standard fields, e.g., the Caption</li>
<li>taxonomy terms, e.g., in categories, tags or custom taxonomies</li>
<li>WordPress Custom Fields</li>
</ul>
You can define the rules for mapping metadata on the "IPTC/EXIF" tab of the Settings page. You can choose to automatically apply the rules when new media are added to the Library (or not). You can click the "Map IPTC/EXIF metadata" button on the Edit Media/Edit Single Item screen or in the bulk edit area to selectively apply the rules to one or more images. You can click the "Map All Attachments Now" to apply the rules to <strong><em>ALL of the images in your library</em></strong> at one time.
</p>
<p>If you click any of the three "Map All Attachments, ... Now" buttons, the rules currently displayed in that category will be immediately applied to <strong>all</strong> of the attachments in your site. Rule changes are <strong>not</strong> saved when you click any of these buttons.<strong>THERE IS NO UNDO FOR THESE ACTIONS!</strong></p>
<p>
If you just want to add a custom field to the Media/Assistant submenu, the quick edit area and/or the bulk edit area go to the "Custom Fields" tab and follow the instructions there.
<a name="iptc_exif_mapping_example"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>IPTC/EXIF mapping example</h4>
<p>
Here is a simple example of mapping an image's creation date to a custom field, so you can use it to display a gallery of images sorted by the date on which they were taken. There are three common EXIF fields that are populated in most images. For example:
</p>
<blockquote>
DateTimeDigitized 2012:11:28 15:53:23<br />
DateTimeOriginal 2012:11:28 15:53:23<br />
DateTime 2012:12:01 17:37:05<br />
</blockquote>
<p>
You can go to the Settings/Media Library Assistant IPTC/EXIF tab and define a rule that maps any of these fields to a WordPress custom field. The steps required are:
<ol>
<li>Go to the Settings/Media Library Assistant IPTC/EXIF tab.</li>
<li>Make sure the "Enable IPTC/EXIF Mapping when adding new media" box is checked.</li>
<li>Scroll down to the "Custom field mapping" section.</li>
<li>If you have already defined "Date Time Created" as a custom field, use the "Add a new Mapping Rule" section and select the field name in the first dropdown. If the field does not yet exist, use the "Add a new Field and Mapping Rule" section and enter, for example, "Date Time Created" in the first text box.</li>
<li>Leave the "IPTC Value" dropdown list set to the default "None (select a value)" setting.</li>
<li>Enter "DateTimeOriginal" in the EXIF/Template Value field.</li>
<li>Set the Priority dropdown to "EXIF".</li>
<li>Set the Existing Text dropdown to "Keep", unless you want to wipe out any values you've assigned earlier.</li>
<li>Click "Add Rule/Add Field" to save your rule.</li>
</ol>
<p>
If you are feeling confident you can click the "Add Rule/Field and Map All Attachments" button to save your rule and map all of the attachments in your Media Library in one step. If you want to test your work first, you can go to the Media/Assistant submenu table and click the "Edit" rollover action for an image you know has keywords. Click the "Map IPTC/EXIF Metadata" link in the upper right "Save" area of the screen, then look down at the Caption meta box and see if your value is correct. Once you've got your rule working you can update individual images, use the Bulk Edit area to update groups of images or use the "Map All Attachments" button below your rule to process all of your images.
</p>
<p>
You can use the meta_key, orderby and order parameters to sort an <code>[mla_gallery]</code> by your custom field. For example:<br />
&nbsp;<br />
<code>[mla_gallery post_parent=all meta_key="Date Time Created" orderby=meta_value order=DESC]</code><br />
&nbsp;<br />
The three parameters in the above example will select all of the images in your media library and sort your gallery so the newest/most recent images appear first. You can replace <code>post_parent=all</code> with any other data selection parameters to get the images you want. For example, you can use a "meta_query" to select only those images created after 2012-01-01 (and display the date in the gallery item caption):<br />
&nbsp;<br />
<code>[mla_gallery meta_query="array( array( 'key' => 'Date Time Created', 'value' => '2012-01-01', 'compare' => '<' ) )" meta_key="Date Time Created" orderby="meta_value DESC" mla_caption="{+custom:Date Time Created+}" ]</code>
</p>
<a name="iptc_exif_mapping_tables"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>IPTC/EXIF mapping tables</h4>
<p>
The three mapping tables on the IPTC/EXIF tab have the following columns:
<dl>
<dt>Field Title</dt>
<dd>The standard field title, taxonomy name or Custom Field name. In the Custom Field table you can define a new field by entering its name in the blank box at the bottom of the list; the value will be saved when you click "Save Changes" at the bottom of the screen.
<br />&nbsp;<br />
You can also use the Custom field mapping section of this screen to define rules for adding or updating elements within the WordPress-supplied "Attachment Metadata", stored in the "_wp_attachment_metadata" custom field. Code the "meta:" prefix in the Field Title textbox to make the destination of the rule an element of the Attachment Metadata; see the <a href="#attachment_metadata_mapping">Adding or changing Attachment Metadata</a> section for more details.
</dd>
<dt>IPTC Value</dt>
<dd>The IPTC (International Press Telecommunications Council) metadata, if any, embedded in the image file. For this category, you can select any of the IPTC DataSet tag and field identifiers, e.g., "2#025" for the Keywords field. The dropdown list has the identifier and the "friendly name" MLA defines for most of the IPTC fields; see the table of identifiers and friendly names in the table below. You can find more information in the <a href="http://www.iptc.org/std/IIM/4.1/specification/IIMV4.1.pdf" title="IPTC-NAA Information Interchange Model Version No. 4.1 specification" target="_blank">IPTC-NAA Information Interchange Model Version No. 4.1 specification</a>.
</dd>
<dt>EXIF/Template Value</dt>
<dd>The EXIF (EXchangeable Image File) metadata, if any, embedded in a JPEG DCT or TIFF Rev 6.0 image file. 
 Though the specification is not currently maintained by any industry or standards organization, almost all camera manufacturers use it. For this category, you can code any of the field names embedded in the image by the camera or editing software. There is no official list of standard field names, so you just have to know the names your camera and software use; field names are case-sensitive. You can find more information in the <a href="http://en.wikipedia.org/wiki/Exchangeable_image_file_format" title="Exchangeable image file format Wikipedia article" target="_blank">Exchangeable image file format</a> article on Wikipedia. You can find External Links to EXIF standards and tag listings at the end of the Wikipedia article.
<br />&nbsp;<br />
MLA uses a standard PHP function, <a href="http://php.net/manual/en/function.exif-read-data.php" title="PHP Manual page for exif_read_data" target="_blank">exif_read_data</a>, to extract EXIF data from images. The function returns three arrays in addition to the raw EXIF data; COMPUTED, THUMBNAIL and COMMENT. You can access the array elements by prefacing the element you want with the array name. For example, the user comment text is available as "COMPUTED.UserComment" and "COMPUTED.UserCommentEncoding". You can also get "COMPUTED.Copyright" and its two parts (if present), "COMPUTED.Copyright.Photographer" and "COMPUTED.Copyright.Editor". The THUMBNAIL and COMMENT arrays work in a similar fashion.
<br />&nbsp;<br />
MLA provides enhanced access to GPS values within the EXIF metadata; more details are given in the <a href="#mla_gps_values">Enhanced GPS values</a> section below.
<br />&nbsp;<br />
Two special exif "pseudo-values" are available; <strong>ALL_IPTC</strong> and <strong>ALL_EXIF</strong>. These return a string representation (in &quot;export&quot; format) of all IPTC or EXIF data respectively. You can use these pseudo-values to examine the metadata in an image, find field names and see what values are embedded in the image.
<br />&nbsp;<br />
You can also enter a Content Template here by coding the "template:" prefix at the beginning of the value. Do <strong>not</strong> add the "[+" and "+]" delimeters; the prefix is all you need. More information about using templates here is given below.
</dd>
<dt>Priority</dt>
<dd>If both the IPTC Value and the EXIF Value are non-blank for a particular image, you can select which of the values will be used for the mapping.
</dd>
<dt>Existing Text</dt>
<dd>Images already in the Media Library will have non-blank values in many fields and may have existing terms in a taxonomy. You can select "Keep" to retain these values or "Replace" to always map a metadata value into the field. For a taxonomy, "Keep" will retain any terms already assigned to the item and "Replace" will delete any existing terms before assigning metadata values as terms.
</dd>
</dl>
<p>
The Taxonomy term mapping table has two additional columns:
</p>
<dl>
<dt>Delimiter(s)</dt>
<dd>
In some cases multiple terms will be contained in a single IPTC or EXIF value. For example, Microsoft Windows stores its "Tags" in a single EXIF value (called Keywords) as a semicolon-delimited list, e.g., "tag1; tag2". You can separate terms encoded in this way by entering one or more delimiter characters in this column.
</dd>
<dt>Parent</dt>
<dd>For hierarchical taxonomies such as Categories you can select one of the existing terms in the taxonomy as the parent term for any terms you are mapping from metadata values. For example, you could define "IPTC Keywords" as a parent and then assign all of the 2#025 values under that parent term.
</dd>
</dl>
<a name="iptc_exif_mapping_buttons"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>IPTC/EXIF mapping command buttons</h4>
<p>
To the right of each table heading is a "Map All Attachments, ... Now" button. When you click one of these buttons, the mapping rules in that table are applied to <strong><em>ALL of the images in the Media Library</em></strong>. This is a great way to bring your media items up to date, but it is <strong><em>NOT REVERSIBLE</em></strong>, so think carefully before you click! Each button applies the rules in just one category, so (for exmple) you can update taxonomy terms without disturbing standard or custom field values.
</p>
<p>
These immediate mapping buttons <strong><em>DO NOT</em></strong> save any rules changes you've made, so you can make a temporary rule change and process your attachments without disturbing the standing rules.
</p>
<dl>
<dt>Map All Attachments, Standard Fields Now</dt>
<dd>
Click this button to map the Title, Name/Slug, ALT Text, Caption and Description rules for all attachments.
</dd>
<dt>Map All Attachments, Taxonomy Terms Now</dt>
<dd>
Click this button to map IPTC/EXIF values such as keywords to taxonomy terms.
</dd>
<dt>Map All Attachments, Custom Fields Now</dt>
<dd>
Click this button to map all attachments using all of the IPTC/EXIF to custom field rules.
</dd>
</dl>
<p>
For each of the IPTC/EXIF to custom field existing rules the command buttons are:
</p>
<dl>
<dt>Delete Rule</dt>
<dd>
Click this button to delete the mapping rule but leave the custom field values assigned to attachments intact.
</dd>
<dt>Delete Rule AND Field</dt>
<dd>
Click this button to delete the mapping rule AND delete the custom field values assigned to attachments as well.
</dd>
<dt>Update Rule</dt>
<dd>
Click this button to save any changes to the rule parameters, but do not perform any mapping.
</dd>
<dt>Map All Attachments</dt>
<dd>
Click this button to map all attachments using this one rule with its current parameters.  Rule changes are <strong><em>NOT</em></strong> saved when you click this button, and <strong><em>THERE IS NO UNDO FOR THE MAPPING ACTIONS!</em></strong>
</dd>
</dl>
<p>
Below the existing custom field rules there are command buttons for adding a new IPTC/EXIF to custom field rule, adding a new field and mapping attachment data using all of the existing rules:
</p>
<dl>
<dt>Add Rule</dt>
<dd>
To define a new rule for an existing custom field, select the field name from the dropdown list, enter the rule parameters and click this button.
</dd>
<dt>Add Rule and Map All Attachments</dt>
<dd>
Click this button to define a new rule and map all attachments using all the rule&rsquo;s parameters.
</dd>
<dt>Add Field</dt>
<dd>
To define a new rule and a new custom field, enter the field name in the text box, enter the rule parameters and click this button.
</dd>
<dt>Add Field and Map All Attachments</dt>
<dd>
Click this button to define a new rule, define a new custom field and map all attachments using all the rule&rsquo;s parameters.
</dd>
</dl>
<p>
At the bottom of the screen is a command button for saving <strong><em>all</em></strong> of the rule updates at one time:
</p>
<dl>
<dt>Save Changes</dt>
<dd>
Click this button to update all of the existing rules at one time. This is handy of you change several rules at once.
</dd>
</dl>
<p>
"Save Changes" is the <strong><em>only</em></strong> command button that saves changes made in the Standard Field Mapping and Taxonomy Term Mapping sections. </p>
<a name="iptc_exif_mapping_with_templates"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>EXIF/Template mapping with Content Templates</h4>
<p>
If you code the "template:" prefix at the beginning of the EXIF/Template value you have all the power of Content Templates at your disposal. Do <strong>not</strong> add the "[+" and "+]" delimeters; the prefix is all you need.
</p>
<p>
Within a template, all of the <a href="#field_level_data_sources">Data sources for custom field mapping</a> are available. For example, you can code <code>[+pixels+]</code> or <code>[+size_keys,single+]</code>.
</p>
<p>
You can use a template to compose a value from multiple data sources, e.g., "<code>Taken with [+meta:camera+] at [+dimensions+] using ISO [+exif:ISOSpeedRatings,single+] and [+exif:ExposureTime+] exposure time</code>".
<p>
</p>
You can use a template to compose a value from alternative data sources, depending on which fields are populated for a given attachment. For example, "<code>[+iptc:2#020+]|[+iptc:2#025+]|none</code>" will use the IPTC supplemental-category field, if populated, then the IPTC keywords field, if populated, or the literal "none" if neither IPTC field contains a value.
</p>
<p>
Using a template in the "Standard field mapping" or "Custom field mapping" tables will yield a text result. For example, multiple IPTC keywords would be converted into a comma-delimited list as a string. In the "Taxonomy term mapping" table the template will deliver an array result if the fields inside the template have multiple values. For example, you can code "<code>template:([+iptc:2#020+])([+iptc:2#025+])</code>" to store each of the IPTC supplemental-category <em><strong>and</strong></em> keywords values (there is no "|" in the template) as a separate taxonomy term. Note that each of the fields is enclosed in parentheses, so the field is suppressed if it contains no values.
</p>
<p>
In the "Standard field mapping" table a special <code>template:[+empty+]</code> value supports deleting the content of the Title, Caption, Description and ALT Text fields. This value is also available in the Media/Assistant submenu table Bulk Edit area.
</p>
<p>
Note that the <strong>,array</strong> formatting option is <strong>not</strong> required to get an array result for the field in a Taxonomy term mapping template; it is assumed. If you want a <strong>text</strong>, <strong>single</strong> or <strong>export</strong> result you can add one of those formatting options to your field specification.
</p>
<a name="pdf_iptc_exif_mapping"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>IPTC/EXIF Mapping for PDF Documents</h4>
<p>
You can use Content Templates in the EXIF/Template Value text box to extract metadata from your PDF documents and add it to the Standard Fields and Taxonomy Terms of your Media Library items. The templates can be coded to select the appropriate source whether the item is a PDF document or an image. Here are three rules for metadata contained in PDF documents:
</p>
<table>
<tr style="font-weight: bold">
<td style="padding-right: 10px; text-align: right">Field</td>
<td>EXIF/Template Value</td>
<td>Priority</td>
<td>Existing Text</td>
<td>Delimiter(s)</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; text-align: right; font-weight:bold">Title:</td>
<td style="padding-right: 10px; vertical-align: top">template:([+pdf:Title+])</td>
<td>EXIF</td>
<td>Replace</td>
<td>&nbsp;</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; text-align: right; font-weight:bold">Caption:</td>
<td style="padding-right: 10px; vertical-align: top">template:([+pdf:Subject+])</td>
<td>EXIF</td>
<td>Replace</td>
<td>&nbsp;</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; text-align: right; font-weight:bold">Att. Categories:</td>
<td style="padding-right: 10px; vertical-align: top">template:([+pdf:Keywords,array+])</td>
<td>EXIF</td>
<td>Replace</td>
<td>;,</td>
</tr>
</table>
<p>
The three rules have a similar structure:
<ul style="line-height: 1em; list-style-type:disc; margin-left: 20px ">
<li>"template:" (goes in the text box below "EXIF/Template Value") is used to access the pdf: values instead of the EXIF values.</li>
<li>The values are surrounded by parentheses "(" and ")" so they will return an empty string for documents without meta data in the field and for other items such as images.
</li>
<li>I have selected "Replace" to overwrite the existing text, because a default Title was assigned to the items when they were uploaded. You can change this to "Keep" if you already have values in one or more of the fields that you want to retain.
</li>
</ul>
The taxonomy rule also has the ",array" option to return multiple keywords as individual array elements that can be converted to taxonomy terms. For this rule, the "Delimiter(s)" text box contains a comma and a semicolon, which should cover most of the documents you will encounter.
</p>
<p>
If your Media Library contains a mix of images and PDF documents you will want a more flexible rule to map metadata from different sources in each MIME type. You can extend the rules as follows:
</p>
<table>
<tr style="font-weight: bold">
<td style="padding-right: 10px; text-align: right">Field</td>
<td>EXIF/Template Value</td>
<td>Priority</td>
<td>Existing Text</td>
<td>Delimiter(s)</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; text-align: right; font-weight:bold">Title:</td>
<td style="padding-right: 10px; vertical-align: top">template:([+pdf:Title+]|[+exif:Title+])</td>
<td>EXIF</td>
<td>Replace</td>
<td>&nbsp;</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; text-align: right; font-weight:bold">Caption:</td>
<td style="padding-right: 10px; vertical-align: top">template:([+pdf:Subject+]|[+exif:ImageDescription+])</td>
<td>EXIF</td>
<td>Replace</td>
<td>&nbsp;</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; text-align: right; font-weight:bold">Att. Categories:</td>
<td style="padding-right: 10px; vertical-align: top">template:([+pdf:Keywords,array+]|[+iptc:2#025+])</td>
<td>EXIF</td>
<td>Replace</td>
<td>;,</td>
</tr>
</table>
<p>
The three rules have similar changes:
<ul style="line-height: 1em; list-style-type:disc; margin-left: 20px ">
<li>A vertical bar ("|") separates the two data source specifications. This is the Content Template "Choice" operator, which takes the first non-blank alternative from among the choices.</li>
<li>A second data source for images. The PDF documents will not have "exif:"/"iptc:" data sources, and images will not have "pdf:" data sources, so only one (at most) of the two alternatives will be non-blank.
</li>
</ul>
In fact, WordPress contains its own rules for composing a Title from IPTC/Exif metadata (see <a href="#wordpress_default_mapping">WordPress default title, slug and description mapping</a>), so you may not need or want to extend the Title rule. WordPress also fills the Description field, but does not fill the Caption. You may want to copy the Description into the Caption; if you do, replace <code>[+exif:ImageDescription+]</code> with <code>[+post_content+]</code> in the Caption rule.
</p>
<a name="other_iptc_exif_mapping"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Other mapping techniques</h4>
<p>
There are two other ways you can perform metadata mapping to one or more existing Media Library images:
<dl>
<dt>Single Item Edit/Edit Media screen</dt>
<dd>For WordPress 3.5 and later, you can click the "Map IPTC/EXIF metadata" link in the "Image Metadata" postbox to apply the standing mapping rules to a single attachment.  For WordPress 3.4.x and earlier, you can click the "Map IPTC/EXIF metadata" button on the Single Item Edit screen to apply the standing mapping rules.
</dd>
<dt>Bulk Action edit area</dt>
<dd>To perform mapping for a group of attachments you can use the Bulk Action facility on the main Assistant screen. Check the attachments you want to map, select "edit" from the Bulk Actions dropdown list and click "Apply". The bulk edit area will open with a list of the checked attachments in the left-hand column. You can click the "Map IPTC/EXIF metadata" button in the lower left corner of the area to apply the standing mapping rules to the attachments in the list.
</dd>
</dl>
</p>
<a name="wordpress_default_mapping"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>WordPress default title, slug and description mapping</h4>
<p>
When WordPress uploads a new image file that contains IPTC and EXIF metadata it automatically maps metadata values to the title (post_title), name/slug (post_name) and description (post_content) fields. This happens before the MLA mapping rules are applied, so if you want to override the default mapping you must select "Replace" in the "Existing Text" column.
</p>
<p>
The WordPress rules are somewhat complex; consult the source code if you need exact details. Roughly speaking, the priority order for mapping the post_title and post_name values from non-blank IPTC/EXIF metadata is:
<ol style="line-height: 1.25em;  margin-left: 20px ">
<li>EXIF "Title"</li>
<li>EXIF "ImageDescription" (if less than 80 characters)</li>
<li>IPTC 2#105 "headline"</li>
<li>IPTC 2#005 "object-name"</li>
<li>IPTC 2#120 "caption-or-abstract" (if less than 80 characters)</li>
</ol>
The priority order for mapping the post_content value from non-blank IPTC/EXIF metadata is:
<ol style="line-height: 1.25em;  margin-left: 20px ">
<li>EXIF "ImageDescription" (if different from post_title)</li>
<li>IPTC 2#120 "caption-or-abstract" (if different from post_title)</li>
</ol>
</p>
<a name="mla_mapping_hooks"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>MLA Custom Field and IPTC/EXIF Mapping Actions and Filters (Hooks)</h3>
<p>
The Custom Field and IPTC/EXIF Mapping tools support a comprehensive set of filters and actions that give you complete control over rule execution and value creation from PHP code in your theme or in another plugin. An example of using the hooks from a simple, stand-alone plugin can be found here: <a title="View the Mapping Hooks Example source code" href="[+examples_url+]mla-mapping-hooks-example.php.txt" target="_blank" style="font-size:14px; font-weight:bold">mla-mapping-hooks-example.php.txt</a>. To run the example:
<ol>
<li>Edit the code to uncomment the <code>error_log()</code> calls so you can see what is passed to the hooks you are interested in.</li>
<li>Remove the ".txt" extension and save the "mla-mapping-hooks-example.php" file in your plugins directory.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA Mapping Hooks Example" plugin.</li>
<li>Upload a new attachment and/or run the mapping rules to exercise the filters and write mapping information to the site's Error Log.</li>
<li>Examine the Error Log to see the mapping information.</li>
</ol>
</p>
<p>
The example code documents each hook with comments in the filter/action function that intercepts each hook. There are hooks that run at the beginning and end of the overall mapping operation as well as hooks for each mapping rule. 
</p>
<p>
In addition, there are hooks that run when attachments are uploaded to the Media Library and when the "attachment metadata" is altered, e.g., when the Media/Edit Media "Edit Image" function is used. Plugins and other image editing code can destroy the attachment metadata or the IPTC/EXIF metadata embedded in an image file. These hooks may give you an opportunity to preserve and repair the metadata you need in spite of such damage.
</p>
<p>
The current mapping hooks are:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_begin_mapping</td>
<td>called once, before mapping rules for any/all attachment(s) are executed.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_mapping_settings</td>
<td>called once for each attachment, before any mapping rules are executed. You can add, change or delete rules from the settings/rules array.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_mapping_rule</td>
<td>called once for each mapping rule, before the rule is evaluated. You can change the rule parameters, or prevent rule evaluation.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_mapping_custom_value</td>
<td>called once for each custom field mapping rule, after the rule is evaluated. You can change the new value produced by the rule.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_mapping_iptc_value</td>
<td>called once for each IPTC/EXIF mapping rule, after the IPTC portion of the rule is evaluated. You can change the new value produced by the rule.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_mapping_exif_value</td>
<td>called once for each IPTC/EXIF mapping rule, after the EXIF portion of the rule is evaluated. You can change the new value produced by the rule.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_mapping_updates</td>
<td>called AFTER all mapping rules are applied. You can add, change or remove updates for the attachment's standard fields, taxonomies and/or custom fields.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_end_mapping</td>
<td>called once, after mapping rules for any/all attachment(s) are executed. This is a good place to close files, perform cleanup, etc.</td>
</tr>
</table>
<p>
A second example plugin, <a title="View the Mapping Hooks Example source code" href="[+examples_url+]mla-metadata-mapping-hooks-example.php.txt" target="_blank" style="font-size:14px; font-weight:bold">mla-metadata-mapping-hooks-example.php.txt</a>, illustrates the metadata hooks. The current insert attachment/update attachment metadata hooks are:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_upload_prefilter</td>
<td>gives you an opportunity to record the original IPTC, EXIF and
WordPress image_metadata <strong>before</strong> the file is stored in the Media Library.
You can also modify the file name that will be used in the Media Library.
<br />&nbsp;<br />
Many plugins and image editing functions alter or destroy this information,
so this may be your last change to preserve it.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_upload_filter</td>
<td>gives you an opportunity to record some additional metadata
for audio and video media <strong>after</strong> the file is stored in the Media Library.
</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_add_attachment</td>
<td>called at the end of the wp_insert_attachment() function,
after the file is in place and the post object has been created in the database.
<br />&nbsp;<br />
By this time, other plugins have probably run their own 'add_attachment' filters
and done their work/damage to metadata, etc.
</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_update_attachment<br />_metadata_options</td>
<td>lets you inspect or change the processing options that will
control the MLA mapping rules in the update_attachment_metadata filter.
</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_update_attachment<br />_metadata_prefilter</td>
<td>called at the end of the wp_update_attachment_metadata() function,
<strong>before</strong> any MLA mapping rules are applied. The prefilter gives you an
opportunity to record or update the metadata before the mapping.
<br />&nbsp;<br />
The wp_update_attachment_metadata() function is called at the end of the file upload process and at several later points, such as when an image attachment is edited or by
plugins that alter the attachment file.
</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_update_attachment<br />_metadata_postfilter</td>
<td>This filter is called <strong>after</strong> MLA mapping rules are applied during
wp_update_attachment_metadata() processing. The postfilter gives you
an opportunity to record or update the metadata after the mapping.
</td>
</tr>
</table>
<p>
The current Settings/Media Library Assistant tab list hook is:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_get_options_tablist</td>
<td>gives you an opportunity to remove one or more tabs from the list that appears on the Settings/Media Library Assistant screen.</td>
</tr>
</table>
<a name="mla_debug_tab"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>MLA Debug Tab</h3>
<p>
If you are having trouble with some part of Media Library Assistant it may be helpful to look at the PHP error log. MLA writes messages to the log for a variety of reasons, and the information thay contain can be very helpful in finding the cause of a problem and resolving it.
</p>
<p>
To add the Debug tab to your Settings/Media Library Assistant submenu you must add an entry to your <code>wp-config.php</code> file:
<ul>
<li><code>define( 'MLA_DEBUG_LEVEL', 1 );</code></li>
</ul>
<p>
Once that line is added to the <code>wp-config.php</code> file the "Debug" tab will appear at the right of the tab list in the Settings/Media Library Assistant submenu. In addition, the value <code>MLA_DEBUG_LEVEL</code> will appear in the submenu title to remind you it has been set.
</p>
<p>
The Debug Options screen begins with an "Error Log" title, followed by the PHP error reporting level in parentheses. Below the title is a text box with the current content of the PHP error log file. Below the text box are three action buttons:
</p>
<ul>
<li><strong>Download</strong> - click this button to download a copy of the error log to your system.</li>
<li><strong>Reset</strong> - click this button to erase the contents of the error log.</li>
<li><strong>Save Changes</strong> - this button doesn't do anything useful in the current MLA version.</li>
</ul>
<p>
If you are having an MLA problem that includes error messages in the log, copying the messages and adding them to your Support Forum topic can be most helpful; thanks!
<a name="mla_list_table_hooks"></a>&nbsp;
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Media/Assistant Submenu Actions and Filters (Hooks)</h3>
<p>
The Media/Assistant submenu supports a comprehensive set of filters and actions that give you control over table columns, inline actions and bulk actions from PHP code in your theme or in another plugin. An example of using the hooks from a simple, stand-alone plugin can be found here: <a title="View the Media/Assistant Submenu Example source code" href="[+examples_url+]mla-list-table-hooks-example.php.txt" target="_blank" style="font-size:14px; font-weight:bold">mla-list-table-hooks-example.php.txt</a>. To run the example:
<ol>
<li>Edit the code to uncomment the <code>error_log()</code> calls so you can see what is passed to the hooks you are interested in.</li>
<li>Remove the ".txt" extension and save the "mla-list-table-hooks-example.php" file in your plugins directory.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA List Table Hooks Example" plugin.</li>
<li>Go to the Media/Assistant submenu to exercise the filters and write filter/action information to the site's Error Log.</li>
<li>Examine the Error Log to see the filter/action information.</li>
</ol>
</p>
<p>
The example code documents each hook with comments in the filter/action function that intercepts each hook. There are hooks that let you add, modify or delete table columns. 
</p>
<p>
In addition, there are hooks that run when the Media Library items are selected from the database and hooks for adding and processing custom quick actions and bulk actions.
</p>
<p>
The following hooks are defined in <code>/wp-admin/includes/class-wp-list-table.php</code>:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">views_media_page_mla_menu</td>
<td>Filter the list of available list table views.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">bulk_actions-media_page_mla-menu</td>
<td>Filter the list table Bulk Actions drop-down. This WordPress filter can currently only be used to remove bulk actions.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">months_dropdown_results</td>
<td>Filter the 'Months' drop-down results.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_entries_per_page</td>
<td>Filter the number of items to be displayed on each page of the list table.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">manage_media_page_mla-menu_sortable_columns</td>
<td>Filter the list table sortable columns for a specific screen.</td>
</tr>
</table>
<p>
The following hooks are defined in <code>/wp-admin/includes/class-mla-data.php</code>:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_search_filter_fields</td>
<td>Gives you an opportunity to add or remove any of the MLA standard fields for Search Media.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_search_filter_inner_clause</td>
<td>Gives you an opportunity to modify or add to the inner WHERE clause for Search Media.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_fetch_attachment_references</td>
<td>Gives you an opportunity to modify or add to the "where-used" reference reporting information.</td>
</tr>
</table>
<p>
The following hooks are defined in <code>/media-library-assistant/includes/class-mla-main.php</code>:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_inline_fields</td>
<td>Gives you an opportunity to name the fields passed to the JavaScript functions for Quick editing.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_inline_action</td>
<td>Gives you an opportunity to pre-process an MLA_List_Table "Quick Edit" action before the MLA handler.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_bulk_action_initial_request</td>
<td>Gives you an opportunity to pre-process the request parameters for a bulk action before the action begins. DO NOT assume parameters come from the $_REQUEST super array!</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_begin_bulk_action</td>
<td>Gives you an opportunity to pre-process an MLA_List_Table bulk action, standard or custom, before the MLA handler. The filter is called once before any of the items in $_REQUEST['cb_attachment'] are processed.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_bulk_action_item_request</td>
<td>Gives you an opportunity to pre-process the request parameters for each item during a bulk action. DO NOT assume parameters come from the $_REQUEST super array!</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_bulk_action</td>
<td>Gives you an opportunity to pre-process an MLA_List_Table bulk action, standard or custom, before the MLA handler. The filter is called once for each of the items in $_REQUEST['cb_attachment'].</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_custom_bulk_action</td>
<td>Gives you an opportunity to process an MLA_List_Table bulk action that MLA does not recognize. The filter is called once for each of the items in $_REQUEST['cb_attachment'].</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_end_bulk_action</td>
<td>Gives you an opportunity to post-process an MLA_List_Table bulk action, standard or custom. The filter is called once after all of the items in $_REQUEST['cb_attachment'] are processed.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_single_action</td>
<td>Gives you an opportunity to pre-process an MLA_List_Table page-level or single-item action, standard or custom, before the MLA handler.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_custom_single_action</td>
<td>Gives you an opportunity to process an MLA_List_Table page-level or single-item action that MLA does not recognize.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_clear_filter_by</td>
<td>Gives you an opportunity to clear any custom submenu "Filter-by" parameters.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_new_instance</td>
<td>Gives you an opportunity to extend the MLA_List_Table class.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_inline_values</td>
<td>Gives you a chance to modify and extend the substitution values for the Quick and Bulk Edit forms.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_inline_template</td>
<td>Gives you a chance to modify and extend the template used for the Quick and Bulk Edit forms.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_inline_parse</td>
<td>Gives you a final chance to modify and extend the HTML markup used for the Quick and Bulk Edit forms.</td>
</tr>
</table>
<p>
The following hooks are defined in <code>/wp-admin/includes/class-wp-list-table.php</code>:
</p>
<table>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_get_columns</td>
<td>This MLA-specific filter gives you an opportunity to filter the list table columns.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_get_hidden_columns</td>
<td>This MLA-specific filter gives you an opportunity to filter the hidden list table columns.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_get_sortable_columns</td>
<td>This MLA-specific filter gives you an opportunity to filter the sortable list table columns; a good alternative to the 'manage_media_page_mla_menu_sortable_columns' filter.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_get_bulk_actions</td>
<td>This MLA-specific filter gives you an opportunity to filter the list of bulk actions; a good alternative to the 'bulk_actions-media_page_mla-menu' filter.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_column_default</td>
<td>Called when the MLA_List_Table can't find a value for a given column.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_submenu_arguments</td>
<td>Gives you an opportunity to filter the URL parameters that will be retained when the submenu page refreshes.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_prepare_items_pagination</td>
<td>Gives you an opportunity to filter the per_page and current_page parameters used for the prepare_items database query.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_prepare_items_total_items</td>
<td>Gives you an opportunity to substitute your own $total_items parameter used for the prepare_items database query.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_prepare_items_the_items</td>
<td>Gives you an opportunity to substitute your own items array in place of the default prepare_items database query.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_prepare_items</td>
<td>Gives you an opportunity to record or modify the results of the prepare_items database query. </td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_build_rollover_actions</td>
<td>Gives you an opportunity to filter the list of "Rollover" actions giving item-level links such as "Quick Edit", "Move to Trash".</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">mla_list_table_build_inline_data</td>
<td>Gives you an opportunity to filter the data passed to the JavaScript functions for Quick and Bulk editing.</td>
</tr>
<tr>
<td style="padding-right: 10px; vertical-align: top; font-weight:bold">views_upload</td>
<td>Views for the "upload" page when WPML is active. This filter is hooked by WPML Media in wpml-media.class.php, and is only applied when WPML is active.</td>
</tr>
</table>
<p>
<a href="#backtotop">Go to Top</a>
</p>
</div>